/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.DelegationPermission;
import software.amazon.awssdk.services.iam.model.StateType;
import software.amazon.awssdk.services.iam.model._rolePermissionRestrictionArnListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DelegationRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DelegationRequest> {
    private static final SdkField<String> DELEGATION_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DelegationRequestId").getter(DelegationRequest.getter(DelegationRequest::delegationRequestId)).setter(DelegationRequest.setter(Builder::delegationRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationRequestId").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(DelegationRequest.getter(DelegationRequest::ownerAccountId)).setter(DelegationRequest.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DelegationRequest.getter(DelegationRequest::description)).setter(DelegationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> REQUEST_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestMessage").getter(DelegationRequest.getter(DelegationRequest::requestMessage)).setter(DelegationRequest.setter(Builder::requestMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestMessage").build()}).build();
    private static final SdkField<DelegationPermission> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Permissions").getter(DelegationRequest.getter(DelegationRequest::permissions)).setter(DelegationRequest.setter(Builder::permissions)).constructor(DelegationPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build()}).build();
    private static final SdkField<String> PERMISSION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionPolicy").getter(DelegationRequest.getter(DelegationRequest::permissionPolicy)).setter(DelegationRequest.setter(Builder::permissionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionPolicy").build()}).build();
    private static final SdkField<List<String>> ROLE_PERMISSION_RESTRICTION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RolePermissionRestrictionArns").getter(DelegationRequest.getter(DelegationRequest::rolePermissionRestrictionArns)).setter(DelegationRequest.setter(Builder::rolePermissionRestrictionArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolePermissionRestrictionArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(DelegationRequest.getter(DelegationRequest::ownerId)).setter(DelegationRequest.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> APPROVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApproverId").getter(DelegationRequest.getter(DelegationRequest::approverId)).setter(DelegationRequest.setter(Builder::approverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproverId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DelegationRequest.getter(DelegationRequest::stateAsString)).setter(DelegationRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> REQUESTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestorId").getter(DelegationRequest.getter(DelegationRequest::requestorId)).setter(DelegationRequest.setter(Builder::requestorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestorId").build()}).build();
    private static final SdkField<String> REQUESTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestorName").getter(DelegationRequest.getter(DelegationRequest::requestorName)).setter(DelegationRequest.setter(Builder::requestorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestorName").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(DelegationRequest.getter(DelegationRequest::createDate)).setter(DelegationRequest.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<Integer> SESSION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionDuration").getter(DelegationRequest.getter(DelegationRequest::sessionDuration)).setter(DelegationRequest.setter(Builder::sessionDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionDuration").build()}).build();
    private static final SdkField<String> REDIRECT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedirectUrl").getter(DelegationRequest.getter(DelegationRequest::redirectUrl)).setter(DelegationRequest.setter(Builder::redirectUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectUrl").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(DelegationRequest.getter(DelegationRequest::notes)).setter(DelegationRequest.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<String> REJECTION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RejectionReason").getter(DelegationRequest.getter(DelegationRequest::rejectionReason)).setter(DelegationRequest.setter(Builder::rejectionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectionReason").build()}).build();
    private static final SdkField<Boolean> ONLY_SEND_BY_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OnlySendByOwner").getter(DelegationRequest.getter(DelegationRequest::onlySendByOwner)).setter(DelegationRequest.setter(Builder::onlySendByOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlySendByOwner").build()}).build();
    private static final SdkField<Instant> UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTime").getter(DelegationRequest.getter(DelegationRequest::updatedTime)).setter(DelegationRequest.setter(Builder::updatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATION_REQUEST_ID_FIELD, OWNER_ACCOUNT_ID_FIELD, DESCRIPTION_FIELD, REQUEST_MESSAGE_FIELD, PERMISSIONS_FIELD, PERMISSION_POLICY_FIELD, ROLE_PERMISSION_RESTRICTION_ARNS_FIELD, OWNER_ID_FIELD, APPROVER_ID_FIELD, STATE_FIELD, REQUESTOR_ID_FIELD, REQUESTOR_NAME_FIELD, CREATE_DATE_FIELD, SESSION_DURATION_FIELD, REDIRECT_URL_FIELD, NOTES_FIELD, REJECTION_REASON_FIELD, ONLY_SEND_BY_OWNER_FIELD, UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DelegationRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String delegationRequestId;
    private final String ownerAccountId;
    private final String description;
    private final String requestMessage;
    private final DelegationPermission permissions;
    private final String permissionPolicy;
    private final List<String> rolePermissionRestrictionArns;
    private final String ownerId;
    private final String approverId;
    private final String state;
    private final String requestorId;
    private final String requestorName;
    private final Instant createDate;
    private final Integer sessionDuration;
    private final String redirectUrl;
    private final String notes;
    private final String rejectionReason;
    private final Boolean onlySendByOwner;
    private final Instant updatedTime;

    private DelegationRequest(BuilderImpl builder) {
        this.delegationRequestId = builder.delegationRequestId;
        this.ownerAccountId = builder.ownerAccountId;
        this.description = builder.description;
        this.requestMessage = builder.requestMessage;
        this.permissions = builder.permissions;
        this.permissionPolicy = builder.permissionPolicy;
        this.rolePermissionRestrictionArns = builder.rolePermissionRestrictionArns;
        this.ownerId = builder.ownerId;
        this.approverId = builder.approverId;
        this.state = builder.state;
        this.requestorId = builder.requestorId;
        this.requestorName = builder.requestorName;
        this.createDate = builder.createDate;
        this.sessionDuration = builder.sessionDuration;
        this.redirectUrl = builder.redirectUrl;
        this.notes = builder.notes;
        this.rejectionReason = builder.rejectionReason;
        this.onlySendByOwner = builder.onlySendByOwner;
        this.updatedTime = builder.updatedTime;
    }

    public final String delegationRequestId() {
        return this.delegationRequestId;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final String description() {
        return this.description;
    }

    public final String requestMessage() {
        return this.requestMessage;
    }

    public final DelegationPermission permissions() {
        return this.permissions;
    }

    public final String permissionPolicy() {
        return this.permissionPolicy;
    }

    public final boolean hasRolePermissionRestrictionArns() {
        return this.rolePermissionRestrictionArns != null && !(this.rolePermissionRestrictionArns instanceof SdkAutoConstructList);
    }

    public final List<String> rolePermissionRestrictionArns() {
        return this.rolePermissionRestrictionArns;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String approverId() {
        return this.approverId;
    }

    public final StateType state() {
        return StateType.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String requestorId() {
        return this.requestorId;
    }

    public final String requestorName() {
        return this.requestorName;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final Integer sessionDuration() {
        return this.sessionDuration;
    }

    public final String redirectUrl() {
        return this.redirectUrl;
    }

    public final String notes() {
        return this.notes;
    }

    public final String rejectionReason() {
        return this.rejectionReason;
    }

    public final Boolean onlySendByOwner() {
        return this.onlySendByOwner;
    }

    public final Instant updatedTime() {
        return this.updatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.delegationRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRolePermissionRestrictionArns() ? this.rolePermissionRestrictionArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.approverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectionReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlySendByOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegationRequest)) {
            return false;
        }
        DelegationRequest other = (DelegationRequest)obj;
        return Objects.equals(this.delegationRequestId(), other.delegationRequestId()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.requestMessage(), other.requestMessage()) && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.permissionPolicy(), other.permissionPolicy()) && this.hasRolePermissionRestrictionArns() == other.hasRolePermissionRestrictionArns() && Objects.equals(this.rolePermissionRestrictionArns(), other.rolePermissionRestrictionArns()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.approverId(), other.approverId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.requestorId(), other.requestorId()) && Objects.equals(this.requestorName(), other.requestorName()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.sessionDuration(), other.sessionDuration()) && Objects.equals(this.redirectUrl(), other.redirectUrl()) && Objects.equals(this.notes(), other.notes()) && Objects.equals(this.rejectionReason(), other.rejectionReason()) && Objects.equals(this.onlySendByOwner(), other.onlySendByOwner()) && Objects.equals(this.updatedTime(), other.updatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"DelegationRequest").add("DelegationRequestId", (Object)this.delegationRequestId()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("Description", (Object)this.description()).add("RequestMessage", (Object)this.requestMessage()).add("Permissions", (Object)this.permissions()).add("PermissionPolicy", (Object)this.permissionPolicy()).add("RolePermissionRestrictionArns", this.hasRolePermissionRestrictionArns() ? this.rolePermissionRestrictionArns() : null).add("OwnerId", (Object)this.ownerId()).add("ApproverId", (Object)this.approverId()).add("State", (Object)this.stateAsString()).add("RequestorId", (Object)this.requestorId()).add("RequestorName", (Object)this.requestorName()).add("CreateDate", (Object)this.createDate()).add("SessionDuration", (Object)this.sessionDuration()).add("RedirectUrl", (Object)this.redirectUrl()).add("Notes", (Object)this.notes()).add("RejectionReason", (Object)this.rejectionReason()).add("OnlySendByOwner", (Object)this.onlySendByOwner()).add("UpdatedTime", (Object)this.updatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DelegationRequestId": {
                return Optional.ofNullable(clazz.cast(this.delegationRequestId()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RequestMessage": {
                return Optional.ofNullable(clazz.cast(this.requestMessage()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "PermissionPolicy": {
                return Optional.ofNullable(clazz.cast(this.permissionPolicy()));
            }
            case "RolePermissionRestrictionArns": {
                return Optional.ofNullable(clazz.cast(this.rolePermissionRestrictionArns()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "ApproverId": {
                return Optional.ofNullable(clazz.cast(this.approverId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "RequestorId": {
                return Optional.ofNullable(clazz.cast(this.requestorId()));
            }
            case "RequestorName": {
                return Optional.ofNullable(clazz.cast(this.requestorName()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "SessionDuration": {
                return Optional.ofNullable(clazz.cast(this.sessionDuration()));
            }
            case "RedirectUrl": {
                return Optional.ofNullable(clazz.cast(this.redirectUrl()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "RejectionReason": {
                return Optional.ofNullable(clazz.cast(this.rejectionReason()));
            }
            case "OnlySendByOwner": {
                return Optional.ofNullable(clazz.cast(this.onlySendByOwner()));
            }
            case "UpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.updatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DelegationRequestId", DELEGATION_REQUEST_ID_FIELD);
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RequestMessage", REQUEST_MESSAGE_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("PermissionPolicy", PERMISSION_POLICY_FIELD);
        map.put("RolePermissionRestrictionArns", ROLE_PERMISSION_RESTRICTION_ARNS_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("ApproverId", APPROVER_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("RequestorId", REQUESTOR_ID_FIELD);
        map.put("RequestorName", REQUESTOR_NAME_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("SessionDuration", SESSION_DURATION_FIELD);
        map.put("RedirectUrl", REDIRECT_URL_FIELD);
        map.put("Notes", NOTES_FIELD);
        map.put("RejectionReason", REJECTION_REASON_FIELD);
        map.put("OnlySendByOwner", ONLY_SEND_BY_OWNER_FIELD);
        map.put("UpdatedTime", UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DelegationRequest, T> g) {
        return obj -> g.apply((DelegationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String delegationRequestId;
        private String ownerAccountId;
        private String description;
        private String requestMessage;
        private DelegationPermission permissions;
        private String permissionPolicy;
        private List<String> rolePermissionRestrictionArns = DefaultSdkAutoConstructList.getInstance();
        private String ownerId;
        private String approverId;
        private String state;
        private String requestorId;
        private String requestorName;
        private Instant createDate;
        private Integer sessionDuration;
        private String redirectUrl;
        private String notes;
        private String rejectionReason;
        private Boolean onlySendByOwner;
        private Instant updatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DelegationRequest model) {
            this.delegationRequestId(model.delegationRequestId);
            this.ownerAccountId(model.ownerAccountId);
            this.description(model.description);
            this.requestMessage(model.requestMessage);
            this.permissions(model.permissions);
            this.permissionPolicy(model.permissionPolicy);
            this.rolePermissionRestrictionArns(model.rolePermissionRestrictionArns);
            this.ownerId(model.ownerId);
            this.approverId(model.approverId);
            this.state(model.state);
            this.requestorId(model.requestorId);
            this.requestorName(model.requestorName);
            this.createDate(model.createDate);
            this.sessionDuration(model.sessionDuration);
            this.redirectUrl(model.redirectUrl);
            this.notes(model.notes);
            this.rejectionReason(model.rejectionReason);
            this.onlySendByOwner(model.onlySendByOwner);
            this.updatedTime(model.updatedTime);
        }

        public final String getDelegationRequestId() {
            return this.delegationRequestId;
        }

        public final void setDelegationRequestId(String delegationRequestId) {
            this.delegationRequestId = delegationRequestId;
        }

        @Override
        public final Builder delegationRequestId(String delegationRequestId) {
            this.delegationRequestId = delegationRequestId;
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRequestMessage() {
            return this.requestMessage;
        }

        public final void setRequestMessage(String requestMessage) {
            this.requestMessage = requestMessage;
        }

        @Override
        public final Builder requestMessage(String requestMessage) {
            this.requestMessage = requestMessage;
            return this;
        }

        public final DelegationPermission.Builder getPermissions() {
            return this.permissions != null ? this.permissions.toBuilder() : null;
        }

        public final void setPermissions(DelegationPermission.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(DelegationPermission permissions) {
            this.permissions = permissions;
            return this;
        }

        public final String getPermissionPolicy() {
            return this.permissionPolicy;
        }

        public final void setPermissionPolicy(String permissionPolicy) {
            this.permissionPolicy = permissionPolicy;
        }

        @Override
        public final Builder permissionPolicy(String permissionPolicy) {
            this.permissionPolicy = permissionPolicy;
            return this;
        }

        public final Collection<String> getRolePermissionRestrictionArns() {
            if (this.rolePermissionRestrictionArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rolePermissionRestrictionArns;
        }

        public final void setRolePermissionRestrictionArns(Collection<String> rolePermissionRestrictionArns) {
            this.rolePermissionRestrictionArns = _rolePermissionRestrictionArnListTypeCopier.copy(rolePermissionRestrictionArns);
        }

        @Override
        public final Builder rolePermissionRestrictionArns(Collection<String> rolePermissionRestrictionArns) {
            this.rolePermissionRestrictionArns = _rolePermissionRestrictionArnListTypeCopier.copy(rolePermissionRestrictionArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rolePermissionRestrictionArns(String ... rolePermissionRestrictionArns) {
            this.rolePermissionRestrictionArns(Arrays.asList(rolePermissionRestrictionArns));
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getApproverId() {
            return this.approverId;
        }

        public final void setApproverId(String approverId) {
            this.approverId = approverId;
        }

        @Override
        public final Builder approverId(String approverId) {
            this.approverId = approverId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StateType state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getRequestorId() {
            return this.requestorId;
        }

        public final void setRequestorId(String requestorId) {
            this.requestorId = requestorId;
        }

        @Override
        public final Builder requestorId(String requestorId) {
            this.requestorId = requestorId;
            return this;
        }

        public final String getRequestorName() {
            return this.requestorName;
        }

        public final void setRequestorName(String requestorName) {
            this.requestorName = requestorName;
        }

        @Override
        public final Builder requestorName(String requestorName) {
            this.requestorName = requestorName;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final Integer getSessionDuration() {
            return this.sessionDuration;
        }

        public final void setSessionDuration(Integer sessionDuration) {
            this.sessionDuration = sessionDuration;
        }

        @Override
        public final Builder sessionDuration(Integer sessionDuration) {
            this.sessionDuration = sessionDuration;
            return this;
        }

        public final String getRedirectUrl() {
            return this.redirectUrl;
        }

        public final void setRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
        }

        @Override
        public final Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public final String getNotes() {
            return this.notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final String getRejectionReason() {
            return this.rejectionReason;
        }

        public final void setRejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
        }

        @Override
        public final Builder rejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
            return this;
        }

        public final Boolean getOnlySendByOwner() {
            return this.onlySendByOwner;
        }

        public final void setOnlySendByOwner(Boolean onlySendByOwner) {
            this.onlySendByOwner = onlySendByOwner;
        }

        @Override
        public final Builder onlySendByOwner(Boolean onlySendByOwner) {
            this.onlySendByOwner = onlySendByOwner;
            return this;
        }

        public final Instant getUpdatedTime() {
            return this.updatedTime;
        }

        public final void setUpdatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
        }

        @Override
        public final Builder updatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public DelegationRequest build() {
            return new DelegationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DelegationRequest> {
        public Builder delegationRequestId(String var1);

        public Builder ownerAccountId(String var1);

        public Builder description(String var1);

        public Builder requestMessage(String var1);

        public Builder permissions(DelegationPermission var1);

        default public Builder permissions(Consumer<DelegationPermission.Builder> permissions) {
            return this.permissions((DelegationPermission)((DelegationPermission.Builder)DelegationPermission.builder().applyMutation(permissions)).build());
        }

        public Builder permissionPolicy(String var1);

        public Builder rolePermissionRestrictionArns(Collection<String> var1);

        public Builder rolePermissionRestrictionArns(String ... var1);

        public Builder ownerId(String var1);

        public Builder approverId(String var1);

        public Builder state(String var1);

        public Builder state(StateType var1);

        public Builder requestorId(String var1);

        public Builder requestorName(String var1);

        public Builder createDate(Instant var1);

        public Builder sessionDuration(Integer var1);

        public Builder redirectUrl(String var1);

        public Builder notes(String var1);

        public Builder rejectionReason(String var1);

        public Builder onlySendByOwner(Boolean var1);

        public Builder updatedTime(Instant var1);
    }
}

