/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.DelegationRequest;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model._delegationRequestsListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDelegationRequestsResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListDelegationRequestsResponse> {
    private static final SdkField<List<DelegationRequest>> DELEGATION_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DelegationRequests").getter(ListDelegationRequestsResponse.getter(ListDelegationRequestsResponse::delegationRequests)).setter(ListDelegationRequestsResponse.setter(Builder::delegationRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DelegationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListDelegationRequestsResponse.getter(ListDelegationRequestsResponse::marker)).setter(ListDelegationRequestsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isTruncated").getter(ListDelegationRequestsResponse.getter(ListDelegationRequestsResponse::isTruncated)).setter(ListDelegationRequestsResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isTruncated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATION_REQUESTS_FIELD, MARKER_FIELD, IS_TRUNCATED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDelegationRequestsResponse.memberNameToFieldInitializer();
    private final List<DelegationRequest> delegationRequests;
    private final String marker;
    private final Boolean isTruncated;

    private ListDelegationRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.delegationRequests = builder.delegationRequests;
        this.marker = builder.marker;
        this.isTruncated = builder.isTruncated;
    }

    public final boolean hasDelegationRequests() {
        return this.delegationRequests != null && !(this.delegationRequests instanceof SdkAutoConstructList);
    }

    public final List<DelegationRequest> delegationRequests() {
        return this.delegationRequests;
    }

    public final String marker() {
        return this.marker;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDelegationRequests() ? this.delegationRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDelegationRequestsResponse)) {
            return false;
        }
        ListDelegationRequestsResponse other = (ListDelegationRequestsResponse)((Object)obj);
        return this.hasDelegationRequests() == other.hasDelegationRequests() && Objects.equals(this.delegationRequests(), other.delegationRequests()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.isTruncated(), other.isTruncated());
    }

    public final String toString() {
        return ToString.builder((String)"ListDelegationRequestsResponse").add("DelegationRequests", this.hasDelegationRequests() ? this.delegationRequests() : null).add("Marker", (Object)this.marker()).add("IsTruncated", (Object)this.isTruncated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DelegationRequests": {
                return Optional.ofNullable(clazz.cast(this.delegationRequests()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "isTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DelegationRequests", DELEGATION_REQUESTS_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("isTruncated", IS_TRUNCATED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDelegationRequestsResponse, T> g) {
        return obj -> g.apply((ListDelegationRequestsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<DelegationRequest> delegationRequests = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Boolean isTruncated;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDelegationRequestsResponse model) {
            super(model);
            this.delegationRequests(model.delegationRequests);
            this.marker(model.marker);
            this.isTruncated(model.isTruncated);
        }

        public final List<DelegationRequest.Builder> getDelegationRequests() {
            List<DelegationRequest.Builder> result = _delegationRequestsListTypeCopier.copyToBuilder(this.delegationRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDelegationRequests(Collection<DelegationRequest.BuilderImpl> delegationRequests) {
            this.delegationRequests = _delegationRequestsListTypeCopier.copyFromBuilder(delegationRequests);
        }

        @Override
        public final Builder delegationRequests(Collection<DelegationRequest> delegationRequests) {
            this.delegationRequests = _delegationRequestsListTypeCopier.copy(delegationRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegationRequests(DelegationRequest ... delegationRequests) {
            this.delegationRequests(Arrays.asList(delegationRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegationRequests(Consumer<DelegationRequest.Builder> ... delegationRequests) {
            this.delegationRequests(Stream.of(delegationRequests).map(c -> (DelegationRequest)((DelegationRequest.Builder)DelegationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        @Override
        public ListDelegationRequestsResponse build() {
            return new ListDelegationRequestsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDelegationRequestsResponse> {
        public Builder delegationRequests(Collection<DelegationRequest> var1);

        public Builder delegationRequests(DelegationRequest ... var1);

        public Builder delegationRequests(Consumer<DelegationRequest.Builder> ... var1);

        public Builder marker(String var1);

        public Builder isTruncated(Boolean var1);
    }
}

