/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.AssertionEncryptionModeType;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSamlProviderRequest
extends IamRequest
implements ToCopyableBuilder<Builder, UpdateSamlProviderRequest> {
    private static final SdkField<String> SAML_METADATA_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SAMLMetadataDocument").getter(UpdateSamlProviderRequest.getter(UpdateSamlProviderRequest::samlMetadataDocument)).setter(UpdateSamlProviderRequest.setter(Builder::samlMetadataDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLMetadataDocument").build()}).build();
    private static final SdkField<String> SAML_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SAMLProviderArn").getter(UpdateSamlProviderRequest.getter(UpdateSamlProviderRequest::samlProviderArn)).setter(UpdateSamlProviderRequest.setter(Builder::samlProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLProviderArn").build()}).build();
    private static final SdkField<String> ASSERTION_ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssertionEncryptionMode").getter(UpdateSamlProviderRequest.getter(UpdateSamlProviderRequest::assertionEncryptionModeAsString)).setter(UpdateSamlProviderRequest.setter(Builder::assertionEncryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssertionEncryptionMode").build()}).build();
    private static final SdkField<String> ADD_PRIVATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddPrivateKey").getter(UpdateSamlProviderRequest.getter(UpdateSamlProviderRequest::addPrivateKey)).setter(UpdateSamlProviderRequest.setter(Builder::addPrivateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddPrivateKey").build()}).build();
    private static final SdkField<String> REMOVE_PRIVATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemovePrivateKey").getter(UpdateSamlProviderRequest.getter(UpdateSamlProviderRequest::removePrivateKey)).setter(UpdateSamlProviderRequest.setter(Builder::removePrivateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemovePrivateKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_METADATA_DOCUMENT_FIELD, SAML_PROVIDER_ARN_FIELD, ASSERTION_ENCRYPTION_MODE_FIELD, ADD_PRIVATE_KEY_FIELD, REMOVE_PRIVATE_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSamlProviderRequest.memberNameToFieldInitializer();
    private final String samlMetadataDocument;
    private final String samlProviderArn;
    private final String assertionEncryptionMode;
    private final String addPrivateKey;
    private final String removePrivateKey;

    private UpdateSamlProviderRequest(BuilderImpl builder) {
        super(builder);
        this.samlMetadataDocument = builder.samlMetadataDocument;
        this.samlProviderArn = builder.samlProviderArn;
        this.assertionEncryptionMode = builder.assertionEncryptionMode;
        this.addPrivateKey = builder.addPrivateKey;
        this.removePrivateKey = builder.removePrivateKey;
    }

    public final String samlMetadataDocument() {
        return this.samlMetadataDocument;
    }

    public final String samlProviderArn() {
        return this.samlProviderArn;
    }

    public final AssertionEncryptionModeType assertionEncryptionMode() {
        return AssertionEncryptionModeType.fromValue(this.assertionEncryptionMode);
    }

    public final String assertionEncryptionModeAsString() {
        return this.assertionEncryptionMode;
    }

    public final String addPrivateKey() {
        return this.addPrivateKey;
    }

    public final String removePrivateKey() {
        return this.removePrivateKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.samlMetadataDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.samlProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assertionEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.addPrivateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.removePrivateKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSamlProviderRequest)) {
            return false;
        }
        UpdateSamlProviderRequest other = (UpdateSamlProviderRequest)((Object)obj);
        return Objects.equals(this.samlMetadataDocument(), other.samlMetadataDocument()) && Objects.equals(this.samlProviderArn(), other.samlProviderArn()) && Objects.equals(this.assertionEncryptionModeAsString(), other.assertionEncryptionModeAsString()) && Objects.equals(this.addPrivateKey(), other.addPrivateKey()) && Objects.equals(this.removePrivateKey(), other.removePrivateKey());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSamlProviderRequest").add("SAMLMetadataDocument", (Object)this.samlMetadataDocument()).add("SAMLProviderArn", (Object)this.samlProviderArn()).add("AssertionEncryptionMode", (Object)this.assertionEncryptionModeAsString()).add("AddPrivateKey", (Object)(this.addPrivateKey() == null ? null : "*** Sensitive Data Redacted ***")).add("RemovePrivateKey", (Object)this.removePrivateKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SAMLMetadataDocument": {
                return Optional.ofNullable(clazz.cast(this.samlMetadataDocument()));
            }
            case "SAMLProviderArn": {
                return Optional.ofNullable(clazz.cast(this.samlProviderArn()));
            }
            case "AssertionEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.assertionEncryptionModeAsString()));
            }
            case "AddPrivateKey": {
                return Optional.ofNullable(clazz.cast(this.addPrivateKey()));
            }
            case "RemovePrivateKey": {
                return Optional.ofNullable(clazz.cast(this.removePrivateKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SAMLMetadataDocument", SAML_METADATA_DOCUMENT_FIELD);
        map.put("SAMLProviderArn", SAML_PROVIDER_ARN_FIELD);
        map.put("AssertionEncryptionMode", ASSERTION_ENCRYPTION_MODE_FIELD);
        map.put("AddPrivateKey", ADD_PRIVATE_KEY_FIELD);
        map.put("RemovePrivateKey", REMOVE_PRIVATE_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSamlProviderRequest, T> g) {
        return obj -> g.apply((UpdateSamlProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String samlMetadataDocument;
        private String samlProviderArn;
        private String assertionEncryptionMode;
        private String addPrivateKey;
        private String removePrivateKey;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSamlProviderRequest model) {
            super(model);
            this.samlMetadataDocument(model.samlMetadataDocument);
            this.samlProviderArn(model.samlProviderArn);
            this.assertionEncryptionMode(model.assertionEncryptionMode);
            this.addPrivateKey(model.addPrivateKey);
            this.removePrivateKey(model.removePrivateKey);
        }

        public final String getSamlMetadataDocument() {
            return this.samlMetadataDocument;
        }

        public final void setSamlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
        }

        @Override
        public final Builder samlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
            return this;
        }

        public final String getSamlProviderArn() {
            return this.samlProviderArn;
        }

        public final void setSamlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
        }

        @Override
        public final Builder samlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
            return this;
        }

        public final String getAssertionEncryptionMode() {
            return this.assertionEncryptionMode;
        }

        public final void setAssertionEncryptionMode(String assertionEncryptionMode) {
            this.assertionEncryptionMode = assertionEncryptionMode;
        }

        @Override
        public final Builder assertionEncryptionMode(String assertionEncryptionMode) {
            this.assertionEncryptionMode = assertionEncryptionMode;
            return this;
        }

        @Override
        public final Builder assertionEncryptionMode(AssertionEncryptionModeType assertionEncryptionMode) {
            this.assertionEncryptionMode(assertionEncryptionMode == null ? null : assertionEncryptionMode.toString());
            return this;
        }

        public final String getAddPrivateKey() {
            return this.addPrivateKey;
        }

        public final void setAddPrivateKey(String addPrivateKey) {
            this.addPrivateKey = addPrivateKey;
        }

        @Override
        public final Builder addPrivateKey(String addPrivateKey) {
            this.addPrivateKey = addPrivateKey;
            return this;
        }

        public final String getRemovePrivateKey() {
            return this.removePrivateKey;
        }

        public final void setRemovePrivateKey(String removePrivateKey) {
            this.removePrivateKey = removePrivateKey;
        }

        @Override
        public final Builder removePrivateKey(String removePrivateKey) {
            this.removePrivateKey = removePrivateKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSamlProviderRequest build() {
            return new UpdateSamlProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSamlProviderRequest> {
        public Builder samlMetadataDocument(String var1);

        public Builder samlProviderArn(String var1);

        public Builder assertionEncryptionMode(String var1);

        public Builder assertionEncryptionMode(AssertionEncryptionModeType var1);

        public Builder addPrivateKey(String var1);

        public Builder removePrivateKey(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

