/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ContainerRecipeSummary;
import software.amazon.awssdk.services.imagebuilder.model.ContainerRecipeSummaryListCopier;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContainerRecipesResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, ListContainerRecipesResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(ListContainerRecipesResponse.getter(ListContainerRecipesResponse::requestId)).setter(ListContainerRecipesResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<List<ContainerRecipeSummary>> CONTAINER_RECIPE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containerRecipeSummaryList").getter(ListContainerRecipesResponse.getter(ListContainerRecipesResponse::containerRecipeSummaryList)).setter(ListContainerRecipesResponse.setter(Builder::containerRecipeSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRecipeSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerRecipeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListContainerRecipesResponse.getter(ListContainerRecipesResponse::nextToken)).setter(ListContainerRecipesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, CONTAINER_RECIPE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final String requestIdValue;
    private final List<ContainerRecipeSummary> containerRecipeSummaryList;
    private final String nextToken;

    private ListContainerRecipesResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.containerRecipeSummaryList = builder.containerRecipeSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final boolean hasContainerRecipeSummaryList() {
        return this.containerRecipeSummaryList != null && !(this.containerRecipeSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ContainerRecipeSummary> containerRecipeSummaryList() {
        return this.containerRecipeSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerRecipeSummaryList() ? this.containerRecipeSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContainerRecipesResponse)) {
            return false;
        }
        ListContainerRecipesResponse other = (ListContainerRecipesResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && this.hasContainerRecipeSummaryList() == other.hasContainerRecipeSummaryList() && Objects.equals(this.containerRecipeSummaryList(), other.containerRecipeSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListContainerRecipesResponse").add("RequestId", (Object)this.requestId()).add("ContainerRecipeSummaryList", this.hasContainerRecipeSummaryList() ? this.containerRecipeSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "containerRecipeSummaryList": {
                return Optional.ofNullable(clazz.cast(this.containerRecipeSummaryList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContainerRecipesResponse, T> g) {
        return obj -> g.apply((ListContainerRecipesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private List<ContainerRecipeSummary> containerRecipeSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContainerRecipesResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.containerRecipeSummaryList(model.containerRecipeSummaryList);
            this.nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final List<ContainerRecipeSummary.Builder> getContainerRecipeSummaryList() {
            List<ContainerRecipeSummary.Builder> result = ContainerRecipeSummaryListCopier.copyToBuilder(this.containerRecipeSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerRecipeSummaryList(Collection<ContainerRecipeSummary.BuilderImpl> containerRecipeSummaryList) {
            this.containerRecipeSummaryList = ContainerRecipeSummaryListCopier.copyFromBuilder(containerRecipeSummaryList);
        }

        @Override
        public final Builder containerRecipeSummaryList(Collection<ContainerRecipeSummary> containerRecipeSummaryList) {
            this.containerRecipeSummaryList = ContainerRecipeSummaryListCopier.copy(containerRecipeSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerRecipeSummaryList(ContainerRecipeSummary ... containerRecipeSummaryList) {
            this.containerRecipeSummaryList(Arrays.asList(containerRecipeSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerRecipeSummaryList(Consumer<ContainerRecipeSummary.Builder> ... containerRecipeSummaryList) {
            this.containerRecipeSummaryList(Stream.of(containerRecipeSummaryList).map(c -> (ContainerRecipeSummary)((ContainerRecipeSummary.Builder)ContainerRecipeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListContainerRecipesResponse build() {
            return new ListContainerRecipesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContainerRecipesResponse> {
        public Builder requestId(String var1);

        public Builder containerRecipeSummaryList(Collection<ContainerRecipeSummary> var1);

        public Builder containerRecipeSummaryList(ContainerRecipeSummary ... var1);

        public Builder containerRecipeSummaryList(Consumer<ContainerRecipeSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

