/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.ComponentSummary;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse;

public class ListComponentBuildVersionsPublisher
implements SdkPublisher<ListComponentBuildVersionsResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListComponentBuildVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListComponentBuildVersionsPublisher(ImagebuilderAsyncClient client, ListComponentBuildVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListComponentBuildVersionsPublisher(ImagebuilderAsyncClient client, ListComponentBuildVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListComponentBuildVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListComponentBuildVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ComponentSummary> componentSummaryList() {
        Function<ListComponentBuildVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.componentSummaryList() != null) {
                return response.componentSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListComponentBuildVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListComponentBuildVersionsResponseFetcher
    implements AsyncPageFetcher<ListComponentBuildVersionsResponse> {
        private ListComponentBuildVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListComponentBuildVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListComponentBuildVersionsResponse> nextPage(ListComponentBuildVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListComponentBuildVersionsPublisher.this.client.listComponentBuildVersions(ListComponentBuildVersionsPublisher.this.firstRequest);
            }
            return ListComponentBuildVersionsPublisher.this.client.listComponentBuildVersions((ListComponentBuildVersionsRequest)((Object)ListComponentBuildVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

