/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.EcrConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageScanningConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageScanningConfiguration> {
    private static final SdkField<Boolean> IMAGE_SCANNING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("imageScanningEnabled").getter(ImageScanningConfiguration.getter(ImageScanningConfiguration::imageScanningEnabled)).setter(ImageScanningConfiguration.setter(Builder::imageScanningEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanningEnabled").build()}).build();
    private static final SdkField<EcrConfiguration> ECR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ecrConfiguration").getter(ImageScanningConfiguration.getter(ImageScanningConfiguration::ecrConfiguration)).setter(ImageScanningConfiguration.setter(Builder::ecrConfiguration)).constructor(EcrConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SCANNING_ENABLED_FIELD, ECR_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageScanningConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean imageScanningEnabled;
    private final EcrConfiguration ecrConfiguration;

    private ImageScanningConfiguration(BuilderImpl builder) {
        this.imageScanningEnabled = builder.imageScanningEnabled;
        this.ecrConfiguration = builder.ecrConfiguration;
    }

    public final Boolean imageScanningEnabled() {
        return this.imageScanningEnabled;
    }

    public final EcrConfiguration ecrConfiguration() {
        return this.ecrConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageScanningEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecrConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageScanningConfiguration)) {
            return false;
        }
        ImageScanningConfiguration other = (ImageScanningConfiguration)obj;
        return Objects.equals(this.imageScanningEnabled(), other.imageScanningEnabled()) && Objects.equals(this.ecrConfiguration(), other.ecrConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ImageScanningConfiguration").add("ImageScanningEnabled", (Object)this.imageScanningEnabled()).add("EcrConfiguration", (Object)this.ecrConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageScanningEnabled": {
                return Optional.ofNullable(clazz.cast(this.imageScanningEnabled()));
            }
            case "ecrConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ecrConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("imageScanningEnabled", IMAGE_SCANNING_ENABLED_FIELD);
        map.put("ecrConfiguration", ECR_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageScanningConfiguration, T> g) {
        return obj -> g.apply((ImageScanningConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean imageScanningEnabled;
        private EcrConfiguration ecrConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageScanningConfiguration model) {
            this.imageScanningEnabled(model.imageScanningEnabled);
            this.ecrConfiguration(model.ecrConfiguration);
        }

        public final Boolean getImageScanningEnabled() {
            return this.imageScanningEnabled;
        }

        public final void setImageScanningEnabled(Boolean imageScanningEnabled) {
            this.imageScanningEnabled = imageScanningEnabled;
        }

        @Override
        public final Builder imageScanningEnabled(Boolean imageScanningEnabled) {
            this.imageScanningEnabled = imageScanningEnabled;
            return this;
        }

        public final EcrConfiguration.Builder getEcrConfiguration() {
            return this.ecrConfiguration != null ? this.ecrConfiguration.toBuilder() : null;
        }

        public final void setEcrConfiguration(EcrConfiguration.BuilderImpl ecrConfiguration) {
            this.ecrConfiguration = ecrConfiguration != null ? ecrConfiguration.build() : null;
        }

        @Override
        public final Builder ecrConfiguration(EcrConfiguration ecrConfiguration) {
            this.ecrConfiguration = ecrConfiguration;
            return this;
        }

        public ImageScanningConfiguration build() {
            return new ImageScanningConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageScanningConfiguration> {
        public Builder imageScanningEnabled(Boolean var1);

        public Builder ecrConfiguration(EcrConfiguration var1);

        default public Builder ecrConfiguration(Consumer<EcrConfiguration.Builder> ecrConfiguration) {
            return this.ecrConfiguration((EcrConfiguration)((EcrConfiguration.Builder)EcrConfiguration.builder().applyMutation(ecrConfiguration)).build());
        }
    }
}

