/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderRequest;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowStepActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendWorkflowStepActionRequest
extends ImagebuilderRequest
implements ToCopyableBuilder<Builder, SendWorkflowStepActionRequest> {
    private static final SdkField<String> STEP_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepExecutionId").getter(SendWorkflowStepActionRequest.getter(SendWorkflowStepActionRequest::stepExecutionId)).setter(SendWorkflowStepActionRequest.setter(Builder::stepExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepExecutionId").build()}).build();
    private static final SdkField<String> IMAGE_BUILD_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageBuildVersionArn").getter(SendWorkflowStepActionRequest.getter(SendWorkflowStepActionRequest::imageBuildVersionArn)).setter(SendWorkflowStepActionRequest.setter(Builder::imageBuildVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBuildVersionArn").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(SendWorkflowStepActionRequest.getter(SendWorkflowStepActionRequest::actionAsString)).setter(SendWorkflowStepActionRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(SendWorkflowStepActionRequest.getter(SendWorkflowStepActionRequest::reason)).setter(SendWorkflowStepActionRequest.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(SendWorkflowStepActionRequest.getter(SendWorkflowStepActionRequest::clientToken)).setter(SendWorkflowStepActionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_EXECUTION_ID_FIELD, IMAGE_BUILD_VERSION_ARN_FIELD, ACTION_FIELD, REASON_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendWorkflowStepActionRequest.memberNameToFieldInitializer();
    private final String stepExecutionId;
    private final String imageBuildVersionArn;
    private final String action;
    private final String reason;
    private final String clientToken;

    private SendWorkflowStepActionRequest(BuilderImpl builder) {
        super(builder);
        this.stepExecutionId = builder.stepExecutionId;
        this.imageBuildVersionArn = builder.imageBuildVersionArn;
        this.action = builder.action;
        this.reason = builder.reason;
        this.clientToken = builder.clientToken;
    }

    public final String stepExecutionId() {
        return this.stepExecutionId;
    }

    public final String imageBuildVersionArn() {
        return this.imageBuildVersionArn;
    }

    public final WorkflowStepActionType action() {
        return WorkflowStepActionType.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String reason() {
        return this.reason;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stepExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendWorkflowStepActionRequest)) {
            return false;
        }
        SendWorkflowStepActionRequest other = (SendWorkflowStepActionRequest)((Object)obj);
        return Objects.equals(this.stepExecutionId(), other.stepExecutionId()) && Objects.equals(this.imageBuildVersionArn(), other.imageBuildVersionArn()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"SendWorkflowStepActionRequest").add("StepExecutionId", (Object)this.stepExecutionId()).add("ImageBuildVersionArn", (Object)this.imageBuildVersionArn()).add("Action", (Object)this.actionAsString()).add("Reason", (Object)this.reason()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stepExecutionId": {
                return Optional.ofNullable(clazz.cast(this.stepExecutionId()));
            }
            case "imageBuildVersionArn": {
                return Optional.ofNullable(clazz.cast(this.imageBuildVersionArn()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("stepExecutionId", STEP_EXECUTION_ID_FIELD);
        map.put("imageBuildVersionArn", IMAGE_BUILD_VERSION_ARN_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("reason", REASON_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendWorkflowStepActionRequest, T> g) {
        return obj -> g.apply((SendWorkflowStepActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderRequest.BuilderImpl
    implements Builder {
        private String stepExecutionId;
        private String imageBuildVersionArn;
        private String action;
        private String reason;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendWorkflowStepActionRequest model) {
            super(model);
            this.stepExecutionId(model.stepExecutionId);
            this.imageBuildVersionArn(model.imageBuildVersionArn);
            this.action(model.action);
            this.reason(model.reason);
            this.clientToken(model.clientToken);
        }

        public final String getStepExecutionId() {
            return this.stepExecutionId;
        }

        public final void setStepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
        }

        @Override
        public final Builder stepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
            return this;
        }

        public final String getImageBuildVersionArn() {
            return this.imageBuildVersionArn;
        }

        public final void setImageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
        }

        @Override
        public final Builder imageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(WorkflowStepActionType action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendWorkflowStepActionRequest build() {
            return new SendWorkflowStepActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ImagebuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendWorkflowStepActionRequest> {
        public Builder stepExecutionId(String var1);

        public Builder imageBuildVersionArn(String var1);

        public Builder action(String var1);

        public Builder action(WorkflowStepActionType var1);

        public Builder reason(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

