/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.ContainerRecipeSummary;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse;

public class ListContainerRecipesIterable
implements SdkIterable<ListContainerRecipesResponse> {
    private final ImagebuilderClient client;
    private final ListContainerRecipesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContainerRecipesIterable(ImagebuilderClient client, ListContainerRecipesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListContainerRecipesResponseFetcher();
    }

    public Iterator<ListContainerRecipesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContainerRecipeSummary> containerRecipeSummaryList() {
        Function<ListContainerRecipesResponse, Iterator> getIterator = response -> {
            if (response != null && response.containerRecipeSummaryList() != null) {
                return response.containerRecipeSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContainerRecipesResponseFetcher
    implements SyncPageFetcher<ListContainerRecipesResponse> {
        private ListContainerRecipesResponseFetcher() {
        }

        public boolean hasNextPage(ListContainerRecipesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContainerRecipesResponse nextPage(ListContainerRecipesResponse previousPage) {
            if (previousPage == null) {
                return ListContainerRecipesIterable.this.client.listContainerRecipes(ListContainerRecipesIterable.this.firstRequest);
            }
            return ListContainerRecipesIterable.this.client.listContainerRecipes((ListContainerRecipesRequest)((Object)ListContainerRecipesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

