/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResourceGroupsResponse extends InspectorResponse implements
        ToCopyableBuilder<DescribeResourceGroupsResponse.Builder, DescribeResourceGroupsResponse> {
    private static final SdkField<List<ResourceGroup>> RESOURCE_GROUPS_FIELD = SdkField
            .<List<ResourceGroup>> builder(MarshallingType.LIST)
            .memberName("resourceGroups")
            .getter(getter(DescribeResourceGroupsResponse::resourceGroups))
            .setter(setter(Builder::resourceGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, FailedItemDetails>> FAILED_ITEMS_FIELD = SdkField
            .<Map<String, FailedItemDetails>> builder(MarshallingType.MAP)
            .memberName("failedItems")
            .getter(getter(DescribeResourceGroupsResponse::failedItems))
            .setter(setter(Builder::failedItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItems").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FailedItemDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedItemDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUPS_FIELD,
            FAILED_ITEMS_FIELD));

    private final List<ResourceGroup> resourceGroups;

    private final Map<String, FailedItemDetails> failedItems;

    private DescribeResourceGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceGroups = builder.resourceGroups;
        this.failedItems = builder.failedItems;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceGroups() {
        return resourceGroups != null && !(resourceGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about a resource group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceGroups} method.
     * </p>
     * 
     * @return Information about a resource group.
     */
    public final List<ResourceGroup> resourceGroups() {
        return resourceGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedItems() {
        return failedItems != null && !(failedItems instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Resource group details that cannot be described. An error code is provided for each failed item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedItems} method.
     * </p>
     * 
     * @return Resource group details that cannot be described. An error code is provided for each failed item.
     */
    public final Map<String, FailedItemDetails> failedItems() {
        return failedItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceGroups() ? resourceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedItems() ? failedItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceGroupsResponse)) {
            return false;
        }
        DescribeResourceGroupsResponse other = (DescribeResourceGroupsResponse) obj;
        return hasResourceGroups() == other.hasResourceGroups() && Objects.equals(resourceGroups(), other.resourceGroups())
                && hasFailedItems() == other.hasFailedItems() && Objects.equals(failedItems(), other.failedItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeResourceGroupsResponse")
                .add("ResourceGroups", hasResourceGroups() ? resourceGroups() : null)
                .add("FailedItems", hasFailedItems() ? failedItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceGroups":
            return Optional.ofNullable(clazz.cast(resourceGroups()));
        case "failedItems":
            return Optional.ofNullable(clazz.cast(failedItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceGroupsResponse, T> g) {
        return obj -> g.apply((DescribeResourceGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeResourceGroupsResponse> {
        /**
         * <p>
         * Information about a resource group.
         * </p>
         * 
         * @param resourceGroups
         *        Information about a resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroups(Collection<ResourceGroup> resourceGroups);

        /**
         * <p>
         * Information about a resource group.
         * </p>
         * 
         * @param resourceGroups
         *        Information about a resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroups(ResourceGroup... resourceGroups);

        /**
         * <p>
         * Information about a resource group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector.model.ResourceGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector.model.ResourceGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector.model.ResourceGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceGroups(List<ResourceGroup>)}.
         * 
         * @param resourceGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector.model.ResourceGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceGroups(java.util.Collection<ResourceGroup>)
         */
        Builder resourceGroups(Consumer<ResourceGroup.Builder>... resourceGroups);

        /**
         * <p>
         * Resource group details that cannot be described. An error code is provided for each failed item.
         * </p>
         * 
         * @param failedItems
         *        Resource group details that cannot be described. An error code is provided for each failed item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItems(Map<String, FailedItemDetails> failedItems);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private List<ResourceGroup> resourceGroups = DefaultSdkAutoConstructList.getInstance();

        private Map<String, FailedItemDetails> failedItems = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceGroupsResponse model) {
            super(model);
            resourceGroups(model.resourceGroups);
            failedItems(model.failedItems);
        }

        public final List<ResourceGroup.Builder> getResourceGroups() {
            List<ResourceGroup.Builder> result = ResourceGroupListCopier.copyToBuilder(this.resourceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceGroups(Collection<ResourceGroup.BuilderImpl> resourceGroups) {
            this.resourceGroups = ResourceGroupListCopier.copyFromBuilder(resourceGroups);
        }

        @Override
        public final Builder resourceGroups(Collection<ResourceGroup> resourceGroups) {
            this.resourceGroups = ResourceGroupListCopier.copy(resourceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceGroups(ResourceGroup... resourceGroups) {
            resourceGroups(Arrays.asList(resourceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceGroups(Consumer<ResourceGroup.Builder>... resourceGroups) {
            resourceGroups(Stream.of(resourceGroups).map(c -> ResourceGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, FailedItemDetails.Builder> getFailedItems() {
            Map<String, FailedItemDetails.Builder> result = FailedItemsCopier.copyToBuilder(this.failedItems);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFailedItems(Map<String, FailedItemDetails.BuilderImpl> failedItems) {
            this.failedItems = FailedItemsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public final Builder failedItems(Map<String, FailedItemDetails> failedItems) {
            this.failedItems = FailedItemsCopier.copy(failedItems);
            return this;
        }

        @Override
        public DescribeResourceGroupsResponse build() {
            return new DescribeResourceGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
