/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.BatchDescribeArnListCopier;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeResourceGroupsRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, DescribeResourceGroupsRequest> {
    private static final SdkField<List<String>> RESOURCE_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceGroupArns").getter(DescribeResourceGroupsRequest.getter(DescribeResourceGroupsRequest::resourceGroupArns)).setter(DescribeResourceGroupsRequest.setter(Builder::resourceGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeResourceGroupsRequest.memberNameToFieldInitializer();
    private final List<String> resourceGroupArns;

    private DescribeResourceGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupArns = builder.resourceGroupArns;
    }

    public final boolean hasResourceGroupArns() {
        return this.resourceGroupArns != null && !(this.resourceGroupArns instanceof SdkAutoConstructList);
    }

    public final List<String> resourceGroupArns() {
        return this.resourceGroupArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceGroupArns() ? this.resourceGroupArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceGroupsRequest)) {
            return false;
        }
        DescribeResourceGroupsRequest other = (DescribeResourceGroupsRequest)((Object)obj);
        return this.hasResourceGroupArns() == other.hasResourceGroupArns() && Objects.equals(this.resourceGroupArns(), other.resourceGroupArns());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeResourceGroupsRequest").add("ResourceGroupArns", this.hasResourceGroupArns() ? this.resourceGroupArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceGroupArns": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("resourceGroupArns", RESOURCE_GROUP_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceGroupsRequest, T> g) {
        return obj -> g.apply((DescribeResourceGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private List<String> resourceGroupArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceGroupsRequest model) {
            super(model);
            this.resourceGroupArns(model.resourceGroupArns);
        }

        public final Collection<String> getResourceGroupArns() {
            if (this.resourceGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceGroupArns;
        }

        public final void setResourceGroupArns(Collection<String> resourceGroupArns) {
            this.resourceGroupArns = BatchDescribeArnListCopier.copy(resourceGroupArns);
        }

        @Override
        public final Builder resourceGroupArns(Collection<String> resourceGroupArns) {
            this.resourceGroupArns = BatchDescribeArnListCopier.copy(resourceGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceGroupArns(String ... resourceGroupArns) {
            this.resourceGroupArns(Arrays.asList(resourceGroupArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeResourceGroupsRequest build() {
            return new DescribeResourceGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeResourceGroupsRequest> {
        public Builder resourceGroupArns(Collection<String> var1);

        public Builder resourceGroupArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

