/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details that define an aggregation based on finding title.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TitleAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<TitleAggregation.Builder, TitleAggregation> {
    private static final SdkField<String> FINDING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingType").getter(getter(TitleAggregation::findingTypeAsString)).setter(setter(Builder::findingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingType").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(TitleAggregation::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(TitleAggregation::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(TitleAggregation::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final SdkField<List<StringFilter>> TITLES_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("titles")
            .getter(getter(TitleAggregation::titles))
            .setter(setter(Builder::titles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("titles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> VULNERABILITY_IDS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("vulnerabilityIds")
            .getter(getter(TitleAggregation::vulnerabilityIds))
            .setter(setter(Builder::vulnerabilityIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilityIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_TYPE_FIELD,
            RESOURCE_TYPE_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, TITLES_FIELD, VULNERABILITY_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String findingType;

    private final String resourceType;

    private final String sortBy;

    private final String sortOrder;

    private final List<StringFilter> titles;

    private final List<StringFilter> vulnerabilityIds;

    private TitleAggregation(BuilderImpl builder) {
        this.findingType = builder.findingType;
        this.resourceType = builder.resourceType;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.titles = builder.titles;
        this.vulnerabilityIds = builder.vulnerabilityIds;
    }

    /**
     * <p>
     * The type of finding to aggregate on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #findingType} will
     * return {@link AggregationFindingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #findingTypeAsString}.
     * </p>
     * 
     * @return The type of finding to aggregate on.
     * @see AggregationFindingType
     */
    public final AggregationFindingType findingType() {
        return AggregationFindingType.fromValue(findingType);
    }

    /**
     * <p>
     * The type of finding to aggregate on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #findingType} will
     * return {@link AggregationFindingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #findingTypeAsString}.
     * </p>
     * 
     * @return The type of finding to aggregate on.
     * @see AggregationFindingType
     */
    public final String findingTypeAsString() {
        return findingType;
    }

    /**
     * <p>
     * The resource type to aggregate on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link AggregationResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type to aggregate on.
     * @see AggregationResourceType
     */
    public final AggregationResourceType resourceType() {
        return AggregationResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type to aggregate on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link AggregationResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type to aggregate on.
     * @see AggregationResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The value to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link TitleSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort results by.
     * @see TitleSortBy
     */
    public final TitleSortBy sortBy() {
        return TitleSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The value to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link TitleSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort results by.
     * @see TitleSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The order to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort results by.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort results by.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the Titles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTitles() {
        return titles != null && !(titles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The finding titles to aggregate on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTitles} method.
     * </p>
     * 
     * @return The finding titles to aggregate on.
     */
    public final List<StringFilter> titles() {
        return titles;
    }

    /**
     * For responses, this returns true if the service returned a value for the VulnerabilityIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVulnerabilityIds() {
        return vulnerabilityIds != null && !(vulnerabilityIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The vulnerability IDs of the findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVulnerabilityIds} method.
     * </p>
     * 
     * @return The vulnerability IDs of the findings.
     */
    public final List<StringFilter> vulnerabilityIds() {
        return vulnerabilityIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(findingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTitles() ? titles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVulnerabilityIds() ? vulnerabilityIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TitleAggregation)) {
            return false;
        }
        TitleAggregation other = (TitleAggregation) obj;
        return Objects.equals(findingTypeAsString(), other.findingTypeAsString())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString()) && hasTitles() == other.hasTitles()
                && Objects.equals(titles(), other.titles()) && hasVulnerabilityIds() == other.hasVulnerabilityIds()
                && Objects.equals(vulnerabilityIds(), other.vulnerabilityIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TitleAggregation").add("FindingType", findingTypeAsString())
                .add("ResourceType", resourceTypeAsString()).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).add("Titles", hasTitles() ? titles() : null)
                .add("VulnerabilityIds", hasVulnerabilityIds() ? vulnerabilityIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingType":
            return Optional.ofNullable(clazz.cast(findingTypeAsString()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "titles":
            return Optional.ofNullable(clazz.cast(titles()));
        case "vulnerabilityIds":
            return Optional.ofNullable(clazz.cast(vulnerabilityIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TitleAggregation, T> g) {
        return obj -> g.apply((TitleAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TitleAggregation> {
        /**
         * <p>
         * The type of finding to aggregate on.
         * </p>
         * 
         * @param findingType
         *        The type of finding to aggregate on.
         * @see AggregationFindingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationFindingType
         */
        Builder findingType(String findingType);

        /**
         * <p>
         * The type of finding to aggregate on.
         * </p>
         * 
         * @param findingType
         *        The type of finding to aggregate on.
         * @see AggregationFindingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationFindingType
         */
        Builder findingType(AggregationFindingType findingType);

        /**
         * <p>
         * The resource type to aggregate on.
         * </p>
         * 
         * @param resourceType
         *        The resource type to aggregate on.
         * @see AggregationResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type to aggregate on.
         * </p>
         * 
         * @param resourceType
         *        The resource type to aggregate on.
         * @see AggregationResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationResourceType
         */
        Builder resourceType(AggregationResourceType resourceType);

        /**
         * <p>
         * The value to sort results by.
         * </p>
         * 
         * @param sortBy
         *        The value to sort results by.
         * @see TitleSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TitleSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The value to sort results by.
         * </p>
         * 
         * @param sortBy
         *        The value to sort results by.
         * @see TitleSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TitleSortBy
         */
        Builder sortBy(TitleSortBy sortBy);

        /**
         * <p>
         * The order to sort results by.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort results by.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order to sort results by.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort results by.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The finding titles to aggregate on.
         * </p>
         * 
         * @param titles
         *        The finding titles to aggregate on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titles(Collection<StringFilter> titles);

        /**
         * <p>
         * The finding titles to aggregate on.
         * </p>
         * 
         * @param titles
         *        The finding titles to aggregate on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titles(StringFilter... titles);

        /**
         * <p>
         * The finding titles to aggregate on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #titles(List<StringFilter>)}.
         * 
         * @param titles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #titles(java.util.Collection<StringFilter>)
         */
        Builder titles(Consumer<StringFilter.Builder>... titles);

        /**
         * <p>
         * The vulnerability IDs of the findings.
         * </p>
         * 
         * @param vulnerabilityIds
         *        The vulnerability IDs of the findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilityIds(Collection<StringFilter> vulnerabilityIds);

        /**
         * <p>
         * The vulnerability IDs of the findings.
         * </p>
         * 
         * @param vulnerabilityIds
         *        The vulnerability IDs of the findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilityIds(StringFilter... vulnerabilityIds);

        /**
         * <p>
         * The vulnerability IDs of the findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #vulnerabilityIds(List<StringFilter>)}.
         * 
         * @param vulnerabilityIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vulnerabilityIds(java.util.Collection<StringFilter>)
         */
        Builder vulnerabilityIds(Consumer<StringFilter.Builder>... vulnerabilityIds);
    }

    static final class BuilderImpl implements Builder {
        private String findingType;

        private String resourceType;

        private String sortBy;

        private String sortOrder;

        private List<StringFilter> titles = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> vulnerabilityIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TitleAggregation model) {
            findingType(model.findingType);
            resourceType(model.resourceType);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            titles(model.titles);
            vulnerabilityIds(model.vulnerabilityIds);
        }

        public final String getFindingType() {
            return findingType;
        }

        public final void setFindingType(String findingType) {
            this.findingType = findingType;
        }

        @Override
        public final Builder findingType(String findingType) {
            this.findingType = findingType;
            return this;
        }

        @Override
        public final Builder findingType(AggregationFindingType findingType) {
            this.findingType(findingType == null ? null : findingType.toString());
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(AggregationResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(TitleSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final List<StringFilter.Builder> getTitles() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.titles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTitles(Collection<StringFilter.BuilderImpl> titles) {
            this.titles = StringFilterListCopier.copyFromBuilder(titles);
        }

        @Override
        public final Builder titles(Collection<StringFilter> titles) {
            this.titles = StringFilterListCopier.copy(titles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder titles(StringFilter... titles) {
            titles(Arrays.asList(titles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder titles(Consumer<StringFilter.Builder>... titles) {
            titles(Stream.of(titles).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getVulnerabilityIds() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.vulnerabilityIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVulnerabilityIds(Collection<StringFilter.BuilderImpl> vulnerabilityIds) {
            this.vulnerabilityIds = StringFilterListCopier.copyFromBuilder(vulnerabilityIds);
        }

        @Override
        public final Builder vulnerabilityIds(Collection<StringFilter> vulnerabilityIds) {
            this.vulnerabilityIds = StringFilterListCopier.copy(vulnerabilityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilityIds(StringFilter... vulnerabilityIds) {
            vulnerabilityIds(Arrays.asList(vulnerabilityIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilityIds(Consumer<StringFilter.Builder>... vulnerabilityIds) {
            vulnerabilityIds(Stream.of(vulnerabilityIds).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TitleAggregation build() {
            return new TitleAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
