/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.inspector2.Inspector2Client;
import software.amazon.awssdk.services.inspector2.Inspector2ServiceClientConfiguration;
import software.amazon.awssdk.services.inspector2.model.AccessDeniedException;
import software.amazon.awssdk.services.inspector2.model.AssociateMemberRequest;
import software.amazon.awssdk.services.inspector2.model.AssociateMemberResponse;
import software.amazon.awssdk.services.inspector2.model.BadRequestException;
import software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusResponse;
import software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest;
import software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse;
import software.amazon.awssdk.services.inspector2.model.CancelFindingsReportRequest;
import software.amazon.awssdk.services.inspector2.model.CancelFindingsReportResponse;
import software.amazon.awssdk.services.inspector2.model.CancelSbomExportRequest;
import software.amazon.awssdk.services.inspector2.model.CancelSbomExportResponse;
import software.amazon.awssdk.services.inspector2.model.ConflictException;
import software.amazon.awssdk.services.inspector2.model.CreateFilterRequest;
import software.amazon.awssdk.services.inspector2.model.CreateFilterResponse;
import software.amazon.awssdk.services.inspector2.model.CreateFindingsReportRequest;
import software.amazon.awssdk.services.inspector2.model.CreateFindingsReportResponse;
import software.amazon.awssdk.services.inspector2.model.CreateSbomExportRequest;
import software.amazon.awssdk.services.inspector2.model.CreateSbomExportResponse;
import software.amazon.awssdk.services.inspector2.model.DeleteFilterRequest;
import software.amazon.awssdk.services.inspector2.model.DeleteFilterResponse;
import software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountRequest;
import software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountResponse;
import software.amazon.awssdk.services.inspector2.model.DisableRequest;
import software.amazon.awssdk.services.inspector2.model.DisableResponse;
import software.amazon.awssdk.services.inspector2.model.DisassociateMemberRequest;
import software.amazon.awssdk.services.inspector2.model.DisassociateMemberResponse;
import software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountRequest;
import software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountResponse;
import software.amazon.awssdk.services.inspector2.model.EnableRequest;
import software.amazon.awssdk.services.inspector2.model.EnableResponse;
import software.amazon.awssdk.services.inspector2.model.GetConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.GetConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountRequest;
import software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountResponse;
import software.amazon.awssdk.services.inspector2.model.GetEc2DeepInspectionConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.GetEc2DeepInspectionConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyRequest;
import software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyResponse;
import software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusRequest;
import software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusResponse;
import software.amazon.awssdk.services.inspector2.model.GetMemberRequest;
import software.amazon.awssdk.services.inspector2.model.GetMemberResponse;
import software.amazon.awssdk.services.inspector2.model.GetSbomExportRequest;
import software.amazon.awssdk.services.inspector2.model.GetSbomExportResponse;
import software.amazon.awssdk.services.inspector2.model.Inspector2Exception;
import software.amazon.awssdk.services.inspector2.model.InternalServerException;
import software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest;
import software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse;
import software.amazon.awssdk.services.inspector2.model.ListCoverageRequest;
import software.amazon.awssdk.services.inspector2.model.ListCoverageResponse;
import software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest;
import software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse;
import software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest;
import software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse;
import software.amazon.awssdk.services.inspector2.model.ListFiltersRequest;
import software.amazon.awssdk.services.inspector2.model.ListFiltersResponse;
import software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest;
import software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse;
import software.amazon.awssdk.services.inspector2.model.ListFindingsRequest;
import software.amazon.awssdk.services.inspector2.model.ListFindingsResponse;
import software.amazon.awssdk.services.inspector2.model.ListMembersRequest;
import software.amazon.awssdk.services.inspector2.model.ListMembersResponse;
import software.amazon.awssdk.services.inspector2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.inspector2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest;
import software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse;
import software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyRequest;
import software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyResponse;
import software.amazon.awssdk.services.inspector2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest;
import software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse;
import software.amazon.awssdk.services.inspector2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.inspector2.model.TagResourceRequest;
import software.amazon.awssdk.services.inspector2.model.TagResourceResponse;
import software.amazon.awssdk.services.inspector2.model.ThrottlingException;
import software.amazon.awssdk.services.inspector2.model.UntagResourceRequest;
import software.amazon.awssdk.services.inspector2.model.UntagResourceResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateFilterResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.ValidationException;
import software.amazon.awssdk.services.inspector2.transform.AssociateMemberRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.BatchGetAccountStatusRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.BatchGetCodeSnippetRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.BatchGetFindingDetailsRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.BatchGetFreeTrialInfoRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.BatchGetMemberEc2DeepInspectionStatusRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.BatchUpdateMemberEc2DeepInspectionStatusRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.CancelFindingsReportRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.CancelSbomExportRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.CreateFilterRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.CreateFindingsReportRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.CreateSbomExportRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.DeleteFilterRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.DescribeOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.DisableDelegatedAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.DisableRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.DisassociateMemberRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.EnableDelegatedAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.EnableRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.GetConfigurationRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.GetDelegatedAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.GetEc2DeepInspectionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.GetEncryptionKeyRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.GetFindingsReportStatusRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.GetMemberRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.GetSbomExportRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListAccountPermissionsRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListCoverageRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListCoverageStatisticsRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListDelegatedAdminAccountsRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListFiltersRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListFindingAggregationsRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListFindingsRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListMembersRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListUsageTotalsRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ResetEncryptionKeyRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.SearchVulnerabilitiesRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.UpdateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.UpdateEc2DeepInspectionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.UpdateEncryptionKeyRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.UpdateFilterRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.UpdateOrgEc2DeepInspectionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.UpdateOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultInspector2Client
implements Inspector2Client {
    private static final Logger log = Logger.loggerFor(DefaultInspector2Client.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final Inspector2ServiceClientConfiguration serviceClientConfiguration;

    protected DefaultInspector2Client(Inspector2ServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateMemberResponse associateMember(AssociateMemberRequest associateMemberRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateMemberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, associateMemberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateMember");
            AssociateMemberResponse associateMemberResponse = (AssociateMemberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateMember").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateMemberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateMemberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateMemberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$associateMember$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetAccountStatusResponse batchGetAccountStatus(BatchGetAccountStatusRequest batchGetAccountStatusRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetAccountStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, batchGetAccountStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetAccountStatus");
            BatchGetAccountStatusResponse batchGetAccountStatusResponse = (BatchGetAccountStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetAccountStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetAccountStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetAccountStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetAccountStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$batchGetAccountStatus$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetCodeSnippetResponse batchGetCodeSnippet(BatchGetCodeSnippetRequest batchGetCodeSnippetRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetCodeSnippetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, batchGetCodeSnippetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetCodeSnippet");
            BatchGetCodeSnippetResponse batchGetCodeSnippetResponse = (BatchGetCodeSnippetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetCodeSnippet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetCodeSnippetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetCodeSnippetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetCodeSnippetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$batchGetCodeSnippet$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetFindingDetailsResponse batchGetFindingDetails(BatchGetFindingDetailsRequest batchGetFindingDetailsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetFindingDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, batchGetFindingDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetFindingDetails");
            BatchGetFindingDetailsResponse batchGetFindingDetailsResponse = (BatchGetFindingDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetFindingDetails").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetFindingDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetFindingDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetFindingDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$batchGetFindingDetails$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetFreeTrialInfoResponse batchGetFreeTrialInfo(BatchGetFreeTrialInfoRequest batchGetFreeTrialInfoRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetFreeTrialInfoResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, batchGetFreeTrialInfoRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetFreeTrialInfo");
            BatchGetFreeTrialInfoResponse batchGetFreeTrialInfoResponse = (BatchGetFreeTrialInfoResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetFreeTrialInfo").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetFreeTrialInfoRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetFreeTrialInfoRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetFreeTrialInfoResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$batchGetFreeTrialInfo$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetMemberEc2DeepInspectionStatusResponse batchGetMemberEc2DeepInspectionStatus(BatchGetMemberEc2DeepInspectionStatusRequest batchGetMemberEc2DeepInspectionStatusRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetMemberEc2DeepInspectionStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, batchGetMemberEc2DeepInspectionStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetMemberEc2DeepInspectionStatus");
            BatchGetMemberEc2DeepInspectionStatusResponse batchGetMemberEc2DeepInspectionStatusResponse = (BatchGetMemberEc2DeepInspectionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetMemberEc2DeepInspectionStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetMemberEc2DeepInspectionStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetMemberEc2DeepInspectionStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetMemberEc2DeepInspectionStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$batchGetMemberEc2DeepInspectionStatus$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchUpdateMemberEc2DeepInspectionStatusResponse batchUpdateMemberEc2DeepInspectionStatus(BatchUpdateMemberEc2DeepInspectionStatusRequest batchUpdateMemberEc2DeepInspectionStatusRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUpdateMemberEc2DeepInspectionStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, batchUpdateMemberEc2DeepInspectionStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUpdateMemberEc2DeepInspectionStatus");
            BatchUpdateMemberEc2DeepInspectionStatusResponse batchUpdateMemberEc2DeepInspectionStatusResponse = (BatchUpdateMemberEc2DeepInspectionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUpdateMemberEc2DeepInspectionStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchUpdateMemberEc2DeepInspectionStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchUpdateMemberEc2DeepInspectionStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchUpdateMemberEc2DeepInspectionStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$batchUpdateMemberEc2DeepInspectionStatus$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelFindingsReportResponse cancelFindingsReport(CancelFindingsReportRequest cancelFindingsReportRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelFindingsReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, cancelFindingsReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelFindingsReport");
            CancelFindingsReportResponse cancelFindingsReportResponse = (CancelFindingsReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelFindingsReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelFindingsReportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelFindingsReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelFindingsReportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$cancelFindingsReport$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelSbomExportResponse cancelSbomExport(CancelSbomExportRequest cancelSbomExportRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelSbomExportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, cancelSbomExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelSbomExport");
            CancelSbomExportResponse cancelSbomExportResponse = (CancelSbomExportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelSbomExport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelSbomExportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelSbomExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelSbomExportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$cancelSbomExport$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFilterResponse createFilter(CreateFilterRequest createFilterRequest) throws ServiceQuotaExceededException, BadRequestException, ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, createFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFilter");
            CreateFilterResponse createFilterResponse = (CreateFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$createFilter$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFindingsReportResponse createFindingsReport(CreateFindingsReportRequest createFindingsReportRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFindingsReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, createFindingsReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFindingsReport");
            CreateFindingsReportResponse createFindingsReportResponse = (CreateFindingsReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFindingsReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFindingsReportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFindingsReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFindingsReportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$createFindingsReport$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSbomExportResponse createSbomExport(CreateSbomExportRequest createSbomExportRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSbomExportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, createSbomExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSbomExport");
            CreateSbomExportResponse createSbomExportResponse = (CreateSbomExportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSbomExport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSbomExportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSbomExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSbomExportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$createSbomExport$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFilterResponse deleteFilter(DeleteFilterRequest deleteFilterRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, deleteFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFilter");
            DeleteFilterResponse deleteFilterResponse = (DeleteFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$deleteFilter$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrganizationConfigurationResponse describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, describeOrganizationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganizationConfiguration");
            DescribeOrganizationConfigurationResponse describeOrganizationConfigurationResponse = (DescribeOrganizationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrganizationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrganizationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOrganizationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$describeOrganizationConfiguration$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableResponse disable(DisableRequest disableRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, disableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Disable");
            DisableResponse disableResponse = (DisableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Disable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$disable$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableDelegatedAdminAccountResponse disableDelegatedAdminAccount(DisableDelegatedAdminAccountRequest disableDelegatedAdminAccountRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableDelegatedAdminAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, disableDelegatedAdminAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableDelegatedAdminAccount");
            DisableDelegatedAdminAccountResponse disableDelegatedAdminAccountResponse = (DisableDelegatedAdminAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableDelegatedAdminAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableDelegatedAdminAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableDelegatedAdminAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableDelegatedAdminAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$disableDelegatedAdminAccount$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateMemberResponse disassociateMember(DisassociateMemberRequest disassociateMemberRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateMemberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, disassociateMemberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateMember");
            DisassociateMemberResponse disassociateMemberResponse = (DisassociateMemberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateMember").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateMemberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateMemberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateMemberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$disassociateMember$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableResponse enable(EnableRequest enableRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, enableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Enable");
            EnableResponse enableResponse = (EnableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Enable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$enable$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableDelegatedAdminAccountResponse enableDelegatedAdminAccount(EnableDelegatedAdminAccountRequest enableDelegatedAdminAccountRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableDelegatedAdminAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, enableDelegatedAdminAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableDelegatedAdminAccount");
            EnableDelegatedAdminAccountResponse enableDelegatedAdminAccountResponse = (EnableDelegatedAdminAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableDelegatedAdminAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableDelegatedAdminAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableDelegatedAdminAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableDelegatedAdminAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$enableDelegatedAdminAccount$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConfigurationResponse getConfiguration(GetConfigurationRequest getConfigurationRequest) throws ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, getConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConfiguration");
            GetConfigurationResponse getConfigurationResponse = (GetConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$getConfiguration$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDelegatedAdminAccountResponse getDelegatedAdminAccount(GetDelegatedAdminAccountRequest getDelegatedAdminAccountRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDelegatedAdminAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, getDelegatedAdminAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDelegatedAdminAccount");
            GetDelegatedAdminAccountResponse getDelegatedAdminAccountResponse = (GetDelegatedAdminAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDelegatedAdminAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDelegatedAdminAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDelegatedAdminAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDelegatedAdminAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$getDelegatedAdminAccount$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEc2DeepInspectionConfigurationResponse getEc2DeepInspectionConfiguration(GetEc2DeepInspectionConfigurationRequest getEc2DeepInspectionConfigurationRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEc2DeepInspectionConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, getEc2DeepInspectionConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEc2DeepInspectionConfiguration");
            GetEc2DeepInspectionConfigurationResponse getEc2DeepInspectionConfigurationResponse = (GetEc2DeepInspectionConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEc2DeepInspectionConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEc2DeepInspectionConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEc2DeepInspectionConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEc2DeepInspectionConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$getEc2DeepInspectionConfiguration$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEncryptionKeyResponse getEncryptionKey(GetEncryptionKeyRequest getEncryptionKeyRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEncryptionKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, getEncryptionKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEncryptionKey");
            GetEncryptionKeyResponse getEncryptionKeyResponse = (GetEncryptionKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEncryptionKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEncryptionKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEncryptionKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEncryptionKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$getEncryptionKey$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFindingsReportStatusResponse getFindingsReportStatus(GetFindingsReportStatusRequest getFindingsReportStatusRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFindingsReportStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, getFindingsReportStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFindingsReportStatus");
            GetFindingsReportStatusResponse getFindingsReportStatusResponse = (GetFindingsReportStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFindingsReportStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFindingsReportStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetFindingsReportStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFindingsReportStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$getFindingsReportStatus$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMemberResponse getMember(GetMemberRequest getMemberRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMemberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, getMemberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMember");
            GetMemberResponse getMemberResponse = (GetMemberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMember").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMemberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMemberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMemberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$getMember$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSbomExportResponse getSbomExport(GetSbomExportRequest getSbomExportRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSbomExportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, getSbomExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSbomExport");
            GetSbomExportResponse getSbomExportResponse = (GetSbomExportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSbomExport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSbomExportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSbomExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSbomExportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$getSbomExport$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccountPermissionsResponse listAccountPermissions(ListAccountPermissionsRequest listAccountPermissionsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountPermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, listAccountPermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccountPermissions");
            ListAccountPermissionsResponse listAccountPermissionsResponse = (ListAccountPermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccountPermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAccountPermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAccountPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAccountPermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$listAccountPermissions$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCoverageResponse listCoverage(ListCoverageRequest listCoverageRequest) throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCoverageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, listCoverageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCoverage");
            ListCoverageResponse listCoverageResponse = (ListCoverageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCoverage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCoverageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCoverageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCoverageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$listCoverage$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCoverageStatisticsResponse listCoverageStatistics(ListCoverageStatisticsRequest listCoverageStatisticsRequest) throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCoverageStatisticsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, listCoverageStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCoverageStatistics");
            ListCoverageStatisticsResponse listCoverageStatisticsResponse = (ListCoverageStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCoverageStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCoverageStatisticsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCoverageStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCoverageStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$listCoverageStatistics$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDelegatedAdminAccountsResponse listDelegatedAdminAccounts(ListDelegatedAdminAccountsRequest listDelegatedAdminAccountsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDelegatedAdminAccountsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, listDelegatedAdminAccountsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDelegatedAdminAccounts");
            ListDelegatedAdminAccountsResponse listDelegatedAdminAccountsResponse = (ListDelegatedAdminAccountsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDelegatedAdminAccounts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDelegatedAdminAccountsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDelegatedAdminAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDelegatedAdminAccountsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$listDelegatedAdminAccounts$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFiltersResponse listFilters(ListFiltersRequest listFiltersRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFiltersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, listFiltersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFilters");
            ListFiltersResponse listFiltersResponse = (ListFiltersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFilters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFiltersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFiltersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFiltersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$listFilters$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFindingAggregationsResponse listFindingAggregations(ListFindingAggregationsRequest listFindingAggregationsRequest) throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFindingAggregationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, listFindingAggregationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFindingAggregations");
            ListFindingAggregationsResponse listFindingAggregationsResponse = (ListFindingAggregationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFindingAggregations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFindingAggregationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFindingAggregationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFindingAggregationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$listFindingAggregations$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFindingsResponse listFindings(ListFindingsRequest listFindingsRequest) throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFindingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, listFindingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFindings");
            ListFindingsResponse listFindingsResponse = (ListFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFindings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFindingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFindingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$listFindings$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMembersResponse listMembers(ListMembersRequest listMembersRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMembersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, listMembersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMembers");
            ListMembersResponse listMembersResponse = (ListMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMembers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMembersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMembersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMembersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$listMembers$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$listTagsForResource$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUsageTotalsResponse listUsageTotals(ListUsageTotalsRequest listUsageTotalsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsageTotalsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, listUsageTotalsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUsageTotals");
            ListUsageTotalsResponse listUsageTotalsResponse = (ListUsageTotalsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsageTotals").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUsageTotalsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListUsageTotalsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listUsageTotalsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$listUsageTotals$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResetEncryptionKeyResponse resetEncryptionKey(ResetEncryptionKeyRequest resetEncryptionKeyRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetEncryptionKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, resetEncryptionKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetEncryptionKey");
            ResetEncryptionKeyResponse resetEncryptionKeyResponse = (ResetEncryptionKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetEncryptionKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resetEncryptionKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResetEncryptionKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resetEncryptionKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$resetEncryptionKey$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchVulnerabilitiesResponse searchVulnerabilities(SearchVulnerabilitiesRequest searchVulnerabilitiesRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchVulnerabilitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, searchVulnerabilitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchVulnerabilities");
            SearchVulnerabilitiesResponse searchVulnerabilitiesResponse = (SearchVulnerabilitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchVulnerabilities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchVulnerabilitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchVulnerabilitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchVulnerabilitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$searchVulnerabilities$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$tagResource$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$untagResource$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConfigurationResponse updateConfiguration(UpdateConfigurationRequest updateConfigurationRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, updateConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConfiguration");
            UpdateConfigurationResponse updateConfigurationResponse = (UpdateConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$updateConfiguration$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEc2DeepInspectionConfigurationResponse updateEc2DeepInspectionConfiguration(UpdateEc2DeepInspectionConfigurationRequest updateEc2DeepInspectionConfigurationRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEc2DeepInspectionConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, updateEc2DeepInspectionConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEc2DeepInspectionConfiguration");
            UpdateEc2DeepInspectionConfigurationResponse updateEc2DeepInspectionConfigurationResponse = (UpdateEc2DeepInspectionConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEc2DeepInspectionConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEc2DeepInspectionConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEc2DeepInspectionConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEc2DeepInspectionConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$updateEc2DeepInspectionConfiguration$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEncryptionKeyResponse updateEncryptionKey(UpdateEncryptionKeyRequest updateEncryptionKeyRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEncryptionKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, updateEncryptionKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEncryptionKey");
            UpdateEncryptionKeyResponse updateEncryptionKeyResponse = (UpdateEncryptionKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEncryptionKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEncryptionKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEncryptionKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEncryptionKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$updateEncryptionKey$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFilterResponse updateFilter(UpdateFilterRequest updateFilterRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, updateFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFilter");
            UpdateFilterResponse updateFilterResponse = (UpdateFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$updateFilter$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOrgEc2DeepInspectionConfigurationResponse updateOrgEc2DeepInspectionConfiguration(UpdateOrgEc2DeepInspectionConfigurationRequest updateOrgEc2DeepInspectionConfigurationRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateOrgEc2DeepInspectionConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, updateOrgEc2DeepInspectionConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateOrgEc2DeepInspectionConfiguration");
            UpdateOrgEc2DeepInspectionConfigurationResponse updateOrgEc2DeepInspectionConfigurationResponse = (UpdateOrgEc2DeepInspectionConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateOrgEc2DeepInspectionConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateOrgEc2DeepInspectionConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateOrgEc2DeepInspectionConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateOrgEc2DeepInspectionConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$updateOrgEc2DeepInspectionConfiguration$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOrganizationConfigurationResponse updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, Inspector2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateOrganizationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultInspector2Client.resolveMetricPublishers(this.clientConfiguration, updateOrganizationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateOrganizationConfiguration");
            UpdateOrganizationConfigurationResponse updateOrganizationConfigurationResponse = (UpdateOrganizationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateOrganizationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateOrganizationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateOrganizationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateOrganizationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultInspector2Client.lambda$updateOrganizationConfiguration$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "inspector2";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(Inspector2Exception::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final Inspector2ServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateOrganizationConfiguration$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateOrgEc2DeepInspectionConfiguration$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFilter$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEncryptionKey$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEc2DeepInspectionConfiguration$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConfiguration$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchVulnerabilities$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetEncryptionKey$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUsageTotals$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMembers$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFindings$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFindingAggregations$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFilters$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDelegatedAdminAccounts$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCoverageStatistics$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCoverage$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccountPermissions$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSbomExport$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMember$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFindingsReportStatus$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEncryptionKey$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEc2DeepInspectionConfiguration$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDelegatedAdminAccount$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConfiguration$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableDelegatedAdminAccount$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enable$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateMember$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableDelegatedAdminAccount$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disable$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOrganizationConfiguration$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFilter$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSbomExport$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFindingsReport$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFilter$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelSbomExport$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelFindingsReport$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUpdateMemberEc2DeepInspectionStatus$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetMemberEc2DeepInspectionStatus$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetFreeTrialInfo$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetFindingDetails$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetCodeSnippet$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetAccountStatus$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateMember$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

