/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.CisScanResultDetailsFilterCriteria;
import software.amazon.awssdk.services.inspector2.model.CisScanResultDetailsSortBy;
import software.amazon.awssdk.services.inspector2.model.CisSortOrder;
import software.amazon.awssdk.services.inspector2.model.Inspector2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCisScanResultDetailsRequest
extends Inspector2Request
implements ToCopyableBuilder<Builder, GetCisScanResultDetailsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(GetCisScanResultDetailsRequest.getter(GetCisScanResultDetailsRequest::accountId)).setter(GetCisScanResultDetailsRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<CisScanResultDetailsFilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filterCriteria").getter(GetCisScanResultDetailsRequest.getter(GetCisScanResultDetailsRequest::filterCriteria)).setter(GetCisScanResultDetailsRequest.setter(Builder::filterCriteria)).constructor(CisScanResultDetailsFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetCisScanResultDetailsRequest.getter(GetCisScanResultDetailsRequest::maxResults)).setter(GetCisScanResultDetailsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetCisScanResultDetailsRequest.getter(GetCisScanResultDetailsRequest::nextToken)).setter(GetCisScanResultDetailsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> SCAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanArn").getter(GetCisScanResultDetailsRequest.getter(GetCisScanResultDetailsRequest::scanArn)).setter(GetCisScanResultDetailsRequest.setter(Builder::scanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArn").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(GetCisScanResultDetailsRequest.getter(GetCisScanResultDetailsRequest::sortByAsString)).setter(GetCisScanResultDetailsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(GetCisScanResultDetailsRequest.getter(GetCisScanResultDetailsRequest::sortOrderAsString)).setter(GetCisScanResultDetailsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final SdkField<String> TARGET_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetResourceId").getter(GetCisScanResultDetailsRequest.getter(GetCisScanResultDetailsRequest::targetResourceId)).setter(GetCisScanResultDetailsRequest.setter(Builder::targetResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, FILTER_CRITERIA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SCAN_ARN_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, TARGET_RESOURCE_ID_FIELD));
    private final String accountId;
    private final CisScanResultDetailsFilterCriteria filterCriteria;
    private final Integer maxResults;
    private final String nextToken;
    private final String scanArn;
    private final String sortBy;
    private final String sortOrder;
    private final String targetResourceId;

    private GetCisScanResultDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.filterCriteria = builder.filterCriteria;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.scanArn = builder.scanArn;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.targetResourceId = builder.targetResourceId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final CisScanResultDetailsFilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String scanArn() {
        return this.scanArn;
    }

    public final CisScanResultDetailsSortBy sortBy() {
        return CisScanResultDetailsSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final CisSortOrder sortOrder() {
        return CisSortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final String targetResourceId() {
        return this.targetResourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResourceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCisScanResultDetailsRequest)) {
            return false;
        }
        GetCisScanResultDetailsRequest other = (GetCisScanResultDetailsRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.filterCriteria(), other.filterCriteria()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.scanArn(), other.scanArn()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.targetResourceId(), other.targetResourceId());
    }

    public final String toString() {
        return ToString.builder((String)"GetCisScanResultDetailsRequest").add("AccountId", (Object)this.accountId()).add("FilterCriteria", (Object)this.filterCriteria()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ScanArn", (Object)this.scanArn()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("TargetResourceId", (Object)this.targetResourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "filterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "scanArn": {
                return Optional.ofNullable(clazz.cast(this.scanArn()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "targetResourceId": {
                return Optional.ofNullable(clazz.cast(this.targetResourceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCisScanResultDetailsRequest, T> g) {
        return obj -> g.apply((GetCisScanResultDetailsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Request.BuilderImpl
    implements Builder {
        private String accountId;
        private CisScanResultDetailsFilterCriteria filterCriteria;
        private Integer maxResults;
        private String nextToken;
        private String scanArn;
        private String sortBy;
        private String sortOrder;
        private String targetResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCisScanResultDetailsRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.filterCriteria(model.filterCriteria);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.scanArn(model.scanArn);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.targetResourceId(model.targetResourceId);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final CisScanResultDetailsFilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(CisScanResultDetailsFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(CisScanResultDetailsFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getScanArn() {
            return this.scanArn;
        }

        public final void setScanArn(String scanArn) {
            this.scanArn = scanArn;
        }

        @Override
        public final Builder scanArn(String scanArn) {
            this.scanArn = scanArn;
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(CisScanResultDetailsSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(CisSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getTargetResourceId() {
            return this.targetResourceId;
        }

        public final void setTargetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
        }

        @Override
        public final Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCisScanResultDetailsRequest build() {
            return new GetCisScanResultDetailsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Inspector2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCisScanResultDetailsRequest> {
        public Builder accountId(String var1);

        public Builder filterCriteria(CisScanResultDetailsFilterCriteria var1);

        default public Builder filterCriteria(Consumer<CisScanResultDetailsFilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((CisScanResultDetailsFilterCriteria)((CisScanResultDetailsFilterCriteria.Builder)CisScanResultDetailsFilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder scanArn(String var1);

        public Builder sortBy(String var1);

        public Builder sortBy(CisScanResultDetailsSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(CisSortOrder var1);

        public Builder targetResourceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

