/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2Client;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.CisScan;
import software.amazon.awssdk.services.inspector2.model.ListCisScansRequest;
import software.amazon.awssdk.services.inspector2.model.ListCisScansResponse;

public class ListCisScansIterable
implements SdkIterable<ListCisScansResponse> {
    private final Inspector2Client client;
    private final ListCisScansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCisScansIterable(Inspector2Client client, ListCisScansRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCisScansResponseFetcher();
    }

    public Iterator<ListCisScansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CisScan> scans() {
        Function<ListCisScansResponse, Iterator> getIterator = response -> {
            if (response != null && response.scans() != null) {
                return response.scans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCisScansResponseFetcher
    implements SyncPageFetcher<ListCisScansResponse> {
        private ListCisScansResponseFetcher() {
        }

        public boolean hasNextPage(ListCisScansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCisScansResponse nextPage(ListCisScansResponse previousPage) {
            if (previousPage == null) {
                return ListCisScansIterable.this.client.listCisScans(ListCisScansIterable.this.firstRequest);
            }
            return ListCisScansIterable.this.client.listCisScans((ListCisScansRequest)((Object)ListCisScansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

