/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector2.model.CodeSecurityScanConfiguration;
import software.amazon.awssdk.services.inspector2.model.ConfigurationLevel;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.services.inspector2.model.ScopeSettings;
import software.amazon.awssdk.services.inspector2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCodeSecurityScanConfigurationResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, GetCodeSecurityScanConfigurationResponse> {
    private static final SdkField<String> SCAN_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanConfigurationArn").getter(GetCodeSecurityScanConfigurationResponse.getter(GetCodeSecurityScanConfigurationResponse::scanConfigurationArn)).setter(GetCodeSecurityScanConfigurationResponse.setter(Builder::scanConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetCodeSecurityScanConfigurationResponse.getter(GetCodeSecurityScanConfigurationResponse::name)).setter(GetCodeSecurityScanConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<CodeSecurityScanConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(GetCodeSecurityScanConfigurationResponse.getter(GetCodeSecurityScanConfigurationResponse::configuration)).setter(GetCodeSecurityScanConfigurationResponse.setter(Builder::configuration)).constructor(CodeSecurityScanConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("level").getter(GetCodeSecurityScanConfigurationResponse.getter(GetCodeSecurityScanConfigurationResponse::levelAsString)).setter(GetCodeSecurityScanConfigurationResponse.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()}).build();
    private static final SdkField<ScopeSettings> SCOPE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scopeSettings").getter(GetCodeSecurityScanConfigurationResponse.getter(GetCodeSecurityScanConfigurationResponse::scopeSettings)).setter(GetCodeSecurityScanConfigurationResponse.setter(Builder::scopeSettings)).constructor(ScopeSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeSettings").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetCodeSecurityScanConfigurationResponse.getter(GetCodeSecurityScanConfigurationResponse::createdAt)).setter(GetCodeSecurityScanConfigurationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetCodeSecurityScanConfigurationResponse.getter(GetCodeSecurityScanConfigurationResponse::lastUpdatedAt)).setter(GetCodeSecurityScanConfigurationResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetCodeSecurityScanConfigurationResponse.getter(GetCodeSecurityScanConfigurationResponse::tags)).setter(GetCodeSecurityScanConfigurationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_CONFIGURATION_ARN_FIELD, NAME_FIELD, CONFIGURATION_FIELD, LEVEL_FIELD, SCOPE_SETTINGS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCodeSecurityScanConfigurationResponse.memberNameToFieldInitializer();
    private final String scanConfigurationArn;
    private final String name;
    private final CodeSecurityScanConfiguration configuration;
    private final String level;
    private final ScopeSettings scopeSettings;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final Map<String, String> tags;

    private GetCodeSecurityScanConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.scanConfigurationArn = builder.scanConfigurationArn;
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.level = builder.level;
        this.scopeSettings = builder.scopeSettings;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.tags = builder.tags;
    }

    public final String scanConfigurationArn() {
        return this.scanConfigurationArn;
    }

    public final String name() {
        return this.name;
    }

    public final CodeSecurityScanConfiguration configuration() {
        return this.configuration;
    }

    public final ConfigurationLevel level() {
        return ConfigurationLevel.fromValue(this.level);
    }

    public final String levelAsString() {
        return this.level;
    }

    public final ScopeSettings scopeSettings() {
        return this.scopeSettings;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scanConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCodeSecurityScanConfigurationResponse)) {
            return false;
        }
        GetCodeSecurityScanConfigurationResponse other = (GetCodeSecurityScanConfigurationResponse)((Object)obj);
        return Objects.equals(this.scanConfigurationArn(), other.scanConfigurationArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.levelAsString(), other.levelAsString()) && Objects.equals(this.scopeSettings(), other.scopeSettings()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetCodeSecurityScanConfigurationResponse").add("ScanConfigurationArn", (Object)this.scanConfigurationArn()).add("Name", (Object)this.name()).add("Configuration", (Object)this.configuration()).add("Level", (Object)this.levelAsString()).add("ScopeSettings", (Object)this.scopeSettings()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scanConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.scanConfigurationArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
            case "scopeSettings": {
                return Optional.ofNullable(clazz.cast(this.scopeSettings()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scanConfigurationArn", SCAN_CONFIGURATION_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("level", LEVEL_FIELD);
        map.put("scopeSettings", SCOPE_SETTINGS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCodeSecurityScanConfigurationResponse, T> g) {
        return obj -> g.apply((GetCodeSecurityScanConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private String scanConfigurationArn;
        private String name;
        private CodeSecurityScanConfiguration configuration;
        private String level;
        private ScopeSettings scopeSettings;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCodeSecurityScanConfigurationResponse model) {
            super(model);
            this.scanConfigurationArn(model.scanConfigurationArn);
            this.name(model.name);
            this.configuration(model.configuration);
            this.level(model.level);
            this.scopeSettings(model.scopeSettings);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.tags(model.tags);
        }

        public final String getScanConfigurationArn() {
            return this.scanConfigurationArn;
        }

        public final void setScanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
        }

        @Override
        public final Builder scanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CodeSecurityScanConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(CodeSecurityScanConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CodeSecurityScanConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getLevel() {
            return this.level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(ConfigurationLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final ScopeSettings.Builder getScopeSettings() {
            return this.scopeSettings != null ? this.scopeSettings.toBuilder() : null;
        }

        public final void setScopeSettings(ScopeSettings.BuilderImpl scopeSettings) {
            this.scopeSettings = scopeSettings != null ? scopeSettings.build() : null;
        }

        @Override
        public final Builder scopeSettings(ScopeSettings scopeSettings) {
            this.scopeSettings = scopeSettings;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetCodeSecurityScanConfigurationResponse build() {
            return new GetCodeSecurityScanConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCodeSecurityScanConfigurationResponse> {
        public Builder scanConfigurationArn(String var1);

        public Builder name(String var1);

        public Builder configuration(CodeSecurityScanConfiguration var1);

        default public Builder configuration(Consumer<CodeSecurityScanConfiguration.Builder> configuration) {
            return this.configuration((CodeSecurityScanConfiguration)((CodeSecurityScanConfiguration.Builder)CodeSecurityScanConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder level(String var1);

        public Builder level(ConfigurationLevel var1);

        public Builder scopeSettings(ScopeSettings var1);

        default public Builder scopeSettings(Consumer<ScopeSettings.Builder> scopeSettings) {
            return this.scopeSettings((ScopeSettings)((ScopeSettings.Builder)ScopeSettings.builder().applyMutation(scopeSettings)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

