/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2Client;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.ClusterInformation;
import software.amazon.awssdk.services.inspector2.model.GetClustersForImageRequest;
import software.amazon.awssdk.services.inspector2.model.GetClustersForImageResponse;

public class GetClustersForImageIterable
implements SdkIterable<GetClustersForImageResponse> {
    private final Inspector2Client client;
    private final GetClustersForImageRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetClustersForImageIterable(Inspector2Client client, GetClustersForImageRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetClustersForImageResponseFetcher();
    }

    public Iterator<GetClustersForImageResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterInformation> cluster() {
        Function<GetClustersForImageResponse, Iterator> getIterator = response -> {
            if (response != null && response.cluster() != null) {
                return response.cluster().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetClustersForImageResponseFetcher
    implements SyncPageFetcher<GetClustersForImageResponse> {
        private GetClustersForImageResponseFetcher() {
        }

        public boolean hasNextPage(GetClustersForImageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetClustersForImageResponse nextPage(GetClustersForImageResponse previousPage) {
            if (previousPage == null) {
                return GetClustersForImageIterable.this.client.getClustersForImage(GetClustersForImageIterable.this.firstRequest);
            }
            return GetClustersForImageIterable.this.client.getClustersForImage((GetClustersForImageRequest)((Object)GetClustersForImageIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

