/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2Client;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest;
import software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse;
import software.amazon.awssdk.services.inspector2.model.Vulnerability;

public class SearchVulnerabilitiesIterable
implements SdkIterable<SearchVulnerabilitiesResponse> {
    private final Inspector2Client client;
    private final SearchVulnerabilitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchVulnerabilitiesIterable(Inspector2Client client, SearchVulnerabilitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchVulnerabilitiesResponseFetcher();
    }

    public Iterator<SearchVulnerabilitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Vulnerability> vulnerabilities() {
        Function<SearchVulnerabilitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.vulnerabilities() != null) {
                return response.vulnerabilities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchVulnerabilitiesResponseFetcher
    implements SyncPageFetcher<SearchVulnerabilitiesResponse> {
        private SearchVulnerabilitiesResponseFetcher() {
        }

        public boolean hasNextPage(SearchVulnerabilitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchVulnerabilitiesResponse nextPage(SearchVulnerabilitiesResponse previousPage) {
            if (previousPage == null) {
                return SearchVulnerabilitiesIterable.this.client.searchVulnerabilities(SearchVulnerabilitiesIterable.this.firstRequest);
            }
            return SearchVulnerabilitiesIterable.this.client.searchVulnerabilities((SearchVulnerabilitiesRequest)((Object)SearchVulnerabilitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

