/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.internetmonitor.model.MonitorConfigState;
import software.amazon.awssdk.services.internetmonitor.model.MonitorProcessingStatusCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Monitor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Monitor> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorName").getter(Monitor.getter(Monitor::monitorName)).setter(Monitor.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorName").build()}).build();
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorArn").getter(Monitor.getter(Monitor::monitorArn)).setter(Monitor.setter(Builder::monitorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Monitor.getter(Monitor::statusAsString)).setter(Monitor.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> PROCESSING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcessingStatus").getter(Monitor.getter(Monitor::processingStatusAsString)).setter(Monitor.setter(Builder::processingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD, MONITOR_ARN_FIELD, STATUS_FIELD, PROCESSING_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String monitorName;
    private final String monitorArn;
    private final String status;
    private final String processingStatus;

    private Monitor(BuilderImpl builder) {
        this.monitorName = builder.monitorName;
        this.monitorArn = builder.monitorArn;
        this.status = builder.status;
        this.processingStatus = builder.processingStatus;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final String monitorArn() {
        return this.monitorArn;
    }

    public final MonitorConfigState status() {
        return MonitorConfigState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final MonitorProcessingStatusCode processingStatus() {
        return MonitorProcessingStatusCode.fromValue(this.processingStatus);
    }

    public final String processingStatusAsString() {
        return this.processingStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Monitor)) {
            return false;
        }
        Monitor other = (Monitor)obj;
        return Objects.equals(this.monitorName(), other.monitorName()) && Objects.equals(this.monitorArn(), other.monitorArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.processingStatusAsString(), other.processingStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Monitor").add("MonitorName", (Object)this.monitorName()).add("MonitorArn", (Object)this.monitorArn()).add("Status", (Object)this.statusAsString()).add("ProcessingStatus", (Object)this.processingStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "MonitorArn": {
                return Optional.ofNullable(clazz.cast(this.monitorArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ProcessingStatus": {
                return Optional.ofNullable(clazz.cast(this.processingStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Monitor, T> g) {
        return obj -> g.apply((Monitor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String monitorName;
        private String monitorArn;
        private String status;
        private String processingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Monitor model) {
            this.monitorName(model.monitorName);
            this.monitorArn(model.monitorArn);
            this.status(model.status);
            this.processingStatus(model.processingStatus);
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getMonitorArn() {
            return this.monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MonitorConfigState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getProcessingStatus() {
            return this.processingStatus;
        }

        public final void setProcessingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
        }

        @Override
        public final Builder processingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
            return this;
        }

        @Override
        public final Builder processingStatus(MonitorProcessingStatusCode processingStatus) {
            this.processingStatus(processingStatus == null ? null : processingStatus.toString());
            return this;
        }

        public Monitor build() {
            return new Monitor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Monitor> {
        public Builder monitorName(String var1);

        public Builder monitorArn(String var1);

        public Builder status(String var1);

        public Builder status(MonitorConfigState var1);

        public Builder processingStatus(String var1);

        public Builder processingStatus(MonitorProcessingStatusCode var1);
    }
}

