/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.internetmonitor.model.ClientLocation;
import software.amazon.awssdk.services.internetmonitor.model.InternetEventStatus;
import software.amazon.awssdk.services.internetmonitor.model.InternetEventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InternetEventSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InternetEventSummary> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventId").getter(InternetEventSummary.getter(InternetEventSummary::eventId)).setter(InternetEventSummary.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()}).build();
    private static final SdkField<String> EVENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventArn").getter(InternetEventSummary.getter(InternetEventSummary::eventArn)).setter(InternetEventSummary.setter(Builder::eventArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventArn").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAt").getter(InternetEventSummary.getter(InternetEventSummary::startedAt)).setter(InternetEventSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndedAt").getter(InternetEventSummary.getter(InternetEventSummary::endedAt)).setter(InternetEventSummary.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ClientLocation> CLIENT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientLocation").getter(InternetEventSummary.getter(InternetEventSummary::clientLocation)).setter(InternetEventSummary.setter(Builder::clientLocation)).constructor(ClientLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientLocation").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventType").getter(InternetEventSummary.getter(InternetEventSummary::eventTypeAsString)).setter(InternetEventSummary.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()}).build();
    private static final SdkField<String> EVENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventStatus").getter(InternetEventSummary.getter(InternetEventSummary::eventStatusAsString)).setter(InternetEventSummary.setter(Builder::eventStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, EVENT_ARN_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, CLIENT_LOCATION_FIELD, EVENT_TYPE_FIELD, EVENT_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventId;
    private final String eventArn;
    private final Instant startedAt;
    private final Instant endedAt;
    private final ClientLocation clientLocation;
    private final String eventType;
    private final String eventStatus;

    private InternetEventSummary(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventArn = builder.eventArn;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.clientLocation = builder.clientLocation;
        this.eventType = builder.eventType;
        this.eventStatus = builder.eventStatus;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String eventArn() {
        return this.eventArn;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final ClientLocation clientLocation() {
        return this.clientLocation;
    }

    public final InternetEventType eventType() {
        return InternetEventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final InternetEventStatus eventStatus() {
        return InternetEventStatus.fromValue(this.eventStatus);
    }

    public final String eventStatusAsString() {
        return this.eventStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternetEventSummary)) {
            return false;
        }
        InternetEventSummary other = (InternetEventSummary)obj;
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventArn(), other.eventArn()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.clientLocation(), other.clientLocation()) && Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.eventStatusAsString(), other.eventStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InternetEventSummary").add("EventId", (Object)this.eventId()).add("EventArn", (Object)this.eventArn()).add("StartedAt", (Object)this.startedAt()).add("EndedAt", (Object)this.endedAt()).add("ClientLocation", (Object)this.clientLocation()).add("EventType", (Object)this.eventTypeAsString()).add("EventStatus", (Object)this.eventStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "EventArn": {
                return Optional.ofNullable(clazz.cast(this.eventArn()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "EndedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "ClientLocation": {
                return Optional.ofNullable(clazz.cast(this.clientLocation()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "EventStatus": {
                return Optional.ofNullable(clazz.cast(this.eventStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InternetEventSummary, T> g) {
        return obj -> g.apply((InternetEventSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private String eventArn;
        private Instant startedAt;
        private Instant endedAt;
        private ClientLocation clientLocation;
        private String eventType;
        private String eventStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(InternetEventSummary model) {
            this.eventId(model.eventId);
            this.eventArn(model.eventArn);
            this.startedAt(model.startedAt);
            this.endedAt(model.endedAt);
            this.clientLocation(model.clientLocation);
            this.eventType(model.eventType);
            this.eventStatus(model.eventStatus);
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventArn() {
            return this.eventArn;
        }

        public final void setEventArn(String eventArn) {
            this.eventArn = eventArn;
        }

        @Override
        public final Builder eventArn(String eventArn) {
            this.eventArn = eventArn;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final ClientLocation.Builder getClientLocation() {
            return this.clientLocation != null ? this.clientLocation.toBuilder() : null;
        }

        public final void setClientLocation(ClientLocation.BuilderImpl clientLocation) {
            this.clientLocation = clientLocation != null ? clientLocation.build() : null;
        }

        @Override
        public final Builder clientLocation(ClientLocation clientLocation) {
            this.clientLocation = clientLocation;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(InternetEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getEventStatus() {
            return this.eventStatus;
        }

        public final void setEventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
        }

        @Override
        public final Builder eventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
            return this;
        }

        @Override
        public final Builder eventStatus(InternetEventStatus eventStatus) {
            this.eventStatus(eventStatus == null ? null : eventStatus.toString());
            return this;
        }

        public InternetEventSummary build() {
            return new InternetEventSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InternetEventSummary> {
        public Builder eventId(String var1);

        public Builder eventArn(String var1);

        public Builder startedAt(Instant var1);

        public Builder endedAt(Instant var1);

        public Builder clientLocation(ClientLocation var1);

        default public Builder clientLocation(Consumer<ClientLocation.Builder> clientLocation) {
            return this.clientLocation((ClientLocation)((ClientLocation.Builder)ClientLocation.builder().applyMutation(clientLocation)).build());
        }

        public Builder eventType(String var1);

        public Builder eventType(InternetEventType var1);

        public Builder eventStatus(String var1);

        public Builder eventStatus(InternetEventStatus var1);
    }
}

