/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CustomMetricType {
    STRING_LIST("string-list"),
    IP_ADDRESS_LIST("ip-address-list"),
    NUMBER_LIST("number-list"),
    NUMBER("number"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CustomMetricType> VALUE_MAP;
    private final String value;

    private CustomMetricType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CustomMetricType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CustomMetricType> knownValues() {
        EnumSet<CustomMetricType> knownValues = EnumSet.allOf(CustomMetricType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CustomMetricType.class, CustomMetricType::toString);
    }
}

