/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainConfigurationResponse
extends IotResponse
implements ToCopyableBuilder<Builder, CreateDomainConfigurationResponse> {
    private static final SdkField<String> DOMAIN_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainConfigurationName").getter(CreateDomainConfigurationResponse.getter(CreateDomainConfigurationResponse::domainConfigurationName)).setter(CreateDomainConfigurationResponse.setter(Builder::domainConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationName").build()}).build();
    private static final SdkField<String> DOMAIN_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainConfigurationArn").getter(CreateDomainConfigurationResponse.getter(CreateDomainConfigurationResponse::domainConfigurationArn)).setter(CreateDomainConfigurationResponse.setter(Builder::domainConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONFIGURATION_NAME_FIELD, DOMAIN_CONFIGURATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDomainConfigurationResponse.memberNameToFieldInitializer();
    private final String domainConfigurationName;
    private final String domainConfigurationArn;

    private CreateDomainConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.domainConfigurationName = builder.domainConfigurationName;
        this.domainConfigurationArn = builder.domainConfigurationArn;
    }

    public final String domainConfigurationName() {
        return this.domainConfigurationName;
    }

    public final String domainConfigurationArn() {
        return this.domainConfigurationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainConfigurationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainConfigurationResponse)) {
            return false;
        }
        CreateDomainConfigurationResponse other = (CreateDomainConfigurationResponse)((Object)obj);
        return Objects.equals(this.domainConfigurationName(), other.domainConfigurationName()) && Objects.equals(this.domainConfigurationArn(), other.domainConfigurationArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDomainConfigurationResponse").add("DomainConfigurationName", (Object)this.domainConfigurationName()).add("DomainConfigurationArn", (Object)this.domainConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.domainConfigurationName()));
            }
            case "domainConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.domainConfigurationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("domainConfigurationName", DOMAIN_CONFIGURATION_NAME_FIELD);
        map.put("domainConfigurationArn", DOMAIN_CONFIGURATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainConfigurationResponse, T> g) {
        return obj -> g.apply((CreateDomainConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String domainConfigurationName;
        private String domainConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainConfigurationResponse model) {
            super(model);
            this.domainConfigurationName(model.domainConfigurationName);
            this.domainConfigurationArn(model.domainConfigurationArn);
        }

        public final String getDomainConfigurationName() {
            return this.domainConfigurationName;
        }

        public final void setDomainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
        }

        @Override
        public final Builder domainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
            return this;
        }

        public final String getDomainConfigurationArn() {
            return this.domainConfigurationArn;
        }

        public final void setDomainConfigurationArn(String domainConfigurationArn) {
            this.domainConfigurationArn = domainConfigurationArn;
        }

        @Override
        public final Builder domainConfigurationArn(String domainConfigurationArn) {
            this.domainConfigurationArn = domainConfigurationArn;
            return this;
        }

        @Override
        public CreateDomainConfigurationResponse build() {
            return new CreateDomainConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainConfigurationResponse> {
        public Builder domainConfigurationName(String var1);

        public Builder domainConfigurationArn(String var1);
    }
}

