/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePolicyVersionResponse
extends IotResponse
implements ToCopyableBuilder<Builder, CreatePolicyVersionResponse> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(CreatePolicyVersionResponse.getter(CreatePolicyVersionResponse::policyArn)).setter(CreatePolicyVersionResponse.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyDocument").getter(CreatePolicyVersionResponse.getter(CreatePolicyVersionResponse::policyDocument)).setter(CreatePolicyVersionResponse.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()}).build();
    private static final SdkField<String> POLICY_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyVersionId").getter(CreatePolicyVersionResponse.getter(CreatePolicyVersionResponse::policyVersionId)).setter(CreatePolicyVersionResponse.setter(Builder::policyVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyVersionId").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isDefaultVersion").getter(CreatePolicyVersionResponse.getter(CreatePolicyVersionResponse::isDefaultVersion)).setter(CreatePolicyVersionResponse.setter(Builder::isDefaultVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDefaultVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, POLICY_DOCUMENT_FIELD, POLICY_VERSION_ID_FIELD, IS_DEFAULT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePolicyVersionResponse.memberNameToFieldInitializer();
    private final String policyArn;
    private final String policyDocument;
    private final String policyVersionId;
    private final Boolean isDefaultVersion;

    private CreatePolicyVersionResponse(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.policyDocument = builder.policyDocument;
        this.policyVersionId = builder.policyVersionId;
        this.isDefaultVersion = builder.isDefaultVersion;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final String policyVersionId() {
        return this.policyVersionId;
    }

    public final Boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefaultVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyVersionResponse)) {
            return false;
        }
        CreatePolicyVersionResponse other = (CreatePolicyVersionResponse)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.policyVersionId(), other.policyVersionId()) && Objects.equals(this.isDefaultVersion(), other.isDefaultVersion());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePolicyVersionResponse").add("PolicyArn", (Object)this.policyArn()).add("PolicyDocument", (Object)this.policyDocument()).add("PolicyVersionId", (Object)this.policyVersionId()).add("IsDefaultVersion", (Object)this.isDefaultVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "policyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "policyVersionId": {
                return Optional.ofNullable(clazz.cast(this.policyVersionId()));
            }
            case "isDefaultVersion": {
                return Optional.ofNullable(clazz.cast(this.isDefaultVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        map.put("policyVersionId", POLICY_VERSION_ID_FIELD);
        map.put("isDefaultVersion", IS_DEFAULT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePolicyVersionResponse, T> g) {
        return obj -> g.apply((CreatePolicyVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String policyArn;
        private String policyDocument;
        private String policyVersionId;
        private Boolean isDefaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyVersionResponse model) {
            super(model);
            this.policyArn(model.policyArn);
            this.policyDocument(model.policyDocument);
            this.policyVersionId(model.policyVersionId);
            this.isDefaultVersion(model.isDefaultVersion);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getPolicyVersionId() {
            return this.policyVersionId;
        }

        public final void setPolicyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        @Override
        public final Builder policyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        public final Boolean getIsDefaultVersion() {
            return this.isDefaultVersion;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        @Override
        public CreatePolicyVersionResponse build() {
            return new CreatePolicyVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePolicyVersionResponse> {
        public Builder policyArn(String var1);

        public Builder policyDocument(String var1);

        public Builder policyVersionId(String var1);

        public Builder isDefaultVersion(Boolean var1);
    }
}

