/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ThingPrincipalType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThingPrincipalsV2Request
extends IotRequest
implements ToCopyableBuilder<Builder, ListThingPrincipalsV2Request> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListThingPrincipalsV2Request.getter(ListThingPrincipalsV2Request::nextToken)).setter(ListThingPrincipalsV2Request.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListThingPrincipalsV2Request.getter(ListThingPrincipalsV2Request::maxResults)).setter(ListThingPrincipalsV2Request.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(ListThingPrincipalsV2Request.getter(ListThingPrincipalsV2Request::thingName)).setter(ListThingPrincipalsV2Request.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()}).build();
    private static final SdkField<String> THING_PRINCIPAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingPrincipalType").getter(ListThingPrincipalsV2Request.getter(ListThingPrincipalsV2Request::thingPrincipalTypeAsString)).setter(ListThingPrincipalsV2Request.setter(Builder::thingPrincipalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("thingPrincipalType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, THING_NAME_FIELD, THING_PRINCIPAL_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListThingPrincipalsV2Request.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxResults;
    private final String thingName;
    private final String thingPrincipalType;

    private ListThingPrincipalsV2Request(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.thingName = builder.thingName;
        this.thingPrincipalType = builder.thingPrincipalType;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String thingName() {
        return this.thingName;
    }

    public final ThingPrincipalType thingPrincipalType() {
        return ThingPrincipalType.fromValue(this.thingPrincipalType);
    }

    public final String thingPrincipalTypeAsString() {
        return this.thingPrincipalType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingPrincipalTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingPrincipalsV2Request)) {
            return false;
        }
        ListThingPrincipalsV2Request other = (ListThingPrincipalsV2Request)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.thingPrincipalTypeAsString(), other.thingPrincipalTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListThingPrincipalsV2Request").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ThingName", (Object)this.thingName()).add("ThingPrincipalType", (Object)this.thingPrincipalTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "thingPrincipalType": {
                return Optional.ofNullable(clazz.cast(this.thingPrincipalTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("thingName", THING_NAME_FIELD);
        map.put("thingPrincipalType", THING_PRINCIPAL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListThingPrincipalsV2Request, T> g) {
        return obj -> g.apply((ListThingPrincipalsV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String thingName;
        private String thingPrincipalType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingPrincipalsV2Request model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.thingName(model.thingName);
            this.thingPrincipalType(model.thingPrincipalType);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getThingName() {
            return this.thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getThingPrincipalType() {
            return this.thingPrincipalType;
        }

        public final void setThingPrincipalType(String thingPrincipalType) {
            this.thingPrincipalType = thingPrincipalType;
        }

        @Override
        public final Builder thingPrincipalType(String thingPrincipalType) {
            this.thingPrincipalType = thingPrincipalType;
            return this;
        }

        @Override
        public final Builder thingPrincipalType(ThingPrincipalType thingPrincipalType) {
            this.thingPrincipalType(thingPrincipalType == null ? null : thingPrincipalType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListThingPrincipalsV2Request build() {
            return new ListThingPrincipalsV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListThingPrincipalsV2Request> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder thingName(String var1);

        public Builder thingPrincipalType(String var1);

        public Builder thingPrincipalType(ThingPrincipalType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

