/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReportType {
    ERRORS("ERRORS"),
    RESULTS("RESULTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReportType> VALUE_MAP;
    private final String value;

    private ReportType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReportType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReportType> knownValues() {
        EnumSet<ReportType> knownValues = EnumSet.allOf(ReportType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReportType.class, ReportType::toString);
    }
}

