/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ResourceIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAuditSuppressionRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateAuditSuppressionRequest> {
    private static final SdkField<String> CHECK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checkName").getter(UpdateAuditSuppressionRequest.getter(UpdateAuditSuppressionRequest::checkName)).setter(UpdateAuditSuppressionRequest.setter(Builder::checkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkName").build()}).build();
    private static final SdkField<ResourceIdentifier> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceIdentifier").getter(UpdateAuditSuppressionRequest.getter(UpdateAuditSuppressionRequest::resourceIdentifier)).setter(UpdateAuditSuppressionRequest.setter(Builder::resourceIdentifier)).constructor(ResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build()}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expirationDate").getter(UpdateAuditSuppressionRequest.getter(UpdateAuditSuppressionRequest::expirationDate)).setter(UpdateAuditSuppressionRequest.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build()}).build();
    private static final SdkField<Boolean> SUPPRESS_INDEFINITELY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("suppressIndefinitely").getter(UpdateAuditSuppressionRequest.getter(UpdateAuditSuppressionRequest::suppressIndefinitely)).setter(UpdateAuditSuppressionRequest.setter(Builder::suppressIndefinitely)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressIndefinitely").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAuditSuppressionRequest.getter(UpdateAuditSuppressionRequest::description)).setter(UpdateAuditSuppressionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_NAME_FIELD, RESOURCE_IDENTIFIER_FIELD, EXPIRATION_DATE_FIELD, SUPPRESS_INDEFINITELY_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAuditSuppressionRequest.memberNameToFieldInitializer();
    private final String checkName;
    private final ResourceIdentifier resourceIdentifier;
    private final Instant expirationDate;
    private final Boolean suppressIndefinitely;
    private final String description;

    private UpdateAuditSuppressionRequest(BuilderImpl builder) {
        super(builder);
        this.checkName = builder.checkName;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.expirationDate = builder.expirationDate;
        this.suppressIndefinitely = builder.suppressIndefinitely;
        this.description = builder.description;
    }

    public final String checkName() {
        return this.checkName;
    }

    public final ResourceIdentifier resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final Instant expirationDate() {
        return this.expirationDate;
    }

    public final Boolean suppressIndefinitely() {
        return this.suppressIndefinitely;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.checkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressIndefinitely());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAuditSuppressionRequest)) {
            return false;
        }
        UpdateAuditSuppressionRequest other = (UpdateAuditSuppressionRequest)((Object)obj);
        return Objects.equals(this.checkName(), other.checkName()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.suppressIndefinitely(), other.suppressIndefinitely()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAuditSuppressionRequest").add("CheckName", (Object)this.checkName()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("ExpirationDate", (Object)this.expirationDate()).add("SuppressIndefinitely", (Object)this.suppressIndefinitely()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "checkName": {
                return Optional.ofNullable(clazz.cast(this.checkName()));
            }
            case "resourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "expirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
            case "suppressIndefinitely": {
                return Optional.ofNullable(clazz.cast(this.suppressIndefinitely()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("checkName", CHECK_NAME_FIELD);
        map.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("expirationDate", EXPIRATION_DATE_FIELD);
        map.put("suppressIndefinitely", SUPPRESS_INDEFINITELY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAuditSuppressionRequest, T> g) {
        return obj -> g.apply((UpdateAuditSuppressionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String checkName;
        private ResourceIdentifier resourceIdentifier;
        private Instant expirationDate;
        private Boolean suppressIndefinitely;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAuditSuppressionRequest model) {
            super(model);
            this.checkName(model.checkName);
            this.resourceIdentifier(model.resourceIdentifier);
            this.expirationDate(model.expirationDate);
            this.suppressIndefinitely(model.suppressIndefinitely);
            this.description(model.description);
        }

        public final String getCheckName() {
            return this.checkName;
        }

        public final void setCheckName(String checkName) {
            this.checkName = checkName;
        }

        @Override
        public final Builder checkName(String checkName) {
            this.checkName = checkName;
            return this;
        }

        public final ResourceIdentifier.Builder getResourceIdentifier() {
            return this.resourceIdentifier != null ? this.resourceIdentifier.toBuilder() : null;
        }

        public final void setResourceIdentifier(ResourceIdentifier.BuilderImpl resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier != null ? resourceIdentifier.build() : null;
        }

        @Override
        public final Builder resourceIdentifier(ResourceIdentifier resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final Boolean getSuppressIndefinitely() {
            return this.suppressIndefinitely;
        }

        public final void setSuppressIndefinitely(Boolean suppressIndefinitely) {
            this.suppressIndefinitely = suppressIndefinitely;
        }

        @Override
        public final Builder suppressIndefinitely(Boolean suppressIndefinitely) {
            this.suppressIndefinitely = suppressIndefinitely;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAuditSuppressionRequest build() {
            return new UpdateAuditSuppressionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAuditSuppressionRequest> {
        public Builder checkName(String var1);

        public Builder resourceIdentifier(ResourceIdentifier var1);

        default public Builder resourceIdentifier(Consumer<ResourceIdentifier.Builder> resourceIdentifier) {
            return this.resourceIdentifier((ResourceIdentifier)((ResourceIdentifier.Builder)ResourceIdentifier.builder().applyMutation(resourceIdentifier)).build());
        }

        public Builder expirationDate(Instant var1);

        public Builder suppressIndefinitely(Boolean var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

