/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.CommandExecutionSummary;
import software.amazon.awssdk.services.iot.model.ListCommandExecutionsRequest;
import software.amazon.awssdk.services.iot.model.ListCommandExecutionsResponse;

public class ListCommandExecutionsIterable
implements SdkIterable<ListCommandExecutionsResponse> {
    private final IotClient client;
    private final ListCommandExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCommandExecutionsIterable(IotClient client, ListCommandExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCommandExecutionsResponseFetcher();
    }

    public Iterator<ListCommandExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CommandExecutionSummary> commandExecutions() {
        Function<ListCommandExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.commandExecutions() != null) {
                return response.commandExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCommandExecutionsResponseFetcher
    implements SyncPageFetcher<ListCommandExecutionsResponse> {
        private ListCommandExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommandExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCommandExecutionsResponse nextPage(ListCommandExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListCommandExecutionsIterable.this.client.listCommandExecutions(ListCommandExecutionsIterable.this.firstRequest);
            }
            return ListCommandExecutionsIterable.this.client.listCommandExecutions((ListCommandExecutionsRequest)((Object)ListCommandExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

