/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListPolicyPrincipalsRequest;
import software.amazon.awssdk.services.iot.model.ListPolicyPrincipalsResponse;

public class ListPolicyPrincipalsIterable
implements SdkIterable<ListPolicyPrincipalsResponse> {
    private final IotClient client;
    private final ListPolicyPrincipalsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPolicyPrincipalsIterable(IotClient client, ListPolicyPrincipalsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPolicyPrincipalsResponseFetcher();
    }

    public Iterator<ListPolicyPrincipalsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> principals() {
        Function<ListPolicyPrincipalsResponse, Iterator> getIterator = response -> {
            if (response != null && response.principals() != null) {
                return response.principals().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPolicyPrincipalsResponseFetcher
    implements SyncPageFetcher<ListPolicyPrincipalsResponse> {
        private ListPolicyPrincipalsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyPrincipalsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListPolicyPrincipalsResponse nextPage(ListPolicyPrincipalsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyPrincipalsIterable.this.client.listPolicyPrincipals(ListPolicyPrincipalsIterable.this.firstRequest);
            }
            return ListPolicyPrincipalsIterable.this.client.listPolicyPrincipals((ListPolicyPrincipalsRequest)((Object)ListPolicyPrincipalsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

