/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotdataplane.DefaultIotDataPlaneBaseClientBuilder;
import software.amazon.awssdk.services.iotdataplane.DefaultIotDataPlaneClient;
import software.amazon.awssdk.services.iotdataplane.IotDataPlaneClient;
import software.amazon.awssdk.services.iotdataplane.IotDataPlaneClientBuilder;
import software.amazon.awssdk.services.iotdataplane.IotDataPlaneServiceClientConfiguration;
import software.amazon.awssdk.services.iotdataplane.endpoints.IotDataPlaneEndpointProvider;

@SdkInternalApi
final class DefaultIotDataPlaneClientBuilder
extends DefaultIotDataPlaneBaseClientBuilder<IotDataPlaneClientBuilder, IotDataPlaneClient>
implements IotDataPlaneClientBuilder {
    DefaultIotDataPlaneClientBuilder() {
    }

    @Override
    public DefaultIotDataPlaneClientBuilder endpointProvider(IotDataPlaneEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IotDataPlaneClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultIotDataPlaneClientBuilder.validateClientOptions(clientConfiguration);
        IotDataPlaneServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIotDataPlaneClient client = new DefaultIotDataPlaneClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IotDataPlaneServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IotDataPlaneServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

