/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets suite run configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuiteRunConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SuiteRunConfiguration.Builder, SuiteRunConfiguration> {
    private static final SdkField<DeviceUnderTest> PRIMARY_DEVICE_FIELD = SdkField
            .<DeviceUnderTest> builder(MarshallingType.SDK_POJO).memberName("primaryDevice")
            .getter(getter(SuiteRunConfiguration::primaryDevice)).setter(setter(Builder::primaryDevice))
            .constructor(DeviceUnderTest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryDevice").build()).build();

    private static final SdkField<List<String>> SELECTED_TEST_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("selectedTestList")
            .getter(getter(SuiteRunConfiguration::selectedTestList))
            .setter(setter(Builder::selectedTestList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectedTestList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> PARALLEL_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("parallelRun").getter(getter(SuiteRunConfiguration::parallelRun)).setter(setter(Builder::parallelRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parallelRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_DEVICE_FIELD,
            SELECTED_TEST_LIST_FIELD, PARALLEL_RUN_FIELD));

    private static final long serialVersionUID = 1L;

    private final DeviceUnderTest primaryDevice;

    private final List<String> selectedTestList;

    private final Boolean parallelRun;

    private SuiteRunConfiguration(BuilderImpl builder) {
        this.primaryDevice = builder.primaryDevice;
        this.selectedTestList = builder.selectedTestList;
        this.parallelRun = builder.parallelRun;
    }

    /**
     * <p>
     * Sets the primary device for the test suite run. This requires a thing ARN or a certificate ARN.
     * </p>
     * 
     * @return Sets the primary device for the test suite run. This requires a thing ARN or a certificate ARN.
     */
    public final DeviceUnderTest primaryDevice() {
        return primaryDevice;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedTestList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedTestList() {
        return selectedTestList != null && !(selectedTestList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Sets test case list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedTestList} method.
     * </p>
     * 
     * @return Sets test case list.
     */
    public final List<String> selectedTestList() {
        return selectedTestList;
    }

    /**
     * <p>
     * TRUE if multiple test suites run in parallel.
     * </p>
     * 
     * @return TRUE if multiple test suites run in parallel.
     */
    public final Boolean parallelRun() {
        return parallelRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryDevice());
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedTestList() ? selectedTestList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(parallelRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuiteRunConfiguration)) {
            return false;
        }
        SuiteRunConfiguration other = (SuiteRunConfiguration) obj;
        return Objects.equals(primaryDevice(), other.primaryDevice()) && hasSelectedTestList() == other.hasSelectedTestList()
                && Objects.equals(selectedTestList(), other.selectedTestList())
                && Objects.equals(parallelRun(), other.parallelRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuiteRunConfiguration").add("PrimaryDevice", primaryDevice())
                .add("SelectedTestList", hasSelectedTestList() ? selectedTestList() : null).add("ParallelRun", parallelRun())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "primaryDevice":
            return Optional.ofNullable(clazz.cast(primaryDevice()));
        case "selectedTestList":
            return Optional.ofNullable(clazz.cast(selectedTestList()));
        case "parallelRun":
            return Optional.ofNullable(clazz.cast(parallelRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuiteRunConfiguration, T> g) {
        return obj -> g.apply((SuiteRunConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuiteRunConfiguration> {
        /**
         * <p>
         * Sets the primary device for the test suite run. This requires a thing ARN or a certificate ARN.
         * </p>
         * 
         * @param primaryDevice
         *        Sets the primary device for the test suite run. This requires a thing ARN or a certificate ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryDevice(DeviceUnderTest primaryDevice);

        /**
         * <p>
         * Sets the primary device for the test suite run. This requires a thing ARN or a certificate ARN.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceUnderTest.Builder} avoiding the
         * need to create one manually via {@link DeviceUnderTest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceUnderTest.Builder#build()} is called immediately and its
         * result is passed to {@link #primaryDevice(DeviceUnderTest)}.
         * 
         * @param primaryDevice
         *        a consumer that will call methods on {@link DeviceUnderTest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryDevice(DeviceUnderTest)
         */
        default Builder primaryDevice(Consumer<DeviceUnderTest.Builder> primaryDevice) {
            return primaryDevice(DeviceUnderTest.builder().applyMutation(primaryDevice).build());
        }

        /**
         * <p>
         * Sets test case list.
         * </p>
         * 
         * @param selectedTestList
         *        Sets test case list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedTestList(Collection<String> selectedTestList);

        /**
         * <p>
         * Sets test case list.
         * </p>
         * 
         * @param selectedTestList
         *        Sets test case list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedTestList(String... selectedTestList);

        /**
         * <p>
         * TRUE if multiple test suites run in parallel.
         * </p>
         * 
         * @param parallelRun
         *        TRUE if multiple test suites run in parallel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelRun(Boolean parallelRun);
    }

    static final class BuilderImpl implements Builder {
        private DeviceUnderTest primaryDevice;

        private List<String> selectedTestList = DefaultSdkAutoConstructList.getInstance();

        private Boolean parallelRun;

        private BuilderImpl() {
        }

        private BuilderImpl(SuiteRunConfiguration model) {
            primaryDevice(model.primaryDevice);
            selectedTestList(model.selectedTestList);
            parallelRun(model.parallelRun);
        }

        public final DeviceUnderTest.Builder getPrimaryDevice() {
            return primaryDevice != null ? primaryDevice.toBuilder() : null;
        }

        public final void setPrimaryDevice(DeviceUnderTest.BuilderImpl primaryDevice) {
            this.primaryDevice = primaryDevice != null ? primaryDevice.build() : null;
        }

        @Override
        public final Builder primaryDevice(DeviceUnderTest primaryDevice) {
            this.primaryDevice = primaryDevice;
            return this;
        }

        public final Collection<String> getSelectedTestList() {
            if (selectedTestList instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedTestList;
        }

        public final void setSelectedTestList(Collection<String> selectedTestList) {
            this.selectedTestList = SelectedTestListCopier.copy(selectedTestList);
        }

        @Override
        public final Builder selectedTestList(Collection<String> selectedTestList) {
            this.selectedTestList = SelectedTestListCopier.copy(selectedTestList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedTestList(String... selectedTestList) {
            selectedTestList(Arrays.asList(selectedTestList));
            return this;
        }

        public final Boolean getParallelRun() {
            return parallelRun;
        }

        public final void setParallelRun(Boolean parallelRun) {
            this.parallelRun = parallelRun;
        }

        @Override
        public final Builder parallelRun(Boolean parallelRun) {
            this.parallelRun = parallelRun;
            return this;
        }

        @Override
        public SuiteRunConfiguration build() {
            return new SuiteRunConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
