/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAlarmModelVersionsResponse extends IotEventsResponse implements
        ToCopyableBuilder<ListAlarmModelVersionsResponse.Builder, ListAlarmModelVersionsResponse> {
    private static final SdkField<List<AlarmModelVersionSummary>> ALARM_MODEL_VERSION_SUMMARIES_FIELD = SdkField
            .<List<AlarmModelVersionSummary>> builder(MarshallingType.LIST)
            .memberName("alarmModelVersionSummaries")
            .getter(getter(ListAlarmModelVersionsResponse::alarmModelVersionSummaries))
            .setter(setter(Builder::alarmModelVersionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelVersionSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AlarmModelVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlarmModelVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAlarmModelVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ALARM_MODEL_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<AlarmModelVersionSummary> alarmModelVersionSummaries;

    private final String nextToken;

    private ListAlarmModelVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.alarmModelVersionSummaries = builder.alarmModelVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlarmModelVersionSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAlarmModelVersionSummaries() {
        return alarmModelVersionSummaries != null && !(alarmModelVersionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that summarizes each alarm model version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlarmModelVersionSummaries} method.
     * </p>
     * 
     * @return A list that summarizes each alarm model version.
     */
    public final List<AlarmModelVersionSummary> alarmModelVersionSummaries() {
        return alarmModelVersionSummaries;
    }

    /**
     * <p>
     * The token that you can use to return the next set of results, or <code>null</code> if there are no more results.
     * </p>
     * 
     * @return The token that you can use to return the next set of results, or <code>null</code> if there are no more
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAlarmModelVersionSummaries() ? alarmModelVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAlarmModelVersionsResponse)) {
            return false;
        }
        ListAlarmModelVersionsResponse other = (ListAlarmModelVersionsResponse) obj;
        return hasAlarmModelVersionSummaries() == other.hasAlarmModelVersionSummaries()
                && Objects.equals(alarmModelVersionSummaries(), other.alarmModelVersionSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAlarmModelVersionsResponse")
                .add("AlarmModelVersionSummaries", hasAlarmModelVersionSummaries() ? alarmModelVersionSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmModelVersionSummaries":
            return Optional.ofNullable(clazz.cast(alarmModelVersionSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAlarmModelVersionsResponse, T> g) {
        return obj -> g.apply((ListAlarmModelVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAlarmModelVersionsResponse> {
        /**
         * <p>
         * A list that summarizes each alarm model version.
         * </p>
         * 
         * @param alarmModelVersionSummaries
         *        A list that summarizes each alarm model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelVersionSummaries(Collection<AlarmModelVersionSummary> alarmModelVersionSummaries);

        /**
         * <p>
         * A list that summarizes each alarm model version.
         * </p>
         * 
         * @param alarmModelVersionSummaries
         *        A list that summarizes each alarm model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelVersionSummaries(AlarmModelVersionSummary... alarmModelVersionSummaries);

        /**
         * <p>
         * A list that summarizes each alarm model version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotevents.model.AlarmModelVersionSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotevents.model.AlarmModelVersionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotevents.model.AlarmModelVersionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #alarmModelVersionSummaries(List<AlarmModelVersionSummary>)}.
         * 
         * @param alarmModelVersionSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotevents.model.AlarmModelVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmModelVersionSummaries(java.util.Collection<AlarmModelVersionSummary>)
         */
        Builder alarmModelVersionSummaries(Consumer<AlarmModelVersionSummary.Builder>... alarmModelVersionSummaries);

        /**
         * <p>
         * The token that you can use to return the next set of results, or <code>null</code> if there are no more
         * results.
         * </p>
         * 
         * @param nextToken
         *        The token that you can use to return the next set of results, or <code>null</code> if there are no
         *        more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotEventsResponse.BuilderImpl implements Builder {
        private List<AlarmModelVersionSummary> alarmModelVersionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAlarmModelVersionsResponse model) {
            super(model);
            alarmModelVersionSummaries(model.alarmModelVersionSummaries);
            nextToken(model.nextToken);
        }

        public final List<AlarmModelVersionSummary.Builder> getAlarmModelVersionSummaries() {
            List<AlarmModelVersionSummary.Builder> result = AlarmModelVersionSummariesCopier
                    .copyToBuilder(this.alarmModelVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlarmModelVersionSummaries(
                Collection<AlarmModelVersionSummary.BuilderImpl> alarmModelVersionSummaries) {
            this.alarmModelVersionSummaries = AlarmModelVersionSummariesCopier.copyFromBuilder(alarmModelVersionSummaries);
        }

        @Override
        public final Builder alarmModelVersionSummaries(Collection<AlarmModelVersionSummary> alarmModelVersionSummaries) {
            this.alarmModelVersionSummaries = AlarmModelVersionSummariesCopier.copy(alarmModelVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmModelVersionSummaries(AlarmModelVersionSummary... alarmModelVersionSummaries) {
            alarmModelVersionSummaries(Arrays.asList(alarmModelVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmModelVersionSummaries(Consumer<AlarmModelVersionSummary.Builder>... alarmModelVersionSummaries) {
            alarmModelVersionSummaries(Stream.of(alarmModelVersionSummaries)
                    .map(c -> AlarmModelVersionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAlarmModelVersionsResponse build() {
            return new ListAlarmModelVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
