/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the notification settings of an alarm model. The settings apply to all alarms that were created based on
 * this alarm model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationAction implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationAction.Builder, NotificationAction> {
    private static final SdkField<NotificationTargetActions> ACTION_FIELD = SdkField
            .<NotificationTargetActions> builder(MarshallingType.SDK_POJO).memberName("action")
            .getter(getter(NotificationAction::action)).setter(setter(Builder::action))
            .constructor(NotificationTargetActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<List<SMSConfiguration>> SMS_CONFIGURATIONS_FIELD = SdkField
            .<List<SMSConfiguration>> builder(MarshallingType.LIST)
            .memberName("smsConfigurations")
            .getter(getter(NotificationAction::smsConfigurations))
            .setter(setter(Builder::smsConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smsConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SMSConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SMSConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EmailConfiguration>> EMAIL_CONFIGURATIONS_FIELD = SdkField
            .<List<EmailConfiguration>> builder(MarshallingType.LIST)
            .memberName("emailConfigurations")
            .getter(getter(NotificationAction::emailConfigurations))
            .setter(setter(Builder::emailConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EmailConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(EmailConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            SMS_CONFIGURATIONS_FIELD, EMAIL_CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final NotificationTargetActions action;

    private final List<SMSConfiguration> smsConfigurations;

    private final List<EmailConfiguration> emailConfigurations;

    private NotificationAction(BuilderImpl builder) {
        this.action = builder.action;
        this.smsConfigurations = builder.smsConfigurations;
        this.emailConfigurations = builder.emailConfigurations;
    }

    /**
     * <p>
     * Specifies an AWS Lambda function to manage alarm notifications. You can create one or use the <a
     * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS Lambda function
     * provided by AWS IoT Events</a>.
     * </p>
     * 
     * @return Specifies an AWS Lambda function to manage alarm notifications. You can create one or use the <a
     *         href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS Lambda
     *         function provided by AWS IoT Events</a>.
     */
    public final NotificationTargetActions action() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the SmsConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSmsConfigurations() {
        return smsConfigurations != null && !(smsConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the configuration information of SMS notifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSmsConfigurations} method.
     * </p>
     * 
     * @return Contains the configuration information of SMS notifications.
     */
    public final List<SMSConfiguration> smsConfigurations() {
        return smsConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the EmailConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEmailConfigurations() {
        return emailConfigurations != null && !(emailConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the configuration information of email notifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmailConfigurations} method.
     * </p>
     * 
     * @return Contains the configuration information of email notifications.
     */
    public final List<EmailConfiguration> emailConfigurations() {
        return emailConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(hasSmsConfigurations() ? smsConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEmailConfigurations() ? emailConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationAction)) {
            return false;
        }
        NotificationAction other = (NotificationAction) obj;
        return Objects.equals(action(), other.action()) && hasSmsConfigurations() == other.hasSmsConfigurations()
                && Objects.equals(smsConfigurations(), other.smsConfigurations())
                && hasEmailConfigurations() == other.hasEmailConfigurations()
                && Objects.equals(emailConfigurations(), other.emailConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationAction").add("Action", action())
                .add("SmsConfigurations", hasSmsConfigurations() ? smsConfigurations() : null)
                .add("EmailConfigurations", hasEmailConfigurations() ? emailConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "smsConfigurations":
            return Optional.ofNullable(clazz.cast(smsConfigurations()));
        case "emailConfigurations":
            return Optional.ofNullable(clazz.cast(emailConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationAction, T> g) {
        return obj -> g.apply((NotificationAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationAction> {
        /**
         * <p>
         * Specifies an AWS Lambda function to manage alarm notifications. You can create one or use the <a
         * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS Lambda function
         * provided by AWS IoT Events</a>.
         * </p>
         * 
         * @param action
         *        Specifies an AWS Lambda function to manage alarm notifications. You can create one or use the <a
         *        href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS Lambda
         *        function provided by AWS IoT Events</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(NotificationTargetActions action);

        /**
         * <p>
         * Specifies an AWS Lambda function to manage alarm notifications. You can create one or use the <a
         * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS Lambda function
         * provided by AWS IoT Events</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationTargetActions.Builder}
         * avoiding the need to create one manually via {@link NotificationTargetActions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationTargetActions.Builder#build()} is called immediately
         * and its result is passed to {@link #action(NotificationTargetActions)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link NotificationTargetActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(NotificationTargetActions)
         */
        default Builder action(Consumer<NotificationTargetActions.Builder> action) {
            return action(NotificationTargetActions.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * Contains the configuration information of SMS notifications.
         * </p>
         * 
         * @param smsConfigurations
         *        Contains the configuration information of SMS notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsConfigurations(Collection<SMSConfiguration> smsConfigurations);

        /**
         * <p>
         * Contains the configuration information of SMS notifications.
         * </p>
         * 
         * @param smsConfigurations
         *        Contains the configuration information of SMS notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsConfigurations(SMSConfiguration... smsConfigurations);

        /**
         * <p>
         * Contains the configuration information of SMS notifications.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotevents.model.SMSConfiguration.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotevents.model.SMSConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotevents.model.SMSConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #smsConfigurations(List<SMSConfiguration>)}.
         * 
         * @param smsConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotevents.model.SMSConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsConfigurations(java.util.Collection<SMSConfiguration>)
         */
        Builder smsConfigurations(Consumer<SMSConfiguration.Builder>... smsConfigurations);

        /**
         * <p>
         * Contains the configuration information of email notifications.
         * </p>
         * 
         * @param emailConfigurations
         *        Contains the configuration information of email notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailConfigurations(Collection<EmailConfiguration> emailConfigurations);

        /**
         * <p>
         * Contains the configuration information of email notifications.
         * </p>
         * 
         * @param emailConfigurations
         *        Contains the configuration information of email notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailConfigurations(EmailConfiguration... emailConfigurations);

        /**
         * <p>
         * Contains the configuration information of email notifications.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotevents.model.EmailConfiguration.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iotevents.model.EmailConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotevents.model.EmailConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #emailConfigurations(List<EmailConfiguration>)}.
         * 
         * @param emailConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotevents.model.EmailConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailConfigurations(java.util.Collection<EmailConfiguration>)
         */
        Builder emailConfigurations(Consumer<EmailConfiguration.Builder>... emailConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private NotificationTargetActions action;

        private List<SMSConfiguration> smsConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<EmailConfiguration> emailConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationAction model) {
            action(model.action);
            smsConfigurations(model.smsConfigurations);
            emailConfigurations(model.emailConfigurations);
        }

        public final NotificationTargetActions.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(NotificationTargetActions.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(NotificationTargetActions action) {
            this.action = action;
            return this;
        }

        public final List<SMSConfiguration.Builder> getSmsConfigurations() {
            List<SMSConfiguration.Builder> result = SMSConfigurationsCopier.copyToBuilder(this.smsConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSmsConfigurations(Collection<SMSConfiguration.BuilderImpl> smsConfigurations) {
            this.smsConfigurations = SMSConfigurationsCopier.copyFromBuilder(smsConfigurations);
        }

        @Override
        public final Builder smsConfigurations(Collection<SMSConfiguration> smsConfigurations) {
            this.smsConfigurations = SMSConfigurationsCopier.copy(smsConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder smsConfigurations(SMSConfiguration... smsConfigurations) {
            smsConfigurations(Arrays.asList(smsConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder smsConfigurations(Consumer<SMSConfiguration.Builder>... smsConfigurations) {
            smsConfigurations(Stream.of(smsConfigurations).map(c -> SMSConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<EmailConfiguration.Builder> getEmailConfigurations() {
            List<EmailConfiguration.Builder> result = EmailConfigurationsCopier.copyToBuilder(this.emailConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmailConfigurations(Collection<EmailConfiguration.BuilderImpl> emailConfigurations) {
            this.emailConfigurations = EmailConfigurationsCopier.copyFromBuilder(emailConfigurations);
        }

        @Override
        public final Builder emailConfigurations(Collection<EmailConfiguration> emailConfigurations) {
            this.emailConfigurations = EmailConfigurationsCopier.copy(emailConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailConfigurations(EmailConfiguration... emailConfigurations) {
            emailConfigurations(Arrays.asList(emailConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailConfigurations(Consumer<EmailConfiguration.Builder>... emailConfigurations) {
            emailConfigurations(Stream.of(emailConfigurations).map(c -> EmailConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public NotificationAction build() {
            return new NotificationAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
