/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInputRequest extends IotEventsRequest implements
        ToCopyableBuilder<UpdateInputRequest.Builder, UpdateInputRequest> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputName").getter(getter(UpdateInputRequest::inputName)).setter(setter(Builder::inputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputName").build()).build();

    private static final SdkField<String> INPUT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputDescription").getter(getter(UpdateInputRequest::inputDescription))
            .setter(setter(Builder::inputDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDescription").build()).build();

    private static final SdkField<InputDefinition> INPUT_DEFINITION_FIELD = SdkField
            .<InputDefinition> builder(MarshallingType.SDK_POJO).memberName("inputDefinition")
            .getter(getter(UpdateInputRequest::inputDefinition)).setter(setter(Builder::inputDefinition))
            .constructor(InputDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD,
            INPUT_DESCRIPTION_FIELD, INPUT_DEFINITION_FIELD));

    private final String inputName;

    private final String inputDescription;

    private final InputDefinition inputDefinition;

    private UpdateInputRequest(BuilderImpl builder) {
        super(builder);
        this.inputName = builder.inputName;
        this.inputDescription = builder.inputDescription;
        this.inputDefinition = builder.inputDefinition;
    }

    /**
     * <p>
     * The name of the input you want to update.
     * </p>
     * 
     * @return The name of the input you want to update.
     */
    public final String inputName() {
        return inputName;
    }

    /**
     * <p>
     * A brief description of the input.
     * </p>
     * 
     * @return A brief description of the input.
     */
    public final String inputDescription() {
        return inputDescription;
    }

    /**
     * <p>
     * The definition of the input.
     * </p>
     * 
     * @return The definition of the input.
     */
    public final InputDefinition inputDefinition() {
        return inputDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputName());
        hashCode = 31 * hashCode + Objects.hashCode(inputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(inputDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInputRequest)) {
            return false;
        }
        UpdateInputRequest other = (UpdateInputRequest) obj;
        return Objects.equals(inputName(), other.inputName()) && Objects.equals(inputDescription(), other.inputDescription())
                && Objects.equals(inputDefinition(), other.inputDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInputRequest").add("InputName", inputName()).add("InputDescription", inputDescription())
                .add("InputDefinition", inputDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputName":
            return Optional.ofNullable(clazz.cast(inputName()));
        case "inputDescription":
            return Optional.ofNullable(clazz.cast(inputDescription()));
        case "inputDefinition":
            return Optional.ofNullable(clazz.cast(inputDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInputRequest, T> g) {
        return obj -> g.apply((UpdateInputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateInputRequest> {
        /**
         * <p>
         * The name of the input you want to update.
         * </p>
         * 
         * @param inputName
         *        The name of the input you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputName(String inputName);

        /**
         * <p>
         * A brief description of the input.
         * </p>
         * 
         * @param inputDescription
         *        A brief description of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDescription(String inputDescription);

        /**
         * <p>
         * The definition of the input.
         * </p>
         * 
         * @param inputDefinition
         *        The definition of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDefinition(InputDefinition inputDefinition);

        /**
         * <p>
         * The definition of the input.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputDefinition.Builder} avoiding the
         * need to create one manually via {@link InputDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDefinition(InputDefinition)}.
         * 
         * @param inputDefinition
         *        a consumer that will call methods on {@link InputDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDefinition(InputDefinition)
         */
        default Builder inputDefinition(Consumer<InputDefinition.Builder> inputDefinition) {
            return inputDefinition(InputDefinition.builder().applyMutation(inputDefinition).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotEventsRequest.BuilderImpl implements Builder {
        private String inputName;

        private String inputDescription;

        private InputDefinition inputDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInputRequest model) {
            super(model);
            inputName(model.inputName);
            inputDescription(model.inputDescription);
            inputDefinition(model.inputDefinition);
        }

        public final String getInputName() {
            return inputName;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        @Override
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final String getInputDescription() {
            return inputDescription;
        }

        public final void setInputDescription(String inputDescription) {
            this.inputDescription = inputDescription;
        }

        @Override
        public final Builder inputDescription(String inputDescription) {
            this.inputDescription = inputDescription;
            return this;
        }

        public final InputDefinition.Builder getInputDefinition() {
            return inputDefinition != null ? inputDefinition.toBuilder() : null;
        }

        public final void setInputDefinition(InputDefinition.BuilderImpl inputDefinition) {
            this.inputDefinition = inputDefinition != null ? inputDefinition.build() : null;
        }

        @Override
        public final Builder inputDefinition(InputDefinition inputDefinition) {
            this.inputDefinition = inputDefinition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInputRequest build() {
            return new UpdateInputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
