/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.PayloadType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Payload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Payload> {
    private static final SdkField<String> CONTENT_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentExpression").getter(Payload.getter(Payload::contentExpression)).setter(Payload.setter(Builder::contentExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentExpression").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Payload.getter(Payload::typeAsString)).setter(Payload.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_EXPRESSION_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String contentExpression;
    private final String type;

    private Payload(BuilderImpl builder) {
        this.contentExpression = builder.contentExpression;
        this.type = builder.type;
    }

    public final String contentExpression() {
        return this.contentExpression;
    }

    public final PayloadType type() {
        return PayloadType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Payload)) {
            return false;
        }
        Payload other = (Payload)obj;
        return Objects.equals(this.contentExpression(), other.contentExpression()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Payload").add("ContentExpression", (Object)this.contentExpression()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentExpression": {
                return Optional.ofNullable(clazz.cast(this.contentExpression()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Payload, T> g) {
        return obj -> g.apply((Payload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contentExpression;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Payload model) {
            this.contentExpression(model.contentExpression);
            this.type(model.type);
        }

        public final String getContentExpression() {
            return this.contentExpression;
        }

        public final void setContentExpression(String contentExpression) {
            this.contentExpression = contentExpression;
        }

        @Override
        public final Builder contentExpression(String contentExpression) {
            this.contentExpression = contentExpression;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PayloadType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public Payload build() {
            return new Payload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Payload> {
        public Builder contentExpression(String var1);

        public Builder type(String var1);

        public Builder type(PayloadType var1);
    }
}

