/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotevents.model.State;
import software.amazon.awssdk.services.iotevents.model.StatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectorModelDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectorModelDefinition> {
    private static final SdkField<List<State>> STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("states").getter(DetectorModelDefinition.getter(DetectorModelDefinition::states)).setter(DetectorModelDefinition.setter(Builder::states)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("states").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(State::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INITIAL_STATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("initialStateName").getter(DetectorModelDefinition.getter(DetectorModelDefinition::initialStateName)).setter(DetectorModelDefinition.setter(Builder::initialStateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialStateName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATES_FIELD, INITIAL_STATE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetectorModelDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<State> states;
    private final String initialStateName;

    private DetectorModelDefinition(BuilderImpl builder) {
        this.states = builder.states;
        this.initialStateName = builder.initialStateName;
    }

    public final boolean hasStates() {
        return this.states != null && !(this.states instanceof SdkAutoConstructList);
    }

    public final List<State> states() {
        return this.states;
    }

    public final String initialStateName() {
        return this.initialStateName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStates() ? this.states() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.initialStateName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorModelDefinition)) {
            return false;
        }
        DetectorModelDefinition other = (DetectorModelDefinition)obj;
        return this.hasStates() == other.hasStates() && Objects.equals(this.states(), other.states()) && Objects.equals(this.initialStateName(), other.initialStateName());
    }

    public final String toString() {
        return ToString.builder((String)"DetectorModelDefinition").add("States", this.hasStates() ? this.states() : null).add("InitialStateName", (Object)this.initialStateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "states": {
                return Optional.ofNullable(clazz.cast(this.states()));
            }
            case "initialStateName": {
                return Optional.ofNullable(clazz.cast(this.initialStateName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("states", STATES_FIELD);
        map.put("initialStateName", INITIAL_STATE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectorModelDefinition, T> g) {
        return obj -> g.apply((DetectorModelDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<State> states = DefaultSdkAutoConstructList.getInstance();
        private String initialStateName;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorModelDefinition model) {
            this.states(model.states);
            this.initialStateName(model.initialStateName);
        }

        public final List<State.Builder> getStates() {
            List<State.Builder> result = StatesCopier.copyToBuilder(this.states);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStates(Collection<State.BuilderImpl> states) {
            this.states = StatesCopier.copyFromBuilder(states);
        }

        @Override
        public final Builder states(Collection<State> states) {
            this.states = StatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(State ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(Consumer<State.Builder> ... states) {
            this.states(Stream.of(states).map(c -> (State)((State.Builder)State.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInitialStateName() {
            return this.initialStateName;
        }

        public final void setInitialStateName(String initialStateName) {
            this.initialStateName = initialStateName;
        }

        @Override
        public final Builder initialStateName(String initialStateName) {
            this.initialStateName = initialStateName;
            return this;
        }

        public DetectorModelDefinition build() {
            return new DetectorModelDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectorModelDefinition> {
        public Builder states(Collection<State> var1);

        public Builder states(State ... var1);

        public Builder states(Consumer<State.Builder> ... var1);

        public Builder initialStateName(String var1);
    }
}

