/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the action that you can take to respond to the alarm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerAction implements SdkPojo, Serializable, ToCopyableBuilder<CustomerAction.Builder, CustomerAction> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionName").getter(getter(CustomerAction::actionNameAsString)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<SnoozeActionConfiguration> SNOOZE_ACTION_CONFIGURATION_FIELD = SdkField
            .<SnoozeActionConfiguration> builder(MarshallingType.SDK_POJO).memberName("snoozeActionConfiguration")
            .getter(getter(CustomerAction::snoozeActionConfiguration)).setter(setter(Builder::snoozeActionConfiguration))
            .constructor(SnoozeActionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snoozeActionConfiguration").build())
            .build();

    private static final SdkField<EnableActionConfiguration> ENABLE_ACTION_CONFIGURATION_FIELD = SdkField
            .<EnableActionConfiguration> builder(MarshallingType.SDK_POJO).memberName("enableActionConfiguration")
            .getter(getter(CustomerAction::enableActionConfiguration)).setter(setter(Builder::enableActionConfiguration))
            .constructor(EnableActionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableActionConfiguration").build())
            .build();

    private static final SdkField<DisableActionConfiguration> DISABLE_ACTION_CONFIGURATION_FIELD = SdkField
            .<DisableActionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("disableActionConfiguration")
            .getter(getter(CustomerAction::disableActionConfiguration))
            .setter(setter(Builder::disableActionConfiguration))
            .constructor(DisableActionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableActionConfiguration").build())
            .build();

    private static final SdkField<AcknowledgeActionConfiguration> ACKNOWLEDGE_ACTION_CONFIGURATION_FIELD = SdkField
            .<AcknowledgeActionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("acknowledgeActionConfiguration")
            .getter(getter(CustomerAction::acknowledgeActionConfiguration))
            .setter(setter(Builder::acknowledgeActionConfiguration))
            .constructor(AcknowledgeActionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acknowledgeActionConfiguration")
                    .build()).build();

    private static final SdkField<ResetActionConfiguration> RESET_ACTION_CONFIGURATION_FIELD = SdkField
            .<ResetActionConfiguration> builder(MarshallingType.SDK_POJO).memberName("resetActionConfiguration")
            .getter(getter(CustomerAction::resetActionConfiguration)).setter(setter(Builder::resetActionConfiguration))
            .constructor(ResetActionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resetActionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD,
            SNOOZE_ACTION_CONFIGURATION_FIELD, ENABLE_ACTION_CONFIGURATION_FIELD, DISABLE_ACTION_CONFIGURATION_FIELD,
            ACKNOWLEDGE_ACTION_CONFIGURATION_FIELD, RESET_ACTION_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionName;

    private final SnoozeActionConfiguration snoozeActionConfiguration;

    private final EnableActionConfiguration enableActionConfiguration;

    private final DisableActionConfiguration disableActionConfiguration;

    private final AcknowledgeActionConfiguration acknowledgeActionConfiguration;

    private final ResetActionConfiguration resetActionConfiguration;

    private CustomerAction(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.snoozeActionConfiguration = builder.snoozeActionConfiguration;
        this.enableActionConfiguration = builder.enableActionConfiguration;
        this.disableActionConfiguration = builder.disableActionConfiguration;
        this.acknowledgeActionConfiguration = builder.acknowledgeActionConfiguration;
        this.resetActionConfiguration = builder.resetActionConfiguration;
    }

    /**
     * <p>
     * The name of the action. The action name can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SNOOZE</code> - When you snooze the alarm, the alarm state changes to <code>SNOOZE_DISABLED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLE</code> - When you enable the alarm, the alarm state changes to <code>NORMAL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLE</code> - When you disable the alarm, the alarm state changes to <code>DISABLED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACKNOWLEDGE</code> - When you acknowledge the alarm, the alarm state changes to <code>ACKNOWLEDGED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESET</code> - When you reset the alarm, the alarm state changes to <code>NORMAL</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see the <a
     * href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html"
     * >AlarmState</a> API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionName} will
     * return {@link CustomerActionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionNameAsString}.
     * </p>
     * 
     * @return The name of the action. The action name can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SNOOZE</code> - When you snooze the alarm, the alarm state changes to <code>SNOOZE_DISABLED</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLE</code> - When you enable the alarm, the alarm state changes to <code>NORMAL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLE</code> - When you disable the alarm, the alarm state changes to <code>DISABLED</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACKNOWLEDGE</code> - When you acknowledge the alarm, the alarm state changes to
     *         <code>ACKNOWLEDGED</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESET</code> - When you reset the alarm, the alarm state changes to <code>NORMAL</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see the <a
     *         href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html"
     *         >AlarmState</a> API.
     * @see CustomerActionName
     */
    public final CustomerActionName actionName() {
        return CustomerActionName.fromValue(actionName);
    }

    /**
     * <p>
     * The name of the action. The action name can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SNOOZE</code> - When you snooze the alarm, the alarm state changes to <code>SNOOZE_DISABLED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLE</code> - When you enable the alarm, the alarm state changes to <code>NORMAL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLE</code> - When you disable the alarm, the alarm state changes to <code>DISABLED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACKNOWLEDGE</code> - When you acknowledge the alarm, the alarm state changes to <code>ACKNOWLEDGED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESET</code> - When you reset the alarm, the alarm state changes to <code>NORMAL</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see the <a
     * href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html"
     * >AlarmState</a> API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionName} will
     * return {@link CustomerActionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionNameAsString}.
     * </p>
     * 
     * @return The name of the action. The action name can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SNOOZE</code> - When you snooze the alarm, the alarm state changes to <code>SNOOZE_DISABLED</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLE</code> - When you enable the alarm, the alarm state changes to <code>NORMAL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLE</code> - When you disable the alarm, the alarm state changes to <code>DISABLED</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACKNOWLEDGE</code> - When you acknowledge the alarm, the alarm state changes to
     *         <code>ACKNOWLEDGED</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESET</code> - When you reset the alarm, the alarm state changes to <code>NORMAL</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see the <a
     *         href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html"
     *         >AlarmState</a> API.
     * @see CustomerActionName
     */
    public final String actionNameAsString() {
        return actionName;
    }

    /**
     * <p>
     * Contains the configuration information of a snooze action.
     * </p>
     * 
     * @return Contains the configuration information of a snooze action.
     */
    public final SnoozeActionConfiguration snoozeActionConfiguration() {
        return snoozeActionConfiguration;
    }

    /**
     * <p>
     * Contains the configuration information of an enable action.
     * </p>
     * 
     * @return Contains the configuration information of an enable action.
     */
    public final EnableActionConfiguration enableActionConfiguration() {
        return enableActionConfiguration;
    }

    /**
     * <p>
     * Contains the configuration information of a disable action.
     * </p>
     * 
     * @return Contains the configuration information of a disable action.
     */
    public final DisableActionConfiguration disableActionConfiguration() {
        return disableActionConfiguration;
    }

    /**
     * <p>
     * Contains the configuration information of an acknowledge action.
     * </p>
     * 
     * @return Contains the configuration information of an acknowledge action.
     */
    public final AcknowledgeActionConfiguration acknowledgeActionConfiguration() {
        return acknowledgeActionConfiguration;
    }

    /**
     * <p>
     * Contains the configuration information of a reset action.
     * </p>
     * 
     * @return Contains the configuration information of a reset action.
     */
    public final ResetActionConfiguration resetActionConfiguration() {
        return resetActionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(snoozeActionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(enableActionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(disableActionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(acknowledgeActionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(resetActionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerAction)) {
            return false;
        }
        CustomerAction other = (CustomerAction) obj;
        return Objects.equals(actionNameAsString(), other.actionNameAsString())
                && Objects.equals(snoozeActionConfiguration(), other.snoozeActionConfiguration())
                && Objects.equals(enableActionConfiguration(), other.enableActionConfiguration())
                && Objects.equals(disableActionConfiguration(), other.disableActionConfiguration())
                && Objects.equals(acknowledgeActionConfiguration(), other.acknowledgeActionConfiguration())
                && Objects.equals(resetActionConfiguration(), other.resetActionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerAction").add("ActionName", actionNameAsString())
                .add("SnoozeActionConfiguration", snoozeActionConfiguration())
                .add("EnableActionConfiguration", enableActionConfiguration())
                .add("DisableActionConfiguration", disableActionConfiguration())
                .add("AcknowledgeActionConfiguration", acknowledgeActionConfiguration())
                .add("ResetActionConfiguration", resetActionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionNameAsString()));
        case "snoozeActionConfiguration":
            return Optional.ofNullable(clazz.cast(snoozeActionConfiguration()));
        case "enableActionConfiguration":
            return Optional.ofNullable(clazz.cast(enableActionConfiguration()));
        case "disableActionConfiguration":
            return Optional.ofNullable(clazz.cast(disableActionConfiguration()));
        case "acknowledgeActionConfiguration":
            return Optional.ofNullable(clazz.cast(acknowledgeActionConfiguration()));
        case "resetActionConfiguration":
            return Optional.ofNullable(clazz.cast(resetActionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerAction, T> g) {
        return obj -> g.apply((CustomerAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerAction> {
        /**
         * <p>
         * The name of the action. The action name can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SNOOZE</code> - When you snooze the alarm, the alarm state changes to <code>SNOOZE_DISABLED</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLE</code> - When you enable the alarm, the alarm state changes to <code>NORMAL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLE</code> - When you disable the alarm, the alarm state changes to <code>DISABLED</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACKNOWLEDGE</code> - When you acknowledge the alarm, the alarm state changes to
         * <code>ACKNOWLEDGED</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESET</code> - When you reset the alarm, the alarm state changes to <code>NORMAL</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see the <a
         * href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html"
         * >AlarmState</a> API.
         * </p>
         * 
         * @param actionName
         *        The name of the action. The action name can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SNOOZE</code> - When you snooze the alarm, the alarm state changes to
         *        <code>SNOOZE_DISABLED</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLE</code> - When you enable the alarm, the alarm state changes to <code>NORMAL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLE</code> - When you disable the alarm, the alarm state changes to <code>DISABLED</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACKNOWLEDGE</code> - When you acknowledge the alarm, the alarm state changes to
         *        <code>ACKNOWLEDGED</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESET</code> - When you reset the alarm, the alarm state changes to <code>NORMAL</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see the <a
         *        href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html"
         *        >AlarmState</a> API.
         * @see CustomerActionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomerActionName
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * The name of the action. The action name can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SNOOZE</code> - When you snooze the alarm, the alarm state changes to <code>SNOOZE_DISABLED</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLE</code> - When you enable the alarm, the alarm state changes to <code>NORMAL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLE</code> - When you disable the alarm, the alarm state changes to <code>DISABLED</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACKNOWLEDGE</code> - When you acknowledge the alarm, the alarm state changes to
         * <code>ACKNOWLEDGED</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESET</code> - When you reset the alarm, the alarm state changes to <code>NORMAL</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see the <a
         * href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html"
         * >AlarmState</a> API.
         * </p>
         * 
         * @param actionName
         *        The name of the action. The action name can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SNOOZE</code> - When you snooze the alarm, the alarm state changes to
         *        <code>SNOOZE_DISABLED</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLE</code> - When you enable the alarm, the alarm state changes to <code>NORMAL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLE</code> - When you disable the alarm, the alarm state changes to <code>DISABLED</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACKNOWLEDGE</code> - When you acknowledge the alarm, the alarm state changes to
         *        <code>ACKNOWLEDGED</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESET</code> - When you reset the alarm, the alarm state changes to <code>NORMAL</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see the <a
         *        href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html"
         *        >AlarmState</a> API.
         * @see CustomerActionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomerActionName
         */
        Builder actionName(CustomerActionName actionName);

        /**
         * <p>
         * Contains the configuration information of a snooze action.
         * </p>
         * 
         * @param snoozeActionConfiguration
         *        Contains the configuration information of a snooze action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snoozeActionConfiguration(SnoozeActionConfiguration snoozeActionConfiguration);

        /**
         * <p>
         * Contains the configuration information of a snooze action.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnoozeActionConfiguration.Builder}
         * avoiding the need to create one manually via {@link SnoozeActionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnoozeActionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #snoozeActionConfiguration(SnoozeActionConfiguration)}.
         * 
         * @param snoozeActionConfiguration
         *        a consumer that will call methods on {@link SnoozeActionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snoozeActionConfiguration(SnoozeActionConfiguration)
         */
        default Builder snoozeActionConfiguration(Consumer<SnoozeActionConfiguration.Builder> snoozeActionConfiguration) {
            return snoozeActionConfiguration(SnoozeActionConfiguration.builder().applyMutation(snoozeActionConfiguration).build());
        }

        /**
         * <p>
         * Contains the configuration information of an enable action.
         * </p>
         * 
         * @param enableActionConfiguration
         *        Contains the configuration information of an enable action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableActionConfiguration(EnableActionConfiguration enableActionConfiguration);

        /**
         * <p>
         * Contains the configuration information of an enable action.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnableActionConfiguration.Builder}
         * avoiding the need to create one manually via {@link EnableActionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnableActionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #enableActionConfiguration(EnableActionConfiguration)}.
         * 
         * @param enableActionConfiguration
         *        a consumer that will call methods on {@link EnableActionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enableActionConfiguration(EnableActionConfiguration)
         */
        default Builder enableActionConfiguration(Consumer<EnableActionConfiguration.Builder> enableActionConfiguration) {
            return enableActionConfiguration(EnableActionConfiguration.builder().applyMutation(enableActionConfiguration).build());
        }

        /**
         * <p>
         * Contains the configuration information of a disable action.
         * </p>
         * 
         * @param disableActionConfiguration
         *        Contains the configuration information of a disable action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableActionConfiguration(DisableActionConfiguration disableActionConfiguration);

        /**
         * <p>
         * Contains the configuration information of a disable action.
         * </p>
         * This is a convenience method that creates an instance of the {@link DisableActionConfiguration.Builder}
         * avoiding the need to create one manually via {@link DisableActionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DisableActionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #disableActionConfiguration(DisableActionConfiguration)}.
         * 
         * @param disableActionConfiguration
         *        a consumer that will call methods on {@link DisableActionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disableActionConfiguration(DisableActionConfiguration)
         */
        default Builder disableActionConfiguration(Consumer<DisableActionConfiguration.Builder> disableActionConfiguration) {
            return disableActionConfiguration(DisableActionConfiguration.builder().applyMutation(disableActionConfiguration)
                    .build());
        }

        /**
         * <p>
         * Contains the configuration information of an acknowledge action.
         * </p>
         * 
         * @param acknowledgeActionConfiguration
         *        Contains the configuration information of an acknowledge action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acknowledgeActionConfiguration(AcknowledgeActionConfiguration acknowledgeActionConfiguration);

        /**
         * <p>
         * Contains the configuration information of an acknowledge action.
         * </p>
         * This is a convenience method that creates an instance of the {@link AcknowledgeActionConfiguration.Builder}
         * avoiding the need to create one manually via {@link AcknowledgeActionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AcknowledgeActionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #acknowledgeActionConfiguration(AcknowledgeActionConfiguration)}.
         * 
         * @param acknowledgeActionConfiguration
         *        a consumer that will call methods on {@link AcknowledgeActionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acknowledgeActionConfiguration(AcknowledgeActionConfiguration)
         */
        default Builder acknowledgeActionConfiguration(
                Consumer<AcknowledgeActionConfiguration.Builder> acknowledgeActionConfiguration) {
            return acknowledgeActionConfiguration(AcknowledgeActionConfiguration.builder()
                    .applyMutation(acknowledgeActionConfiguration).build());
        }

        /**
         * <p>
         * Contains the configuration information of a reset action.
         * </p>
         * 
         * @param resetActionConfiguration
         *        Contains the configuration information of a reset action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resetActionConfiguration(ResetActionConfiguration resetActionConfiguration);

        /**
         * <p>
         * Contains the configuration information of a reset action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResetActionConfiguration.Builder}
         * avoiding the need to create one manually via {@link ResetActionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResetActionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #resetActionConfiguration(ResetActionConfiguration)}.
         * 
         * @param resetActionConfiguration
         *        a consumer that will call methods on {@link ResetActionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resetActionConfiguration(ResetActionConfiguration)
         */
        default Builder resetActionConfiguration(Consumer<ResetActionConfiguration.Builder> resetActionConfiguration) {
            return resetActionConfiguration(ResetActionConfiguration.builder().applyMutation(resetActionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String actionName;

        private SnoozeActionConfiguration snoozeActionConfiguration;

        private EnableActionConfiguration enableActionConfiguration;

        private DisableActionConfiguration disableActionConfiguration;

        private AcknowledgeActionConfiguration acknowledgeActionConfiguration;

        private ResetActionConfiguration resetActionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerAction model) {
            actionName(model.actionName);
            snoozeActionConfiguration(model.snoozeActionConfiguration);
            enableActionConfiguration(model.enableActionConfiguration);
            disableActionConfiguration(model.disableActionConfiguration);
            acknowledgeActionConfiguration(model.acknowledgeActionConfiguration);
            resetActionConfiguration(model.resetActionConfiguration);
        }

        public final String getActionName() {
            return actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        @Override
        public final Builder actionName(CustomerActionName actionName) {
            this.actionName(actionName == null ? null : actionName.toString());
            return this;
        }

        public final SnoozeActionConfiguration.Builder getSnoozeActionConfiguration() {
            return snoozeActionConfiguration != null ? snoozeActionConfiguration.toBuilder() : null;
        }

        public final void setSnoozeActionConfiguration(SnoozeActionConfiguration.BuilderImpl snoozeActionConfiguration) {
            this.snoozeActionConfiguration = snoozeActionConfiguration != null ? snoozeActionConfiguration.build() : null;
        }

        @Override
        public final Builder snoozeActionConfiguration(SnoozeActionConfiguration snoozeActionConfiguration) {
            this.snoozeActionConfiguration = snoozeActionConfiguration;
            return this;
        }

        public final EnableActionConfiguration.Builder getEnableActionConfiguration() {
            return enableActionConfiguration != null ? enableActionConfiguration.toBuilder() : null;
        }

        public final void setEnableActionConfiguration(EnableActionConfiguration.BuilderImpl enableActionConfiguration) {
            this.enableActionConfiguration = enableActionConfiguration != null ? enableActionConfiguration.build() : null;
        }

        @Override
        public final Builder enableActionConfiguration(EnableActionConfiguration enableActionConfiguration) {
            this.enableActionConfiguration = enableActionConfiguration;
            return this;
        }

        public final DisableActionConfiguration.Builder getDisableActionConfiguration() {
            return disableActionConfiguration != null ? disableActionConfiguration.toBuilder() : null;
        }

        public final void setDisableActionConfiguration(DisableActionConfiguration.BuilderImpl disableActionConfiguration) {
            this.disableActionConfiguration = disableActionConfiguration != null ? disableActionConfiguration.build() : null;
        }

        @Override
        public final Builder disableActionConfiguration(DisableActionConfiguration disableActionConfiguration) {
            this.disableActionConfiguration = disableActionConfiguration;
            return this;
        }

        public final AcknowledgeActionConfiguration.Builder getAcknowledgeActionConfiguration() {
            return acknowledgeActionConfiguration != null ? acknowledgeActionConfiguration.toBuilder() : null;
        }

        public final void setAcknowledgeActionConfiguration(
                AcknowledgeActionConfiguration.BuilderImpl acknowledgeActionConfiguration) {
            this.acknowledgeActionConfiguration = acknowledgeActionConfiguration != null ? acknowledgeActionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder acknowledgeActionConfiguration(AcknowledgeActionConfiguration acknowledgeActionConfiguration) {
            this.acknowledgeActionConfiguration = acknowledgeActionConfiguration;
            return this;
        }

        public final ResetActionConfiguration.Builder getResetActionConfiguration() {
            return resetActionConfiguration != null ? resetActionConfiguration.toBuilder() : null;
        }

        public final void setResetActionConfiguration(ResetActionConfiguration.BuilderImpl resetActionConfiguration) {
            this.resetActionConfiguration = resetActionConfiguration != null ? resetActionConfiguration.build() : null;
        }

        @Override
        public final Builder resetActionConfiguration(ResetActionConfiguration resetActionConfiguration) {
            this.resetActionConfiguration = resetActionConfiguration;
            return this;
        }

        @Override
        public CustomerAction build() {
            return new CustomerAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
