/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the detector (instance).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Detector implements SdkPojo, Serializable, ToCopyableBuilder<Detector.Builder, Detector> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorModelName").getter(getter(Detector::detectorModelName))
            .setter(setter(Builder::detectorModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelName").build()).build();

    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyValue").getter(getter(Detector::keyValue)).setter(setter(Builder::keyValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValue").build()).build();

    private static final SdkField<String> DETECTOR_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorModelVersion").getter(getter(Detector::detectorModelVersion))
            .setter(setter(Builder::detectorModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelVersion").build())
            .build();

    private static final SdkField<DetectorState> STATE_FIELD = SdkField.<DetectorState> builder(MarshallingType.SDK_POJO)
            .memberName("state").getter(getter(Detector::state)).setter(setter(Builder::state))
            .constructor(DetectorState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(Detector::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(Detector::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD,
            KEY_VALUE_FIELD, DETECTOR_MODEL_VERSION_FIELD, STATE_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String detectorModelName;

    private final String keyValue;

    private final String detectorModelVersion;

    private final DetectorState state;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private Detector(BuilderImpl builder) {
        this.detectorModelName = builder.detectorModelName;
        this.keyValue = builder.keyValue;
        this.detectorModelVersion = builder.detectorModelVersion;
        this.state = builder.state;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The name of the detector model that created this detector (instance).
     * </p>
     * 
     * @return The name of the detector model that created this detector (instance).
     */
    public final String detectorModelName() {
        return detectorModelName;
    }

    /**
     * <p>
     * The value of the key (identifying the device or system) that caused the creation of this detector (instance).
     * </p>
     * 
     * @return The value of the key (identifying the device or system) that caused the creation of this detector
     *         (instance).
     */
    public final String keyValue() {
        return keyValue;
    }

    /**
     * <p>
     * The version of the detector model that created this detector (instance).
     * </p>
     * 
     * @return The version of the detector model that created this detector (instance).
     */
    public final String detectorModelVersion() {
        return detectorModelVersion;
    }

    /**
     * <p>
     * The current state of the detector (instance).
     * </p>
     * 
     * @return The current state of the detector (instance).
     */
    public final DetectorState state() {
        return state;
    }

    /**
     * <p>
     * The time the detector (instance) was created.
     * </p>
     * 
     * @return The time the detector (instance) was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the detector (instance) was last updated.
     * </p>
     * 
     * @return The time the detector (instance) was last updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(keyValue());
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Detector)) {
            return false;
        }
        Detector other = (Detector) obj;
        return Objects.equals(detectorModelName(), other.detectorModelName()) && Objects.equals(keyValue(), other.keyValue())
                && Objects.equals(detectorModelVersion(), other.detectorModelVersion()) && Objects.equals(state(), other.state())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Detector").add("DetectorModelName", detectorModelName()).add("KeyValue", keyValue())
                .add("DetectorModelVersion", detectorModelVersion()).add("State", state()).add("CreationTime", creationTime())
                .add("LastUpdateTime", lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorModelName":
            return Optional.ofNullable(clazz.cast(detectorModelName()));
        case "keyValue":
            return Optional.ofNullable(clazz.cast(keyValue()));
        case "detectorModelVersion":
            return Optional.ofNullable(clazz.cast(detectorModelVersion()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Detector, T> g) {
        return obj -> g.apply((Detector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Detector> {
        /**
         * <p>
         * The name of the detector model that created this detector (instance).
         * </p>
         * 
         * @param detectorModelName
         *        The name of the detector model that created this detector (instance).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelName(String detectorModelName);

        /**
         * <p>
         * The value of the key (identifying the device or system) that caused the creation of this detector (instance).
         * </p>
         * 
         * @param keyValue
         *        The value of the key (identifying the device or system) that caused the creation of this detector
         *        (instance).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyValue(String keyValue);

        /**
         * <p>
         * The version of the detector model that created this detector (instance).
         * </p>
         * 
         * @param detectorModelVersion
         *        The version of the detector model that created this detector (instance).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelVersion(String detectorModelVersion);

        /**
         * <p>
         * The current state of the detector (instance).
         * </p>
         * 
         * @param state
         *        The current state of the detector (instance).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(DetectorState state);

        /**
         * <p>
         * The current state of the detector (instance).
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectorState.Builder} avoiding the need
         * to create one manually via {@link DetectorState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectorState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(DetectorState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link DetectorState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(DetectorState)
         */
        default Builder state(Consumer<DetectorState.Builder> state) {
            return state(DetectorState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The time the detector (instance) was created.
         * </p>
         * 
         * @param creationTime
         *        The time the detector (instance) was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the detector (instance) was last updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The time the detector (instance) was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String detectorModelName;

        private String keyValue;

        private String detectorModelVersion;

        private DetectorState state;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Detector model) {
            detectorModelName(model.detectorModelName);
            keyValue(model.keyValue);
            detectorModelVersion(model.detectorModelVersion);
            state(model.state);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getDetectorModelName() {
            return detectorModelName;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final String getKeyValue() {
            return keyValue;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public final String getDetectorModelVersion() {
            return detectorModelVersion;
        }

        public final void setDetectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
        }

        @Override
        public final Builder detectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
            return this;
        }

        public final DetectorState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(DetectorState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(DetectorState state) {
            this.state = state;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Override
        public Detector build() {
            return new Detector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
