/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ioteventsdata.model.Timer;
import software.amazon.awssdk.services.ioteventsdata.model.TimersCopier;
import software.amazon.awssdk.services.ioteventsdata.model.Variable;
import software.amazon.awssdk.services.ioteventsdata.model.VariablesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectorState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectorState> {
    private static final SdkField<String> STATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateName").getter(DetectorState.getter(DetectorState::stateName)).setter(DetectorState.setter(Builder::stateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateName").build()}).build();
    private static final SdkField<List<Variable>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variables").getter(DetectorState.getter(DetectorState::variables)).setter(DetectorState.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Variable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Timer>> TIMERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("timers").getter(DetectorState.getter(DetectorState::timers)).setter(DetectorState.setter(Builder::timers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Timer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_NAME_FIELD, VARIABLES_FIELD, TIMERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetectorState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stateName;
    private final List<Variable> variables;
    private final List<Timer> timers;

    private DetectorState(BuilderImpl builder) {
        this.stateName = builder.stateName;
        this.variables = builder.variables;
        this.timers = builder.timers;
    }

    public final String stateName() {
        return this.stateName;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructList);
    }

    public final List<Variable> variables() {
        return this.variables;
    }

    public final boolean hasTimers() {
        return this.timers != null && !(this.timers instanceof SdkAutoConstructList);
    }

    public final List<Timer> timers() {
        return this.timers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimers() ? this.timers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorState)) {
            return false;
        }
        DetectorState other = (DetectorState)obj;
        return Objects.equals(this.stateName(), other.stateName()) && this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables()) && this.hasTimers() == other.hasTimers() && Objects.equals(this.timers(), other.timers());
    }

    public final String toString() {
        return ToString.builder((String)"DetectorState").add("StateName", (Object)this.stateName()).add("Variables", this.hasVariables() ? this.variables() : null).add("Timers", this.hasTimers() ? this.timers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateName": {
                return Optional.ofNullable(clazz.cast(this.stateName()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "timers": {
                return Optional.ofNullable(clazz.cast(this.timers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stateName", STATE_NAME_FIELD);
        map.put("variables", VARIABLES_FIELD);
        map.put("timers", TIMERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectorState, T> g) {
        return obj -> g.apply((DetectorState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stateName;
        private List<Variable> variables = DefaultSdkAutoConstructList.getInstance();
        private List<Timer> timers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorState model) {
            this.stateName(model.stateName);
            this.variables(model.variables);
            this.timers(model.timers);
        }

        public final String getStateName() {
            return this.stateName;
        }

        public final void setStateName(String stateName) {
            this.stateName = stateName;
        }

        @Override
        public final Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        public final List<Variable.Builder> getVariables() {
            List<Variable.Builder> result = VariablesCopier.copyToBuilder(this.variables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariables(Collection<Variable.BuilderImpl> variables) {
            this.variables = VariablesCopier.copyFromBuilder(variables);
        }

        @Override
        public final Builder variables(Collection<Variable> variables) {
            this.variables = VariablesCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Variable ... variables) {
            this.variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<Variable.Builder> ... variables) {
            this.variables(Stream.of(variables).map(c -> (Variable)((Variable.Builder)Variable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Timer.Builder> getTimers() {
            List<Timer.Builder> result = TimersCopier.copyToBuilder(this.timers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimers(Collection<Timer.BuilderImpl> timers) {
            this.timers = TimersCopier.copyFromBuilder(timers);
        }

        @Override
        public final Builder timers(Collection<Timer> timers) {
            this.timers = TimersCopier.copy(timers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timers(Timer ... timers) {
            this.timers(Arrays.asList(timers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timers(Consumer<Timer.Builder> ... timers) {
            this.timers(Stream.of(timers).map(c -> (Timer)((Timer.Builder)Timer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DetectorState build() {
            return new DetectorState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectorState> {
        public Builder stateName(String var1);

        public Builder variables(Collection<Variable> var1);

        public Builder variables(Variable ... var1);

        public Builder variables(Consumer<Variable.Builder> ... var1);

        public Builder timers(Collection<Timer> var1);

        public Builder timers(Timer ... var1);

        public Builder timers(Consumer<Timer.Builder> ... var1);
    }
}

