/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCampaignRequest extends IoTFleetWiseRequest implements
        ToCopyableBuilder<CreateCampaignRequest.Builder, CreateCampaignRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateCampaignRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateCampaignRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> SIGNAL_CATALOG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signalCatalogArn").getter(getter(CreateCampaignRequest::signalCatalogArn))
            .setter(setter(Builder::signalCatalogArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalCatalogArn").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetArn").getter(getter(CreateCampaignRequest::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(CreateCampaignRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> EXPIRY_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiryTime").getter(getter(CreateCampaignRequest::expiryTime)).setter(setter(Builder::expiryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiryTime").build()).build();

    private static final SdkField<Long> POST_TRIGGER_COLLECTION_DURATION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("postTriggerCollectionDuration")
            .getter(getter(CreateCampaignRequest::postTriggerCollectionDuration))
            .setter(setter(Builder::postTriggerCollectionDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postTriggerCollectionDuration")
                    .build()).build();

    private static final SdkField<String> DIAGNOSTICS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("diagnosticsMode").getter(getter(CreateCampaignRequest::diagnosticsModeAsString))
            .setter(setter(Builder::diagnosticsMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diagnosticsMode").build()).build();

    private static final SdkField<String> SPOOLING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spoolingMode").getter(getter(CreateCampaignRequest::spoolingModeAsString))
            .setter(setter(Builder::spoolingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spoolingMode").build()).build();

    private static final SdkField<String> COMPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("compression").getter(getter(CreateCampaignRequest::compressionAsString))
            .setter(setter(Builder::compression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compression").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(CreateCampaignRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<List<SignalInformation>> SIGNALS_TO_COLLECT_FIELD = SdkField
            .<List<SignalInformation>> builder(MarshallingType.LIST)
            .memberName("signalsToCollect")
            .getter(getter(CreateCampaignRequest::signalsToCollect))
            .setter(setter(Builder::signalsToCollect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalsToCollect").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SignalInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(SignalInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CollectionScheme> COLLECTION_SCHEME_FIELD = SdkField
            .<CollectionScheme> builder(MarshallingType.SDK_POJO).memberName("collectionScheme")
            .getter(getter(CreateCampaignRequest::collectionScheme)).setter(setter(Builder::collectionScheme))
            .constructor(CollectionScheme::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionScheme").build()).build();

    private static final SdkField<List<String>> DATA_EXTRA_DIMENSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dataExtraDimensions")
            .getter(getter(CreateCampaignRequest::dataExtraDimensions))
            .setter(setter(Builder::dataExtraDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataExtraDimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateCampaignRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataDestinationConfig>> DATA_DESTINATION_CONFIGS_FIELD = SdkField
            .<List<DataDestinationConfig>> builder(MarshallingType.LIST)
            .memberName("dataDestinationConfigs")
            .getter(getter(CreateCampaignRequest::dataDestinationConfigs))
            .setter(setter(Builder::dataDestinationConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDestinationConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataDestinationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataDestinationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            SIGNAL_CATALOG_ARN_FIELD, TARGET_ARN_FIELD, START_TIME_FIELD, EXPIRY_TIME_FIELD,
            POST_TRIGGER_COLLECTION_DURATION_FIELD, DIAGNOSTICS_MODE_FIELD, SPOOLING_MODE_FIELD, COMPRESSION_FIELD,
            PRIORITY_FIELD, SIGNALS_TO_COLLECT_FIELD, COLLECTION_SCHEME_FIELD, DATA_EXTRA_DIMENSIONS_FIELD, TAGS_FIELD,
            DATA_DESTINATION_CONFIGS_FIELD));

    private final String name;

    private final String description;

    private final String signalCatalogArn;

    private final String targetArn;

    private final Instant startTime;

    private final Instant expiryTime;

    private final Long postTriggerCollectionDuration;

    private final String diagnosticsMode;

    private final String spoolingMode;

    private final String compression;

    private final Integer priority;

    private final List<SignalInformation> signalsToCollect;

    private final CollectionScheme collectionScheme;

    private final List<String> dataExtraDimensions;

    private final List<Tag> tags;

    private final List<DataDestinationConfig> dataDestinationConfigs;

    private CreateCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.signalCatalogArn = builder.signalCatalogArn;
        this.targetArn = builder.targetArn;
        this.startTime = builder.startTime;
        this.expiryTime = builder.expiryTime;
        this.postTriggerCollectionDuration = builder.postTriggerCollectionDuration;
        this.diagnosticsMode = builder.diagnosticsMode;
        this.spoolingMode = builder.spoolingMode;
        this.compression = builder.compression;
        this.priority = builder.priority;
        this.signalsToCollect = builder.signalsToCollect;
        this.collectionScheme = builder.collectionScheme;
        this.dataExtraDimensions = builder.dataExtraDimensions;
        this.tags = builder.tags;
        this.dataDestinationConfigs = builder.dataDestinationConfigs;
    }

    /**
     * <p>
     * The name of the campaign to create.
     * </p>
     * 
     * @return The name of the campaign to create.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An optional description of the campaign to help identify its purpose.
     * </p>
     * 
     * @return An optional description of the campaign to help identify its purpose.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * (Optional) The Amazon Resource Name (ARN) of the signal catalog to associate with the campaign.
     * </p>
     * 
     * @return (Optional) The Amazon Resource Name (ARN) of the signal catalog to associate with the campaign.
     */
    public final String signalCatalogArn() {
        return signalCatalogArn;
    }

    /**
     * <p>
     * The ARN of the vehicle or fleet to deploy a campaign to.
     * </p>
     * 
     * @return The ARN of the vehicle or fleet to deploy a campaign to.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * (Optional) The time, in milliseconds, to deliver a campaign after it was approved. If it's not specified,
     * <code>0</code> is used.
     * </p>
     * <p>
     * Default: <code>0</code>
     * </p>
     * 
     * @return (Optional) The time, in milliseconds, to deliver a campaign after it was approved. If it's not specified,
     *         <code>0</code> is used.</p>
     *         <p>
     *         Default: <code>0</code>
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * (Optional) The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC time). Vehicle
     * data isn't collected after the campaign expires.
     * </p>
     * <p>
     * Default: 253402214400 (December 31, 9999, 00:00:00 UTC)
     * </p>
     * 
     * @return (Optional) The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC time).
     *         Vehicle data isn't collected after the campaign expires. </p>
     *         <p>
     *         Default: 253402214400 (December 31, 9999, 00:00:00 UTC)
     */
    public final Instant expiryTime() {
        return expiryTime;
    }

    /**
     * <p>
     * (Optional) How long (in milliseconds) to collect raw data after a triggering event initiates the collection. If
     * it's not specified, <code>0</code> is used.
     * </p>
     * <p>
     * Default: <code>0</code>
     * </p>
     * 
     * @return (Optional) How long (in milliseconds) to collect raw data after a triggering event initiates the
     *         collection. If it's not specified, <code>0</code> is used.</p>
     *         <p>
     *         Default: <code>0</code>
     */
    public final Long postTriggerCollectionDuration() {
        return postTriggerCollectionDuration;
    }

    /**
     * <p>
     * (Optional) Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise. If you
     * want to send diagnostic trouble codes, use <code>SEND_ACTIVE_DTCS</code>. If it's not specified, <code>OFF</code>
     * is used.
     * </p>
     * <p>
     * Default: <code>OFF</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diagnosticsMode}
     * will return {@link DiagnosticsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diagnosticsModeAsString}.
     * </p>
     * 
     * @return (Optional) Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise. If
     *         you want to send diagnostic trouble codes, use <code>SEND_ACTIVE_DTCS</code>. If it's not specified,
     *         <code>OFF</code> is used.</p>
     *         <p>
     *         Default: <code>OFF</code>
     * @see DiagnosticsMode
     */
    public final DiagnosticsMode diagnosticsMode() {
        return DiagnosticsMode.fromValue(diagnosticsMode);
    }

    /**
     * <p>
     * (Optional) Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise. If you
     * want to send diagnostic trouble codes, use <code>SEND_ACTIVE_DTCS</code>. If it's not specified, <code>OFF</code>
     * is used.
     * </p>
     * <p>
     * Default: <code>OFF</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diagnosticsMode}
     * will return {@link DiagnosticsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diagnosticsModeAsString}.
     * </p>
     * 
     * @return (Optional) Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise. If
     *         you want to send diagnostic trouble codes, use <code>SEND_ACTIVE_DTCS</code>. If it's not specified,
     *         <code>OFF</code> is used.</p>
     *         <p>
     *         Default: <code>OFF</code>
     * @see DiagnosticsMode
     */
    public final String diagnosticsModeAsString() {
        return diagnosticsMode;
    }

    /**
     * <p>
     * (Optional) Whether to store collected data after a vehicle lost a connection with the cloud. After a connection
     * is re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise. If you want to store
     * collected data when a vehicle loses connection with the cloud, use <code>TO_DISK</code>. If it's not specified,
     * <code>OFF</code> is used.
     * </p>
     * <p>
     * Default: <code>OFF</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spoolingMode} will
     * return {@link SpoolingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #spoolingModeAsString}.
     * </p>
     * 
     * @return (Optional) Whether to store collected data after a vehicle lost a connection with the cloud. After a
     *         connection is re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise.
     *         If you want to store collected data when a vehicle loses connection with the cloud, use
     *         <code>TO_DISK</code>. If it's not specified, <code>OFF</code> is used.</p>
     *         <p>
     *         Default: <code>OFF</code>
     * @see SpoolingMode
     */
    public final SpoolingMode spoolingMode() {
        return SpoolingMode.fromValue(spoolingMode);
    }

    /**
     * <p>
     * (Optional) Whether to store collected data after a vehicle lost a connection with the cloud. After a connection
     * is re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise. If you want to store
     * collected data when a vehicle loses connection with the cloud, use <code>TO_DISK</code>. If it's not specified,
     * <code>OFF</code> is used.
     * </p>
     * <p>
     * Default: <code>OFF</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spoolingMode} will
     * return {@link SpoolingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #spoolingModeAsString}.
     * </p>
     * 
     * @return (Optional) Whether to store collected data after a vehicle lost a connection with the cloud. After a
     *         connection is re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise.
     *         If you want to store collected data when a vehicle loses connection with the cloud, use
     *         <code>TO_DISK</code>. If it's not specified, <code>OFF</code> is used.</p>
     *         <p>
     *         Default: <code>OFF</code>
     * @see SpoolingMode
     */
    public final String spoolingModeAsString() {
        return spoolingMode;
    }

    /**
     * <p>
     * (Optional) Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If you
     * don't want to compress the signals, use <code>OFF</code>. If it's not specified, <code>SNAPPY</code> is used.
     * </p>
     * <p>
     * Default: <code>SNAPPY</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compression} will
     * return {@link Compression#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compressionAsString}.
     * </p>
     * 
     * @return (Optional) Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If
     *         you don't want to compress the signals, use <code>OFF</code>. If it's not specified, <code>SNAPPY</code>
     *         is used. </p>
     *         <p>
     *         Default: <code>SNAPPY</code>
     * @see Compression
     */
    public final Compression compression() {
        return Compression.fromValue(compression);
    }

    /**
     * <p>
     * (Optional) Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If you
     * don't want to compress the signals, use <code>OFF</code>. If it's not specified, <code>SNAPPY</code> is used.
     * </p>
     * <p>
     * Default: <code>SNAPPY</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compression} will
     * return {@link Compression#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compressionAsString}.
     * </p>
     * 
     * @return (Optional) Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If
     *         you don't want to compress the signals, use <code>OFF</code>. If it's not specified, <code>SNAPPY</code>
     *         is used. </p>
     *         <p>
     *         Default: <code>SNAPPY</code>
     * @see Compression
     */
    public final String compressionAsString() {
        return compression;
    }

    /**
     * <p>
     * (Optional) A number indicating the priority of one campaign over another campaign for a certain vehicle or fleet.
     * A campaign with the lowest value is deployed to vehicles before any other campaigns. If it's not specified,
     * <code>0</code> is used.
     * </p>
     * <p>
     * Default: <code>0</code>
     * </p>
     * 
     * @return (Optional) A number indicating the priority of one campaign over another campaign for a certain vehicle
     *         or fleet. A campaign with the lowest value is deployed to vehicles before any other campaigns. If it's
     *         not specified, <code>0</code> is used. </p>
     *         <p>
     *         Default: <code>0</code>
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * For responses, this returns true if the service returned a value for the SignalsToCollect property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSignalsToCollect() {
        return signalsToCollect != null && !(signalsToCollect instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Optional) A list of information about signals to collect.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSignalsToCollect} method.
     * </p>
     * 
     * @return (Optional) A list of information about signals to collect.
     */
    public final List<SignalInformation> signalsToCollect() {
        return signalsToCollect;
    }

    /**
     * <p>
     * The data collection scheme associated with the campaign. You can specify a scheme that collects data based on
     * time or an event.
     * </p>
     * 
     * @return The data collection scheme associated with the campaign. You can specify a scheme that collects data
     *         based on time or an event.
     */
    public final CollectionScheme collectionScheme() {
        return collectionScheme;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataExtraDimensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataExtraDimensions() {
        return dataExtraDimensions != null && !(dataExtraDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Optional) A list of vehicle attributes to associate with a campaign.
     * </p>
     * <p>
     * Enrich the data with specified vehicle attributes. For example, add <code>make</code> and <code>model</code> to
     * the campaign, and Amazon Web Services IoT FleetWise will associate the data with those attributes as dimensions
     * in Amazon Timestream. You can then query the data against <code>make</code> and <code>model</code>.
     * </p>
     * <p>
     * Default: An empty array
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataExtraDimensions} method.
     * </p>
     * 
     * @return (Optional) A list of vehicle attributes to associate with a campaign. </p>
     *         <p>
     *         Enrich the data with specified vehicle attributes. For example, add <code>make</code> and
     *         <code>model</code> to the campaign, and Amazon Web Services IoT FleetWise will associate the data with
     *         those attributes as dimensions in Amazon Timestream. You can then query the data against
     *         <code>make</code> and <code>model</code>.
     *         </p>
     *         <p>
     *         Default: An empty array
     */
    public final List<String> dataExtraDimensions() {
        return dataExtraDimensions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata that can be used to manage the campaign.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata that can be used to manage the campaign.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataDestinationConfigs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDataDestinationConfigs() {
        return dataDestinationConfigs != null && !(dataDestinationConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination where the campaign sends data. You can choose to send data to be stored in Amazon S3 or Amazon
     * Timestream.
     * </p>
     * <p>
     * Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such as data
     * lakes, centralized data storage, data processing pipelines, and analytics. Amazon Web Services IoT FleetWise
     * supports at-least-once file delivery to S3. Your vehicle data is stored on multiple Amazon Web Services IoT
     * FleetWise servers for redundancy and high availability.
     * </p>
     * <p>
     * You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle data so
     * that you can identify trends and patterns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataDestinationConfigs} method.
     * </p>
     * 
     * @return The destination where the campaign sends data. You can choose to send data to be stored in Amazon S3 or
     *         Amazon Timestream.</p>
     *         <p>
     *         Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such
     *         as data lakes, centralized data storage, data processing pipelines, and analytics. Amazon Web Services
     *         IoT FleetWise supports at-least-once file delivery to S3. Your vehicle data is stored on multiple Amazon
     *         Web Services IoT FleetWise servers for redundancy and high availability.
     *         </p>
     *         <p>
     *         You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle
     *         data so that you can identify trends and patterns.
     */
    public final List<DataDestinationConfig> dataDestinationConfigs() {
        return dataDestinationConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(signalCatalogArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(expiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(postTriggerCollectionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(diagnosticsModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spoolingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(compressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(hasSignalsToCollect() ? signalsToCollect() : null);
        hashCode = 31 * hashCode + Objects.hashCode(collectionScheme());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataExtraDimensions() ? dataExtraDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataDestinationConfigs() ? dataDestinationConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCampaignRequest)) {
            return false;
        }
        CreateCampaignRequest other = (CreateCampaignRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(signalCatalogArn(), other.signalCatalogArn()) && Objects.equals(targetArn(), other.targetArn())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(expiryTime(), other.expiryTime())
                && Objects.equals(postTriggerCollectionDuration(), other.postTriggerCollectionDuration())
                && Objects.equals(diagnosticsModeAsString(), other.diagnosticsModeAsString())
                && Objects.equals(spoolingModeAsString(), other.spoolingModeAsString())
                && Objects.equals(compressionAsString(), other.compressionAsString())
                && Objects.equals(priority(), other.priority()) && hasSignalsToCollect() == other.hasSignalsToCollect()
                && Objects.equals(signalsToCollect(), other.signalsToCollect())
                && Objects.equals(collectionScheme(), other.collectionScheme())
                && hasDataExtraDimensions() == other.hasDataExtraDimensions()
                && Objects.equals(dataExtraDimensions(), other.dataExtraDimensions()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasDataDestinationConfigs() == other.hasDataDestinationConfigs()
                && Objects.equals(dataDestinationConfigs(), other.dataDestinationConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCampaignRequest").add("Name", name()).add("Description", description())
                .add("SignalCatalogArn", signalCatalogArn()).add("TargetArn", targetArn()).add("StartTime", startTime())
                .add("ExpiryTime", expiryTime()).add("PostTriggerCollectionDuration", postTriggerCollectionDuration())
                .add("DiagnosticsMode", diagnosticsModeAsString()).add("SpoolingMode", spoolingModeAsString())
                .add("Compression", compressionAsString()).add("Priority", priority())
                .add("SignalsToCollect", hasSignalsToCollect() ? signalsToCollect() : null)
                .add("CollectionScheme", collectionScheme())
                .add("DataExtraDimensions", hasDataExtraDimensions() ? dataExtraDimensions() : null)
                .add("Tags", hasTags() ? tags() : null)
                .add("DataDestinationConfigs", hasDataDestinationConfigs() ? dataDestinationConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "signalCatalogArn":
            return Optional.ofNullable(clazz.cast(signalCatalogArn()));
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "expiryTime":
            return Optional.ofNullable(clazz.cast(expiryTime()));
        case "postTriggerCollectionDuration":
            return Optional.ofNullable(clazz.cast(postTriggerCollectionDuration()));
        case "diagnosticsMode":
            return Optional.ofNullable(clazz.cast(diagnosticsModeAsString()));
        case "spoolingMode":
            return Optional.ofNullable(clazz.cast(spoolingModeAsString()));
        case "compression":
            return Optional.ofNullable(clazz.cast(compressionAsString()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "signalsToCollect":
            return Optional.ofNullable(clazz.cast(signalsToCollect()));
        case "collectionScheme":
            return Optional.ofNullable(clazz.cast(collectionScheme()));
        case "dataExtraDimensions":
            return Optional.ofNullable(clazz.cast(dataExtraDimensions()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "dataDestinationConfigs":
            return Optional.ofNullable(clazz.cast(dataDestinationConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCampaignRequest, T> g) {
        return obj -> g.apply((CreateCampaignRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTFleetWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCampaignRequest> {
        /**
         * <p>
         * The name of the campaign to create.
         * </p>
         * 
         * @param name
         *        The name of the campaign to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description of the campaign to help identify its purpose.
         * </p>
         * 
         * @param description
         *        An optional description of the campaign to help identify its purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * (Optional) The Amazon Resource Name (ARN) of the signal catalog to associate with the campaign.
         * </p>
         * 
         * @param signalCatalogArn
         *        (Optional) The Amazon Resource Name (ARN) of the signal catalog to associate with the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalCatalogArn(String signalCatalogArn);

        /**
         * <p>
         * The ARN of the vehicle or fleet to deploy a campaign to.
         * </p>
         * 
         * @param targetArn
         *        The ARN of the vehicle or fleet to deploy a campaign to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * (Optional) The time, in milliseconds, to deliver a campaign after it was approved. If it's not specified,
         * <code>0</code> is used.
         * </p>
         * <p>
         * Default: <code>0</code>
         * </p>
         * 
         * @param startTime
         *        (Optional) The time, in milliseconds, to deliver a campaign after it was approved. If it's not
         *        specified, <code>0</code> is used.</p>
         *        <p>
         *        Default: <code>0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * (Optional) The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC time).
         * Vehicle data isn't collected after the campaign expires.
         * </p>
         * <p>
         * Default: 253402214400 (December 31, 9999, 00:00:00 UTC)
         * </p>
         * 
         * @param expiryTime
         *        (Optional) The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC
         *        time). Vehicle data isn't collected after the campaign expires. </p>
         *        <p>
         *        Default: 253402214400 (December 31, 9999, 00:00:00 UTC)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryTime(Instant expiryTime);

        /**
         * <p>
         * (Optional) How long (in milliseconds) to collect raw data after a triggering event initiates the collection.
         * If it's not specified, <code>0</code> is used.
         * </p>
         * <p>
         * Default: <code>0</code>
         * </p>
         * 
         * @param postTriggerCollectionDuration
         *        (Optional) How long (in milliseconds) to collect raw data after a triggering event initiates the
         *        collection. If it's not specified, <code>0</code> is used.</p>
         *        <p>
         *        Default: <code>0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postTriggerCollectionDuration(Long postTriggerCollectionDuration);

        /**
         * <p>
         * (Optional) Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise. If you
         * want to send diagnostic trouble codes, use <code>SEND_ACTIVE_DTCS</code>. If it's not specified,
         * <code>OFF</code> is used.
         * </p>
         * <p>
         * Default: <code>OFF</code>
         * </p>
         * 
         * @param diagnosticsMode
         *        (Optional) Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise.
         *        If you want to send diagnostic trouble codes, use <code>SEND_ACTIVE_DTCS</code>. If it's not
         *        specified, <code>OFF</code> is used.</p>
         *        <p>
         *        Default: <code>OFF</code>
         * @see DiagnosticsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiagnosticsMode
         */
        Builder diagnosticsMode(String diagnosticsMode);

        /**
         * <p>
         * (Optional) Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise. If you
         * want to send diagnostic trouble codes, use <code>SEND_ACTIVE_DTCS</code>. If it's not specified,
         * <code>OFF</code> is used.
         * </p>
         * <p>
         * Default: <code>OFF</code>
         * </p>
         * 
         * @param diagnosticsMode
         *        (Optional) Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise.
         *        If you want to send diagnostic trouble codes, use <code>SEND_ACTIVE_DTCS</code>. If it's not
         *        specified, <code>OFF</code> is used.</p>
         *        <p>
         *        Default: <code>OFF</code>
         * @see DiagnosticsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiagnosticsMode
         */
        Builder diagnosticsMode(DiagnosticsMode diagnosticsMode);

        /**
         * <p>
         * (Optional) Whether to store collected data after a vehicle lost a connection with the cloud. After a
         * connection is re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise. If
         * you want to store collected data when a vehicle loses connection with the cloud, use <code>TO_DISK</code>. If
         * it's not specified, <code>OFF</code> is used.
         * </p>
         * <p>
         * Default: <code>OFF</code>
         * </p>
         * 
         * @param spoolingMode
         *        (Optional) Whether to store collected data after a vehicle lost a connection with the cloud. After a
         *        connection is re-established, the data is automatically forwarded to Amazon Web Services IoT
         *        FleetWise. If you want to store collected data when a vehicle loses connection with the cloud, use
         *        <code>TO_DISK</code>. If it's not specified, <code>OFF</code> is used.</p>
         *        <p>
         *        Default: <code>OFF</code>
         * @see SpoolingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpoolingMode
         */
        Builder spoolingMode(String spoolingMode);

        /**
         * <p>
         * (Optional) Whether to store collected data after a vehicle lost a connection with the cloud. After a
         * connection is re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise. If
         * you want to store collected data when a vehicle loses connection with the cloud, use <code>TO_DISK</code>. If
         * it's not specified, <code>OFF</code> is used.
         * </p>
         * <p>
         * Default: <code>OFF</code>
         * </p>
         * 
         * @param spoolingMode
         *        (Optional) Whether to store collected data after a vehicle lost a connection with the cloud. After a
         *        connection is re-established, the data is automatically forwarded to Amazon Web Services IoT
         *        FleetWise. If you want to store collected data when a vehicle loses connection with the cloud, use
         *        <code>TO_DISK</code>. If it's not specified, <code>OFF</code> is used.</p>
         *        <p>
         *        Default: <code>OFF</code>
         * @see SpoolingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpoolingMode
         */
        Builder spoolingMode(SpoolingMode spoolingMode);

        /**
         * <p>
         * (Optional) Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If you
         * don't want to compress the signals, use <code>OFF</code>. If it's not specified, <code>SNAPPY</code> is used.
         * </p>
         * <p>
         * Default: <code>SNAPPY</code>
         * </p>
         * 
         * @param compression
         *        (Optional) Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise.
         *        If you don't want to compress the signals, use <code>OFF</code>. If it's not specified,
         *        <code>SNAPPY</code> is used. </p>
         *        <p>
         *        Default: <code>SNAPPY</code>
         * @see Compression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Compression
         */
        Builder compression(String compression);

        /**
         * <p>
         * (Optional) Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If you
         * don't want to compress the signals, use <code>OFF</code>. If it's not specified, <code>SNAPPY</code> is used.
         * </p>
         * <p>
         * Default: <code>SNAPPY</code>
         * </p>
         * 
         * @param compression
         *        (Optional) Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise.
         *        If you don't want to compress the signals, use <code>OFF</code>. If it's not specified,
         *        <code>SNAPPY</code> is used. </p>
         *        <p>
         *        Default: <code>SNAPPY</code>
         * @see Compression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Compression
         */
        Builder compression(Compression compression);

        /**
         * <p>
         * (Optional) A number indicating the priority of one campaign over another campaign for a certain vehicle or
         * fleet. A campaign with the lowest value is deployed to vehicles before any other campaigns. If it's not
         * specified, <code>0</code> is used.
         * </p>
         * <p>
         * Default: <code>0</code>
         * </p>
         * 
         * @param priority
         *        (Optional) A number indicating the priority of one campaign over another campaign for a certain
         *        vehicle or fleet. A campaign with the lowest value is deployed to vehicles before any other campaigns.
         *        If it's not specified, <code>0</code> is used. </p>
         *        <p>
         *        Default: <code>0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * (Optional) A list of information about signals to collect.
         * </p>
         * 
         * @param signalsToCollect
         *        (Optional) A list of information about signals to collect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalsToCollect(Collection<SignalInformation> signalsToCollect);

        /**
         * <p>
         * (Optional) A list of information about signals to collect.
         * </p>
         * 
         * @param signalsToCollect
         *        (Optional) A list of information about signals to collect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalsToCollect(SignalInformation... signalsToCollect);

        /**
         * <p>
         * (Optional) A list of information about signals to collect.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.SignalInformation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotfleetwise.model.SignalInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.SignalInformation.Builder#build()} is called
         * immediately and its result is passed to {@link #signalsToCollect(List<SignalInformation>)}.
         * 
         * @param signalsToCollect
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.SignalInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signalsToCollect(java.util.Collection<SignalInformation>)
         */
        Builder signalsToCollect(Consumer<SignalInformation.Builder>... signalsToCollect);

        /**
         * <p>
         * The data collection scheme associated with the campaign. You can specify a scheme that collects data based on
         * time or an event.
         * </p>
         * 
         * @param collectionScheme
         *        The data collection scheme associated with the campaign. You can specify a scheme that collects data
         *        based on time or an event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionScheme(CollectionScheme collectionScheme);

        /**
         * <p>
         * The data collection scheme associated with the campaign. You can specify a scheme that collects data based on
         * time or an event.
         * </p>
         * This is a convenience method that creates an instance of the {@link CollectionScheme.Builder} avoiding the
         * need to create one manually via {@link CollectionScheme#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CollectionScheme.Builder#build()} is called immediately and its
         * result is passed to {@link #collectionScheme(CollectionScheme)}.
         * 
         * @param collectionScheme
         *        a consumer that will call methods on {@link CollectionScheme.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collectionScheme(CollectionScheme)
         */
        default Builder collectionScheme(Consumer<CollectionScheme.Builder> collectionScheme) {
            return collectionScheme(CollectionScheme.builder().applyMutation(collectionScheme).build());
        }

        /**
         * <p>
         * (Optional) A list of vehicle attributes to associate with a campaign.
         * </p>
         * <p>
         * Enrich the data with specified vehicle attributes. For example, add <code>make</code> and <code>model</code>
         * to the campaign, and Amazon Web Services IoT FleetWise will associate the data with those attributes as
         * dimensions in Amazon Timestream. You can then query the data against <code>make</code> and <code>model</code>
         * .
         * </p>
         * <p>
         * Default: An empty array
         * </p>
         * 
         * @param dataExtraDimensions
         *        (Optional) A list of vehicle attributes to associate with a campaign. </p>
         *        <p>
         *        Enrich the data with specified vehicle attributes. For example, add <code>make</code> and
         *        <code>model</code> to the campaign, and Amazon Web Services IoT FleetWise will associate the data with
         *        those attributes as dimensions in Amazon Timestream. You can then query the data against
         *        <code>make</code> and <code>model</code>.
         *        </p>
         *        <p>
         *        Default: An empty array
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExtraDimensions(Collection<String> dataExtraDimensions);

        /**
         * <p>
         * (Optional) A list of vehicle attributes to associate with a campaign.
         * </p>
         * <p>
         * Enrich the data with specified vehicle attributes. For example, add <code>make</code> and <code>model</code>
         * to the campaign, and Amazon Web Services IoT FleetWise will associate the data with those attributes as
         * dimensions in Amazon Timestream. You can then query the data against <code>make</code> and <code>model</code>
         * .
         * </p>
         * <p>
         * Default: An empty array
         * </p>
         * 
         * @param dataExtraDimensions
         *        (Optional) A list of vehicle attributes to associate with a campaign. </p>
         *        <p>
         *        Enrich the data with specified vehicle attributes. For example, add <code>make</code> and
         *        <code>model</code> to the campaign, and Amazon Web Services IoT FleetWise will associate the data with
         *        those attributes as dimensions in Amazon Timestream. You can then query the data against
         *        <code>make</code> and <code>model</code>.
         *        </p>
         *        <p>
         *        Default: An empty array
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExtraDimensions(String... dataExtraDimensions);

        /**
         * <p>
         * Metadata that can be used to manage the campaign.
         * </p>
         * 
         * @param tags
         *        Metadata that can be used to manage the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata that can be used to manage the campaign.
         * </p>
         * 
         * @param tags
         *        Metadata that can be used to manage the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata that can be used to manage the campaign.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotfleetwise.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The destination where the campaign sends data. You can choose to send data to be stored in Amazon S3 or
         * Amazon Timestream.
         * </p>
         * <p>
         * Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such as
         * data lakes, centralized data storage, data processing pipelines, and analytics. Amazon Web Services IoT
         * FleetWise supports at-least-once file delivery to S3. Your vehicle data is stored on multiple Amazon Web
         * Services IoT FleetWise servers for redundancy and high availability.
         * </p>
         * <p>
         * You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle data so
         * that you can identify trends and patterns.
         * </p>
         * 
         * @param dataDestinationConfigs
         *        The destination where the campaign sends data. You can choose to send data to be stored in Amazon S3
         *        or Amazon Timestream.</p>
         *        <p>
         *        Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data,
         *        such as data lakes, centralized data storage, data processing pipelines, and analytics. Amazon Web
         *        Services IoT FleetWise supports at-least-once file delivery to S3. Your vehicle data is stored on
         *        multiple Amazon Web Services IoT FleetWise servers for redundancy and high availability.
         *        </p>
         *        <p>
         *        You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle
         *        data so that you can identify trends and patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataDestinationConfigs(Collection<DataDestinationConfig> dataDestinationConfigs);

        /**
         * <p>
         * The destination where the campaign sends data. You can choose to send data to be stored in Amazon S3 or
         * Amazon Timestream.
         * </p>
         * <p>
         * Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such as
         * data lakes, centralized data storage, data processing pipelines, and analytics. Amazon Web Services IoT
         * FleetWise supports at-least-once file delivery to S3. Your vehicle data is stored on multiple Amazon Web
         * Services IoT FleetWise servers for redundancy and high availability.
         * </p>
         * <p>
         * You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle data so
         * that you can identify trends and patterns.
         * </p>
         * 
         * @param dataDestinationConfigs
         *        The destination where the campaign sends data. You can choose to send data to be stored in Amazon S3
         *        or Amazon Timestream.</p>
         *        <p>
         *        Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data,
         *        such as data lakes, centralized data storage, data processing pipelines, and analytics. Amazon Web
         *        Services IoT FleetWise supports at-least-once file delivery to S3. Your vehicle data is stored on
         *        multiple Amazon Web Services IoT FleetWise servers for redundancy and high availability.
         *        </p>
         *        <p>
         *        You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle
         *        data so that you can identify trends and patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataDestinationConfigs(DataDestinationConfig... dataDestinationConfigs);

        /**
         * <p>
         * The destination where the campaign sends data. You can choose to send data to be stored in Amazon S3 or
         * Amazon Timestream.
         * </p>
         * <p>
         * Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such as
         * data lakes, centralized data storage, data processing pipelines, and analytics. Amazon Web Services IoT
         * FleetWise supports at-least-once file delivery to S3. Your vehicle data is stored on multiple Amazon Web
         * Services IoT FleetWise servers for redundancy and high availability.
         * </p>
         * <p>
         * You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle data so
         * that you can identify trends and patterns.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfig.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #dataDestinationConfigs(List<DataDestinationConfig>)}.
         * 
         * @param dataDestinationConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataDestinationConfigs(java.util.Collection<DataDestinationConfig>)
         */
        Builder dataDestinationConfigs(Consumer<DataDestinationConfig.Builder>... dataDestinationConfigs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTFleetWiseRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String signalCatalogArn;

        private String targetArn;

        private Instant startTime;

        private Instant expiryTime;

        private Long postTriggerCollectionDuration;

        private String diagnosticsMode;

        private String spoolingMode;

        private String compression;

        private Integer priority;

        private List<SignalInformation> signalsToCollect = DefaultSdkAutoConstructList.getInstance();

        private CollectionScheme collectionScheme;

        private List<String> dataExtraDimensions = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<DataDestinationConfig> dataDestinationConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCampaignRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            signalCatalogArn(model.signalCatalogArn);
            targetArn(model.targetArn);
            startTime(model.startTime);
            expiryTime(model.expiryTime);
            postTriggerCollectionDuration(model.postTriggerCollectionDuration);
            diagnosticsMode(model.diagnosticsMode);
            spoolingMode(model.spoolingMode);
            compression(model.compression);
            priority(model.priority);
            signalsToCollect(model.signalsToCollect);
            collectionScheme(model.collectionScheme);
            dataExtraDimensions(model.dataExtraDimensions);
            tags(model.tags);
            dataDestinationConfigs(model.dataDestinationConfigs);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSignalCatalogArn() {
            return signalCatalogArn;
        }

        public final void setSignalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
        }

        @Override
        public final Builder signalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
            return this;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getExpiryTime() {
            return expiryTime;
        }

        public final void setExpiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
        }

        @Override
        public final Builder expiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public final Long getPostTriggerCollectionDuration() {
            return postTriggerCollectionDuration;
        }

        public final void setPostTriggerCollectionDuration(Long postTriggerCollectionDuration) {
            this.postTriggerCollectionDuration = postTriggerCollectionDuration;
        }

        @Override
        public final Builder postTriggerCollectionDuration(Long postTriggerCollectionDuration) {
            this.postTriggerCollectionDuration = postTriggerCollectionDuration;
            return this;
        }

        public final String getDiagnosticsMode() {
            return diagnosticsMode;
        }

        public final void setDiagnosticsMode(String diagnosticsMode) {
            this.diagnosticsMode = diagnosticsMode;
        }

        @Override
        public final Builder diagnosticsMode(String diagnosticsMode) {
            this.diagnosticsMode = diagnosticsMode;
            return this;
        }

        @Override
        public final Builder diagnosticsMode(DiagnosticsMode diagnosticsMode) {
            this.diagnosticsMode(diagnosticsMode == null ? null : diagnosticsMode.toString());
            return this;
        }

        public final String getSpoolingMode() {
            return spoolingMode;
        }

        public final void setSpoolingMode(String spoolingMode) {
            this.spoolingMode = spoolingMode;
        }

        @Override
        public final Builder spoolingMode(String spoolingMode) {
            this.spoolingMode = spoolingMode;
            return this;
        }

        @Override
        public final Builder spoolingMode(SpoolingMode spoolingMode) {
            this.spoolingMode(spoolingMode == null ? null : spoolingMode.toString());
            return this;
        }

        public final String getCompression() {
            return compression;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(Compression compression) {
            this.compression(compression == null ? null : compression.toString());
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final List<SignalInformation.Builder> getSignalsToCollect() {
            List<SignalInformation.Builder> result = SignalInformationListCopier.copyToBuilder(this.signalsToCollect);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignalsToCollect(Collection<SignalInformation.BuilderImpl> signalsToCollect) {
            this.signalsToCollect = SignalInformationListCopier.copyFromBuilder(signalsToCollect);
        }

        @Override
        public final Builder signalsToCollect(Collection<SignalInformation> signalsToCollect) {
            this.signalsToCollect = SignalInformationListCopier.copy(signalsToCollect);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalsToCollect(SignalInformation... signalsToCollect) {
            signalsToCollect(Arrays.asList(signalsToCollect));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalsToCollect(Consumer<SignalInformation.Builder>... signalsToCollect) {
            signalsToCollect(Stream.of(signalsToCollect).map(c -> SignalInformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final CollectionScheme.Builder getCollectionScheme() {
            return collectionScheme != null ? collectionScheme.toBuilder() : null;
        }

        public final void setCollectionScheme(CollectionScheme.BuilderImpl collectionScheme) {
            this.collectionScheme = collectionScheme != null ? collectionScheme.build() : null;
        }

        @Override
        public final Builder collectionScheme(CollectionScheme collectionScheme) {
            this.collectionScheme = collectionScheme;
            return this;
        }

        public final Collection<String> getDataExtraDimensions() {
            if (dataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return dataExtraDimensions;
        }

        public final void setDataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = DataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
        }

        @Override
        public final Builder dataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = DataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataExtraDimensions(String... dataExtraDimensions) {
            dataExtraDimensions(Arrays.asList(dataExtraDimensions));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataDestinationConfig.Builder> getDataDestinationConfigs() {
            List<DataDestinationConfig.Builder> result = DataDestinationConfigsCopier.copyToBuilder(this.dataDestinationConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataDestinationConfigs(Collection<DataDestinationConfig.BuilderImpl> dataDestinationConfigs) {
            this.dataDestinationConfigs = DataDestinationConfigsCopier.copyFromBuilder(dataDestinationConfigs);
        }

        @Override
        public final Builder dataDestinationConfigs(Collection<DataDestinationConfig> dataDestinationConfigs) {
            this.dataDestinationConfigs = DataDestinationConfigsCopier.copy(dataDestinationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataDestinationConfigs(DataDestinationConfig... dataDestinationConfigs) {
            dataDestinationConfigs(Arrays.asList(dataDestinationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataDestinationConfigs(Consumer<DataDestinationConfig.Builder>... dataDestinationConfigs) {
            dataDestinationConfigs(Stream.of(dataDestinationConfigs)
                    .map(c -> DataDestinationConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCampaignRequest build() {
            return new CreateCampaignRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
