/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFleetsForVehicleRequest extends IoTFleetWiseRequest implements
        ToCopyableBuilder<ListFleetsForVehicleRequest.Builder, ListFleetsForVehicleRequest> {
    private static final SdkField<String> VEHICLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vehicleName").getter(getter(ListFleetsForVehicleRequest::vehicleName))
            .setter(setter(Builder::vehicleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicleName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFleetsForVehicleRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListFleetsForVehicleRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLE_NAME_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String vehicleName;

    private final String nextToken;

    private final Integer maxResults;

    private ListFleetsForVehicleRequest(BuilderImpl builder) {
        super(builder);
        this.vehicleName = builder.vehicleName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the vehicle to retrieve information about.
     * </p>
     * 
     * @return The ID of the vehicle to retrieve information about.
     */
    public final String vehicleName() {
        return vehicleName;
    }

    /**
     * <p>
     * A pagination token for the next set of results.
     * </p>
     * <p>
     * If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code>
     * pagination token is returned in the response. To retrieve the next set of results, reissue the search request and
     * include the returned token. When all results have been returned, the response does not contain a pagination token
     * value.
     * </p>
     * 
     * @return A pagination token for the next set of results.</p>
     *         <p>
     *         If the results of a search are large, only a portion of the results are returned, and a
     *         <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results,
     *         reissue the search request and include the returned token. When all results have been returned, the
     *         response does not contain a pagination token value.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return, between 1 and 100, inclusive.
     * </p>
     * 
     * @return The maximum number of items to return, between 1 and 100, inclusive.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vehicleName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFleetsForVehicleRequest)) {
            return false;
        }
        ListFleetsForVehicleRequest other = (ListFleetsForVehicleRequest) obj;
        return Objects.equals(vehicleName(), other.vehicleName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFleetsForVehicleRequest").add("VehicleName", vehicleName()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vehicleName":
            return Optional.ofNullable(clazz.cast(vehicleName()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFleetsForVehicleRequest, T> g) {
        return obj -> g.apply((ListFleetsForVehicleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTFleetWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFleetsForVehicleRequest> {
        /**
         * <p>
         * The ID of the vehicle to retrieve information about.
         * </p>
         * 
         * @param vehicleName
         *        The ID of the vehicle to retrieve information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vehicleName(String vehicleName);

        /**
         * <p>
         * A pagination token for the next set of results.
         * </p>
         * <p>
         * If the results of a search are large, only a portion of the results are returned, and a
         * <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results,
         * reissue the search request and include the returned token. When all results have been returned, the response
         * does not contain a pagination token value.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for the next set of results.</p>
         *        <p>
         *        If the results of a search are large, only a portion of the results are returned, and a
         *        <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of
         *        results, reissue the search request and include the returned token. When all results have been
         *        returned, the response does not contain a pagination token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return, between 1 and 100, inclusive.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return, between 1 and 100, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTFleetWiseRequest.BuilderImpl implements Builder {
        private String vehicleName;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFleetsForVehicleRequest model) {
            super(model);
            vehicleName(model.vehicleName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getVehicleName() {
            return vehicleName;
        }

        public final void setVehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
        }

        @Override
        public final Builder vehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFleetsForVehicleRequest build() {
            return new ListFleetsForVehicleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
