/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.StructuredMessage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageSignal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageSignal> {
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("topicName").getter(MessageSignal.getter(MessageSignal::topicName)).setter(MessageSignal.setter(Builder::topicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicName").build()}).build();
    private static final SdkField<StructuredMessage> STRUCTURED_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("structuredMessage").getter(MessageSignal.getter(MessageSignal::structuredMessage)).setter(MessageSignal.setter(Builder::structuredMessage)).constructor(StructuredMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("structuredMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_NAME_FIELD, STRUCTURED_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String topicName;
    private final StructuredMessage structuredMessage;

    private MessageSignal(BuilderImpl builder) {
        this.topicName = builder.topicName;
        this.structuredMessage = builder.structuredMessage;
    }

    public final String topicName() {
        return this.topicName;
    }

    public final StructuredMessage structuredMessage() {
        return this.structuredMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicName());
        hashCode = 31 * hashCode + Objects.hashCode(this.structuredMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageSignal)) {
            return false;
        }
        MessageSignal other = (MessageSignal)obj;
        return Objects.equals(this.topicName(), other.topicName()) && Objects.equals(this.structuredMessage(), other.structuredMessage());
    }

    public final String toString() {
        return ToString.builder((String)"MessageSignal").add("TopicName", (Object)this.topicName()).add("StructuredMessage", (Object)this.structuredMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "topicName": {
                return Optional.ofNullable(clazz.cast(this.topicName()));
            }
            case "structuredMessage": {
                return Optional.ofNullable(clazz.cast(this.structuredMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MessageSignal, T> g) {
        return obj -> g.apply((MessageSignal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String topicName;
        private StructuredMessage structuredMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageSignal model) {
            this.topicName(model.topicName);
            this.structuredMessage(model.structuredMessage);
        }

        public final String getTopicName() {
            return this.topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final StructuredMessage.Builder getStructuredMessage() {
            return this.structuredMessage != null ? this.structuredMessage.toBuilder() : null;
        }

        public final void setStructuredMessage(StructuredMessage.BuilderImpl structuredMessage) {
            this.structuredMessage = structuredMessage != null ? structuredMessage.build() : null;
        }

        @Override
        public final Builder structuredMessage(StructuredMessage structuredMessage) {
            this.structuredMessage = structuredMessage;
            return this;
        }

        public MessageSignal build() {
            return new MessageSignal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageSignal> {
        public Builder topicName(String var1);

        public Builder structuredMessage(StructuredMessage var1);

        default public Builder structuredMessage(Consumer<StructuredMessage.Builder> structuredMessage) {
            return this.structuredMessage((StructuredMessage)((StructuredMessage.Builder)StructuredMessage.builder().applyMutation(structuredMessage)).build());
        }
    }
}

