/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.NodeDataType;
import software.amazon.awssdk.services.iotfleetwise.model._listOfStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Sensor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Sensor> {
    private static final SdkField<String> FULLY_QUALIFIED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fullyQualifiedName").getter(Sensor.getter(Sensor::fullyQualifiedName)).setter(Sensor.setter(Builder::fullyQualifiedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullyQualifiedName").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(Sensor.getter(Sensor::dataTypeAsString)).setter(Sensor.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Sensor.getter(Sensor::description)).setter(Sensor.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(Sensor.getter(Sensor::unit)).setter(Sensor.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedValues").getter(Sensor.getter(Sensor::allowedValues)).setter(Sensor.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> MIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("min").getter(Sensor.getter(Sensor::min)).setter(Sensor.setter(Builder::min)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("min").build()}).build();
    private static final SdkField<Double> MAX_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("max").getter(Sensor.getter(Sensor::max)).setter(Sensor.setter(Builder::max)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("max").build()}).build();
    private static final SdkField<String> DEPRECATION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deprecationMessage").getter(Sensor.getter(Sensor::deprecationMessage)).setter(Sensor.setter(Builder::deprecationMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecationMessage").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(Sensor.getter(Sensor::comment)).setter(Sensor.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<String> STRUCT_FULLY_QUALIFIED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("structFullyQualifiedName").getter(Sensor.getter(Sensor::structFullyQualifiedName)).setter(Sensor.setter(Builder::structFullyQualifiedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("structFullyQualifiedName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FULLY_QUALIFIED_NAME_FIELD, DATA_TYPE_FIELD, DESCRIPTION_FIELD, UNIT_FIELD, ALLOWED_VALUES_FIELD, MIN_FIELD, MAX_FIELD, DEPRECATION_MESSAGE_FIELD, COMMENT_FIELD, STRUCT_FULLY_QUALIFIED_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Sensor.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fullyQualifiedName;
    private final String dataType;
    private final String description;
    private final String unit;
    private final List<String> allowedValues;
    private final Double min;
    private final Double max;
    private final String deprecationMessage;
    private final String comment;
    private final String structFullyQualifiedName;

    private Sensor(BuilderImpl builder) {
        this.fullyQualifiedName = builder.fullyQualifiedName;
        this.dataType = builder.dataType;
        this.description = builder.description;
        this.unit = builder.unit;
        this.allowedValues = builder.allowedValues;
        this.min = builder.min;
        this.max = builder.max;
        this.deprecationMessage = builder.deprecationMessage;
        this.comment = builder.comment;
        this.structFullyQualifiedName = builder.structFullyQualifiedName;
    }

    public final String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public final NodeDataType dataType() {
        return NodeDataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final String description() {
        return this.description;
    }

    public final String unit() {
        return this.unit;
    }

    public final boolean hasAllowedValues() {
        return this.allowedValues != null && !(this.allowedValues instanceof SdkAutoConstructList);
    }

    public final List<String> allowedValues() {
        return this.allowedValues;
    }

    public final Double min() {
        return this.min;
    }

    public final Double max() {
        return this.max;
    }

    public final String deprecationMessage() {
        return this.deprecationMessage;
    }

    public final String comment() {
        return this.comment;
    }

    public final String structFullyQualifiedName() {
        return this.structFullyQualifiedName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fullyQualifiedName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedValues() ? this.allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.min());
        hashCode = 31 * hashCode + Objects.hashCode(this.max());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.structFullyQualifiedName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sensor)) {
            return false;
        }
        Sensor other = (Sensor)obj;
        return Objects.equals(this.fullyQualifiedName(), other.fullyQualifiedName()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.unit(), other.unit()) && this.hasAllowedValues() == other.hasAllowedValues() && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.min(), other.min()) && Objects.equals(this.max(), other.max()) && Objects.equals(this.deprecationMessage(), other.deprecationMessage()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.structFullyQualifiedName(), other.structFullyQualifiedName());
    }

    public final String toString() {
        return ToString.builder((String)"Sensor").add("FullyQualifiedName", (Object)this.fullyQualifiedName()).add("DataType", (Object)this.dataTypeAsString()).add("Description", (Object)this.description()).add("Unit", (Object)this.unit()).add("AllowedValues", this.hasAllowedValues() ? this.allowedValues() : null).add("Min", (Object)this.min()).add("Max", (Object)this.max()).add("DeprecationMessage", (Object)this.deprecationMessage()).add("Comment", (Object)this.comment()).add("StructFullyQualifiedName", (Object)this.structFullyQualifiedName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fullyQualifiedName": {
                return Optional.ofNullable(clazz.cast(this.fullyQualifiedName()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "allowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "min": {
                return Optional.ofNullable(clazz.cast(this.min()));
            }
            case "max": {
                return Optional.ofNullable(clazz.cast(this.max()));
            }
            case "deprecationMessage": {
                return Optional.ofNullable(clazz.cast(this.deprecationMessage()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "structFullyQualifiedName": {
                return Optional.ofNullable(clazz.cast(this.structFullyQualifiedName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fullyQualifiedName", FULLY_QUALIFIED_NAME_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("unit", UNIT_FIELD);
        map.put("allowedValues", ALLOWED_VALUES_FIELD);
        map.put("min", MIN_FIELD);
        map.put("max", MAX_FIELD);
        map.put("deprecationMessage", DEPRECATION_MESSAGE_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("structFullyQualifiedName", STRUCT_FULLY_QUALIFIED_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Sensor, T> g) {
        return obj -> g.apply((Sensor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fullyQualifiedName;
        private String dataType;
        private String description;
        private String unit;
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();
        private Double min;
        private Double max;
        private String deprecationMessage;
        private String comment;
        private String structFullyQualifiedName;

        private BuilderImpl() {
        }

        private BuilderImpl(Sensor model) {
            this.fullyQualifiedName(model.fullyQualifiedName);
            this.dataType(model.dataType);
            this.description(model.description);
            this.unit(model.unit);
            this.allowedValues(model.allowedValues);
            this.min(model.min);
            this.max(model.max);
            this.deprecationMessage(model.deprecationMessage);
            this.comment(model.comment);
            this.structFullyQualifiedName(model.structFullyQualifiedName);
        }

        public final String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public final void setFullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public final Builder fullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(NodeDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final Collection<String> getAllowedValues() {
            if (this.allowedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedValues;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = _listOfStringsCopier.copy(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = _listOfStringsCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final Double getMin() {
            return this.min;
        }

        public final void setMin(Double min) {
            this.min = min;
        }

        @Override
        public final Builder min(Double min) {
            this.min = min;
            return this;
        }

        public final Double getMax() {
            return this.max;
        }

        public final void setMax(Double max) {
            this.max = max;
        }

        @Override
        public final Builder max(Double max) {
            this.max = max;
            return this;
        }

        public final String getDeprecationMessage() {
            return this.deprecationMessage;
        }

        public final void setDeprecationMessage(String deprecationMessage) {
            this.deprecationMessage = deprecationMessage;
        }

        @Override
        public final Builder deprecationMessage(String deprecationMessage) {
            this.deprecationMessage = deprecationMessage;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getStructFullyQualifiedName() {
            return this.structFullyQualifiedName;
        }

        public final void setStructFullyQualifiedName(String structFullyQualifiedName) {
            this.structFullyQualifiedName = structFullyQualifiedName;
        }

        @Override
        public final Builder structFullyQualifiedName(String structFullyQualifiedName) {
            this.structFullyQualifiedName = structFullyQualifiedName;
            return this;
        }

        public Sensor build() {
            return new Sensor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Sensor> {
        public Builder fullyQualifiedName(String var1);

        public Builder dataType(String var1);

        public Builder dataType(NodeDataType var1);

        public Builder description(String var1);

        public Builder unit(String var1);

        public Builder allowedValues(Collection<String> var1);

        public Builder allowedValues(String ... var1);

        public Builder min(Double var1);

        public Builder max(Double var1);

        public Builder deprecationMessage(String var1);

        public Builder comment(String var1);

        public Builder structFullyQualifiedName(String var1);
    }
}

