/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder;

public class ListDecoderManifestSignalsIterable
implements SdkIterable<ListDecoderManifestSignalsResponse> {
    private final IoTFleetWiseClient client;
    private final ListDecoderManifestSignalsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDecoderManifestSignalsIterable(IoTFleetWiseClient client, ListDecoderManifestSignalsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDecoderManifestSignalsResponseFetcher();
    }

    public Iterator<ListDecoderManifestSignalsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SignalDecoder> signalDecoders() {
        Function<ListDecoderManifestSignalsResponse, Iterator> getIterator = response -> {
            if (response != null && response.signalDecoders() != null) {
                return response.signalDecoders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDecoderManifestSignalsResponseFetcher
    implements SyncPageFetcher<ListDecoderManifestSignalsResponse> {
        private ListDecoderManifestSignalsResponseFetcher() {
        }

        public boolean hasNextPage(ListDecoderManifestSignalsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDecoderManifestSignalsResponse nextPage(ListDecoderManifestSignalsResponse previousPage) {
            if (previousPage == null) {
                return ListDecoderManifestSignalsIterable.this.client.listDecoderManifestSignals(ListDecoderManifestSignalsIterable.this.firstRequest);
            }
            return ListDecoderManifestSignalsIterable.this.client.listDecoderManifestSignals((ListDecoderManifestSignalsRequest)((Object)ListDecoderManifestSignalsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

