/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.QualitiesCopier;
import software.amazon.awssdk.services.iotsitewise.model.Quality;
import software.amazon.awssdk.services.iotsitewise.model.TimeOrdering;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAssetPropertyValueHistoryEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchGetAssetPropertyValueHistoryEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entryId").getter(BatchGetAssetPropertyValueHistoryEntry.getter(BatchGetAssetPropertyValueHistoryEntry::entryId)).setter(BatchGetAssetPropertyValueHistoryEntry.setter(Builder::entryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()}).build();
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(BatchGetAssetPropertyValueHistoryEntry.getter(BatchGetAssetPropertyValueHistoryEntry::assetId)).setter(BatchGetAssetPropertyValueHistoryEntry.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyId").getter(BatchGetAssetPropertyValueHistoryEntry.getter(BatchGetAssetPropertyValueHistoryEntry::propertyId)).setter(BatchGetAssetPropertyValueHistoryEntry.setter(Builder::propertyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyId").build()}).build();
    private static final SdkField<String> PROPERTY_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyAlias").getter(BatchGetAssetPropertyValueHistoryEntry.getter(BatchGetAssetPropertyValueHistoryEntry::propertyAlias)).setter(BatchGetAssetPropertyValueHistoryEntry.setter(Builder::propertyAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyAlias").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startDate").getter(BatchGetAssetPropertyValueHistoryEntry.getter(BatchGetAssetPropertyValueHistoryEntry::startDate)).setter(BatchGetAssetPropertyValueHistoryEntry.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endDate").getter(BatchGetAssetPropertyValueHistoryEntry.getter(BatchGetAssetPropertyValueHistoryEntry::endDate)).setter(BatchGetAssetPropertyValueHistoryEntry.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDate").build()}).build();
    private static final SdkField<List<String>> QUALITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("qualities").getter(BatchGetAssetPropertyValueHistoryEntry.getter(BatchGetAssetPropertyValueHistoryEntry::qualitiesAsStrings)).setter(BatchGetAssetPropertyValueHistoryEntry.setter(Builder::qualitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TIME_ORDERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeOrdering").getter(BatchGetAssetPropertyValueHistoryEntry.getter(BatchGetAssetPropertyValueHistoryEntry::timeOrderingAsString)).setter(BatchGetAssetPropertyValueHistoryEntry.setter(Builder::timeOrdering)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeOrdering").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD, ASSET_ID_FIELD, PROPERTY_ID_FIELD, PROPERTY_ALIAS_FIELD, START_DATE_FIELD, END_DATE_FIELD, QUALITIES_FIELD, TIME_ORDERING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetAssetPropertyValueHistoryEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String entryId;
    private final String assetId;
    private final String propertyId;
    private final String propertyAlias;
    private final Instant startDate;
    private final Instant endDate;
    private final List<String> qualities;
    private final String timeOrdering;

    private BatchGetAssetPropertyValueHistoryEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.propertyAlias = builder.propertyAlias;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.qualities = builder.qualities;
        this.timeOrdering = builder.timeOrdering;
    }

    public final String entryId() {
        return this.entryId;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String propertyId() {
        return this.propertyId;
    }

    public final String propertyAlias() {
        return this.propertyAlias;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final List<Quality> qualities() {
        return QualitiesCopier.copyStringToEnum(this.qualities);
    }

    public final boolean hasQualities() {
        return this.qualities != null && !(this.qualities instanceof SdkAutoConstructList);
    }

    public final List<String> qualitiesAsStrings() {
        return this.qualities;
    }

    public final TimeOrdering timeOrdering() {
        return TimeOrdering.fromValue(this.timeOrdering);
    }

    public final String timeOrderingAsString() {
        return this.timeOrdering;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQualities() ? this.qualitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeOrderingAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyValueHistoryEntry)) {
            return false;
        }
        BatchGetAssetPropertyValueHistoryEntry other = (BatchGetAssetPropertyValueHistoryEntry)obj;
        return Objects.equals(this.entryId(), other.entryId()) && Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.propertyId(), other.propertyId()) && Objects.equals(this.propertyAlias(), other.propertyAlias()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && this.hasQualities() == other.hasQualities() && Objects.equals(this.qualitiesAsStrings(), other.qualitiesAsStrings()) && Objects.equals(this.timeOrderingAsString(), other.timeOrderingAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAssetPropertyValueHistoryEntry").add("EntryId", (Object)this.entryId()).add("AssetId", (Object)this.assetId()).add("PropertyId", (Object)this.propertyId()).add("PropertyAlias", (Object)this.propertyAlias()).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("Qualities", this.hasQualities() ? this.qualitiesAsStrings() : null).add("TimeOrdering", (Object)this.timeOrderingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entryId": {
                return Optional.ofNullable(clazz.cast(this.entryId()));
            }
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "propertyId": {
                return Optional.ofNullable(clazz.cast(this.propertyId()));
            }
            case "propertyAlias": {
                return Optional.ofNullable(clazz.cast(this.propertyAlias()));
            }
            case "startDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "endDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "qualities": {
                return Optional.ofNullable(clazz.cast(this.qualitiesAsStrings()));
            }
            case "timeOrdering": {
                return Optional.ofNullable(clazz.cast(this.timeOrderingAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entryId", ENTRY_ID_FIELD);
        map.put("assetId", ASSET_ID_FIELD);
        map.put("propertyId", PROPERTY_ID_FIELD);
        map.put("propertyAlias", PROPERTY_ALIAS_FIELD);
        map.put("startDate", START_DATE_FIELD);
        map.put("endDate", END_DATE_FIELD);
        map.put("qualities", QUALITIES_FIELD);
        map.put("timeOrdering", TIME_ORDERING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyValueHistoryEntry, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyValueHistoryEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entryId;
        private String assetId;
        private String propertyId;
        private String propertyAlias;
        private Instant startDate;
        private Instant endDate;
        private List<String> qualities = DefaultSdkAutoConstructList.getInstance();
        private String timeOrdering;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyValueHistoryEntry model) {
            this.entryId(model.entryId);
            this.assetId(model.assetId);
            this.propertyId(model.propertyId);
            this.propertyAlias(model.propertyAlias);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.qualitiesWithStrings(model.qualities);
            this.timeOrdering(model.timeOrdering);
        }

        public final String getEntryId() {
            return this.entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getPropertyId() {
            return this.propertyId;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final String getPropertyAlias() {
            return this.propertyAlias;
        }

        public final void setPropertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
        }

        @Override
        public final Builder propertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final Collection<String> getQualities() {
            if (this.qualities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.qualities;
        }

        public final void setQualities(Collection<String> qualities) {
            this.qualities = QualitiesCopier.copy(qualities);
        }

        @Override
        public final Builder qualitiesWithStrings(Collection<String> qualities) {
            this.qualities = QualitiesCopier.copy(qualities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualitiesWithStrings(String ... qualities) {
            this.qualitiesWithStrings(Arrays.asList(qualities));
            return this;
        }

        @Override
        public final Builder qualities(Collection<Quality> qualities) {
            this.qualities = QualitiesCopier.copyEnumToString(qualities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualities(Quality ... qualities) {
            this.qualities(Arrays.asList(qualities));
            return this;
        }

        public final String getTimeOrdering() {
            return this.timeOrdering;
        }

        public final void setTimeOrdering(String timeOrdering) {
            this.timeOrdering = timeOrdering;
        }

        @Override
        public final Builder timeOrdering(String timeOrdering) {
            this.timeOrdering = timeOrdering;
            return this;
        }

        @Override
        public final Builder timeOrdering(TimeOrdering timeOrdering) {
            this.timeOrdering(timeOrdering == null ? null : timeOrdering.toString());
            return this;
        }

        public BatchGetAssetPropertyValueHistoryEntry build() {
            return new BatchGetAssetPropertyValueHistoryEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchGetAssetPropertyValueHistoryEntry> {
        public Builder entryId(String var1);

        public Builder assetId(String var1);

        public Builder propertyId(String var1);

        public Builder propertyAlias(String var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder qualitiesWithStrings(Collection<String> var1);

        public Builder qualitiesWithStrings(String ... var1);

        public Builder qualities(Collection<Quality> var1);

        public Builder qualities(Quality ... var1);

        public Builder timeOrdering(String var1);

        public Builder timeOrdering(TimeOrdering var1);
    }
}

