/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyBindingValue;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertyBindingValue;
import software.amazon.awssdk.services.iotsitewise.model.BindingValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputationModelDataBindingValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputationModelDataBindingValue> {
    private static final SdkField<AssetModelPropertyBindingValue> ASSET_MODEL_PROPERTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetModelProperty").getter(ComputationModelDataBindingValue.getter(ComputationModelDataBindingValue::assetModelProperty)).setter(ComputationModelDataBindingValue.setter(Builder::assetModelProperty)).constructor(AssetModelPropertyBindingValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelProperty").build()}).build();
    private static final SdkField<AssetPropertyBindingValue> ASSET_PROPERTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetProperty").getter(ComputationModelDataBindingValue.getter(ComputationModelDataBindingValue::assetProperty)).setter(ComputationModelDataBindingValue.setter(Builder::assetProperty)).constructor(AssetPropertyBindingValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetProperty").build()}).build();
    private static final SdkField<List<ComputationModelDataBindingValue>> LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("list").getter(ComputationModelDataBindingValue.getter(ComputationModelDataBindingValue::list)).setter(ComputationModelDataBindingValue.setter(Builder::list)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("list").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComputationModelDataBindingValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_PROPERTY_FIELD, ASSET_PROPERTY_FIELD, LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComputationModelDataBindingValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AssetModelPropertyBindingValue assetModelProperty;
    private final AssetPropertyBindingValue assetProperty;
    private final List<ComputationModelDataBindingValue> list;

    private ComputationModelDataBindingValue(BuilderImpl builder) {
        this.assetModelProperty = builder.assetModelProperty;
        this.assetProperty = builder.assetProperty;
        this.list = builder.list;
    }

    public final AssetModelPropertyBindingValue assetModelProperty() {
        return this.assetModelProperty;
    }

    public final AssetPropertyBindingValue assetProperty() {
        return this.assetProperty;
    }

    public final boolean hasList() {
        return this.list != null && !(this.list instanceof SdkAutoConstructList);
    }

    public final List<ComputationModelDataBindingValue> list() {
        return this.list;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelProperty());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetProperty());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasList() ? this.list() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputationModelDataBindingValue)) {
            return false;
        }
        ComputationModelDataBindingValue other = (ComputationModelDataBindingValue)obj;
        return Objects.equals(this.assetModelProperty(), other.assetModelProperty()) && Objects.equals(this.assetProperty(), other.assetProperty()) && this.hasList() == other.hasList() && Objects.equals(this.list(), other.list());
    }

    public final String toString() {
        return ToString.builder((String)"ComputationModelDataBindingValue").add("AssetModelProperty", (Object)this.assetModelProperty()).add("AssetProperty", (Object)this.assetProperty()).add("List", this.hasList() ? this.list() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelProperty": {
                return Optional.ofNullable(clazz.cast(this.assetModelProperty()));
            }
            case "assetProperty": {
                return Optional.ofNullable(clazz.cast(this.assetProperty()));
            }
            case "list": {
                return Optional.ofNullable(clazz.cast(this.list()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetModelProperty", ASSET_MODEL_PROPERTY_FIELD);
        map.put("assetProperty", ASSET_PROPERTY_FIELD);
        map.put("list", LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputationModelDataBindingValue, T> g) {
        return obj -> g.apply((ComputationModelDataBindingValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AssetModelPropertyBindingValue assetModelProperty;
        private AssetPropertyBindingValue assetProperty;
        private List<ComputationModelDataBindingValue> list = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComputationModelDataBindingValue model) {
            this.assetModelProperty(model.assetModelProperty);
            this.assetProperty(model.assetProperty);
            this.list(model.list);
        }

        public final AssetModelPropertyBindingValue.Builder getAssetModelProperty() {
            return this.assetModelProperty != null ? this.assetModelProperty.toBuilder() : null;
        }

        public final void setAssetModelProperty(AssetModelPropertyBindingValue.BuilderImpl assetModelProperty) {
            this.assetModelProperty = assetModelProperty != null ? assetModelProperty.build() : null;
        }

        @Override
        public final Builder assetModelProperty(AssetModelPropertyBindingValue assetModelProperty) {
            this.assetModelProperty = assetModelProperty;
            return this;
        }

        public final AssetPropertyBindingValue.Builder getAssetProperty() {
            return this.assetProperty != null ? this.assetProperty.toBuilder() : null;
        }

        public final void setAssetProperty(AssetPropertyBindingValue.BuilderImpl assetProperty) {
            this.assetProperty = assetProperty != null ? assetProperty.build() : null;
        }

        @Override
        public final Builder assetProperty(AssetPropertyBindingValue assetProperty) {
            this.assetProperty = assetProperty;
            return this;
        }

        public final List<Builder> getList() {
            List<Builder> result = BindingValueListCopier.copyToBuilder(this.list);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setList(Collection<BuilderImpl> list) {
            this.list = BindingValueListCopier.copyFromBuilder(list);
        }

        @Override
        public final Builder list(Collection<ComputationModelDataBindingValue> list) {
            this.list = BindingValueListCopier.copy(list);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder list(ComputationModelDataBindingValue ... list) {
            this.list(Arrays.asList(list));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder list(Consumer<Builder> ... list) {
            this.list(Stream.of(list).map(c -> (ComputationModelDataBindingValue)((Builder)ComputationModelDataBindingValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ComputationModelDataBindingValue build() {
            return new ComputationModelDataBindingValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputationModelDataBindingValue> {
        public Builder assetModelProperty(AssetModelPropertyBindingValue var1);

        default public Builder assetModelProperty(Consumer<AssetModelPropertyBindingValue.Builder> assetModelProperty) {
            return this.assetModelProperty((AssetModelPropertyBindingValue)((AssetModelPropertyBindingValue.Builder)AssetModelPropertyBindingValue.builder().applyMutation(assetModelProperty)).build());
        }

        public Builder assetProperty(AssetPropertyBindingValue var1);

        default public Builder assetProperty(Consumer<AssetPropertyBindingValue.Builder> assetProperty) {
            return this.assetProperty((AssetPropertyBindingValue)((AssetPropertyBindingValue.Builder)AssetPropertyBindingValue.builder().applyMutation(assetProperty)).build());
        }

        public Builder list(Collection<ComputationModelDataBindingValue> var1);

        public Builder list(ComputationModelDataBindingValue ... var1);

        public Builder list(Consumer<Builder> ... var1);
    }
}

