/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MonitorErrorCode {
    INTERNAL_FAILURE("INTERNAL_FAILURE"),
    VALIDATION_ERROR("VALIDATION_ERROR"),
    LIMIT_EXCEEDED("LIMIT_EXCEEDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MonitorErrorCode> VALUE_MAP;
    private final String value;

    private MonitorErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MonitorErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MonitorErrorCode> knownValues() {
        EnumSet<MonitorErrorCode> knownValues = EnumSet.allOf(MonitorErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MonitorErrorCode.class, MonitorErrorCode::toString);
    }
}

