/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingUsageSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListComputationModelDataBindingUsagesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListComputationModelDataBindingUsagesResponse;

public class ListComputationModelDataBindingUsagesPublisher
implements SdkPublisher<ListComputationModelDataBindingUsagesResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListComputationModelDataBindingUsagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListComputationModelDataBindingUsagesPublisher(IoTSiteWiseAsyncClient client, ListComputationModelDataBindingUsagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListComputationModelDataBindingUsagesPublisher(IoTSiteWiseAsyncClient client, ListComputationModelDataBindingUsagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListComputationModelDataBindingUsagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListComputationModelDataBindingUsagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ComputationModelDataBindingUsageSummary> dataBindingUsageSummaries() {
        Function<ListComputationModelDataBindingUsagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataBindingUsageSummaries() != null) {
                return response.dataBindingUsageSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListComputationModelDataBindingUsagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListComputationModelDataBindingUsagesResponseFetcher
    implements AsyncPageFetcher<ListComputationModelDataBindingUsagesResponse> {
        private ListComputationModelDataBindingUsagesResponseFetcher() {
        }

        public boolean hasNextPage(ListComputationModelDataBindingUsagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListComputationModelDataBindingUsagesResponse> nextPage(ListComputationModelDataBindingUsagesResponse previousPage) {
            if (previousPage == null) {
                return ListComputationModelDataBindingUsagesPublisher.this.client.listComputationModelDataBindingUsages(ListComputationModelDataBindingUsagesPublisher.this.firstRequest);
            }
            return ListComputationModelDataBindingUsagesPublisher.this.client.listComputationModelDataBindingUsages((ListComputationModelDataBindingUsagesRequest)((Object)ListComputationModelDataBindingUsagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

