/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EntityFilterName {
    NAME("NAME"),
    NAMESPACE("NAMESPACE"),
    SEMANTIC_TYPE_PATH("SEMANTIC_TYPE_PATH"),
    REFERENCED_ENTITY_ID("REFERENCED_ENTITY_ID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EntityFilterName> VALUE_MAP;
    private final String value;

    private EntityFilterName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EntityFilterName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EntityFilterName> knownValues() {
        EnumSet<EntityFilterName> knownValues = EnumSet.allOf(EntityFilterName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EntityFilterName.class, EntityFilterName::toString);
    }
}

