/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphAsyncClient;
import software.amazon.awssdk.services.iotthingsgraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotthingsgraph.model.EntityDescription;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse;

public class SearchEntitiesPublisher
implements SdkPublisher<SearchEntitiesResponse> {
    private final IoTThingsGraphAsyncClient client;
    private final SearchEntitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchEntitiesPublisher(IoTThingsGraphAsyncClient client, SearchEntitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchEntitiesPublisher(IoTThingsGraphAsyncClient client, SearchEntitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchEntitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchEntitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EntityDescription> descriptions() {
        Function<SearchEntitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.descriptions() != null) {
                return response.descriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchEntitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchEntitiesResponseFetcher
    implements AsyncPageFetcher<SearchEntitiesResponse> {
        private SearchEntitiesResponseFetcher() {
        }

        public boolean hasNextPage(SearchEntitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchEntitiesResponse> nextPage(SearchEntitiesResponse previousPage) {
            if (previousPage == null) {
                return SearchEntitiesPublisher.this.client.searchEntities(SearchEntitiesPublisher.this.firstRequest);
            }
            return SearchEntitiesPublisher.this.client.searchEntities((SearchEntitiesRequest)((Object)SearchEntitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

