/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.DestinationType;
import software.amazon.awssdk.services.iottwinmaker.model.IotTwinMakerDestinationConfiguration;
import software.amazon.awssdk.services.iottwinmaker.model.S3DestinationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DestinationConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(DestinationConfiguration.getter(DestinationConfiguration::typeAsString)).setter(DestinationConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<S3DestinationConfiguration> S3_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Configuration").getter(DestinationConfiguration.getter(DestinationConfiguration::s3Configuration)).setter(DestinationConfiguration.setter(Builder::s3Configuration)).constructor(S3DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Configuration").build()}).build();
    private static final SdkField<IotTwinMakerDestinationConfiguration> IOT_TWIN_MAKER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iotTwinMakerConfiguration").getter(DestinationConfiguration.getter(DestinationConfiguration::iotTwinMakerConfiguration)).setter(DestinationConfiguration.setter(Builder::iotTwinMakerConfiguration)).constructor(IotTwinMakerDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotTwinMakerConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, S3_CONFIGURATION_FIELD, IOT_TWIN_MAKER_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final S3DestinationConfiguration s3Configuration;
    private final IotTwinMakerDestinationConfiguration iotTwinMakerConfiguration;

    private DestinationConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.s3Configuration = builder.s3Configuration;
        this.iotTwinMakerConfiguration = builder.iotTwinMakerConfiguration;
    }

    public final DestinationType type() {
        return DestinationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final S3DestinationConfiguration s3Configuration() {
        return this.s3Configuration;
    }

    public final IotTwinMakerDestinationConfiguration iotTwinMakerConfiguration() {
        return this.iotTwinMakerConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotTwinMakerConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationConfiguration)) {
            return false;
        }
        DestinationConfiguration other = (DestinationConfiguration)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.s3Configuration(), other.s3Configuration()) && Objects.equals(this.iotTwinMakerConfiguration(), other.iotTwinMakerConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DestinationConfiguration").add("Type", (Object)this.typeAsString()).add("S3Configuration", (Object)this.s3Configuration()).add("IotTwinMakerConfiguration", (Object)this.iotTwinMakerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "s3Configuration": {
                return Optional.ofNullable(clazz.cast(this.s3Configuration()));
            }
            case "iotTwinMakerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.iotTwinMakerConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationConfiguration, T> g) {
        return obj -> g.apply((DestinationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private S3DestinationConfiguration s3Configuration;
        private IotTwinMakerDestinationConfiguration iotTwinMakerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationConfiguration model) {
            this.type(model.type);
            this.s3Configuration(model.s3Configuration);
            this.iotTwinMakerConfiguration(model.iotTwinMakerConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DestinationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final S3DestinationConfiguration.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3DestinationConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final IotTwinMakerDestinationConfiguration.Builder getIotTwinMakerConfiguration() {
            return this.iotTwinMakerConfiguration != null ? this.iotTwinMakerConfiguration.toBuilder() : null;
        }

        public final void setIotTwinMakerConfiguration(IotTwinMakerDestinationConfiguration.BuilderImpl iotTwinMakerConfiguration) {
            this.iotTwinMakerConfiguration = iotTwinMakerConfiguration != null ? iotTwinMakerConfiguration.build() : null;
        }

        @Override
        public final Builder iotTwinMakerConfiguration(IotTwinMakerDestinationConfiguration iotTwinMakerConfiguration) {
            this.iotTwinMakerConfiguration = iotTwinMakerConfiguration;
            return this;
        }

        public DestinationConfiguration build() {
            return new DestinationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DestinationConfiguration> {
        public Builder type(String var1);

        public Builder type(DestinationType var1);

        public Builder s3Configuration(S3DestinationConfiguration var1);

        default public Builder s3Configuration(Consumer<S3DestinationConfiguration.Builder> s3Configuration) {
            return this.s3Configuration((S3DestinationConfiguration)((S3DestinationConfiguration.Builder)S3DestinationConfiguration.builder().applyMutation(s3Configuration)).build());
        }

        public Builder iotTwinMakerConfiguration(IotTwinMakerDestinationConfiguration var1);

        default public Builder iotTwinMakerConfiguration(Consumer<IotTwinMakerDestinationConfiguration.Builder> iotTwinMakerConfiguration) {
            return this.iotTwinMakerConfiguration((IotTwinMakerDestinationConfiguration)((IotTwinMakerDestinationConfiguration.Builder)IotTwinMakerDestinationConfiguration.builder().applyMutation(iotTwinMakerConfiguration)).build());
        }
    }
}

