/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.CompositeComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CompositeComponentTypesRequestCopier;
import software.amazon.awssdk.services.iottwinmaker.model.ExtendsFromCopier;
import software.amazon.awssdk.services.iottwinmaker.model.FunctionRequest;
import software.amazon.awssdk.services.iottwinmaker.model.FunctionsRequestCopier;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerRequest;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionRequest;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionsRequestCopier;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyGroupRequest;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyGroupsRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateComponentTypeRequest
extends IoTTwinMakerRequest
implements ToCopyableBuilder<Builder, UpdateComponentTypeRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(UpdateComponentTypeRequest.getter(UpdateComponentTypeRequest::workspaceId)).setter(UpdateComponentTypeRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final SdkField<Boolean> IS_SINGLETON_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isSingleton").getter(UpdateComponentTypeRequest.getter(UpdateComponentTypeRequest::isSingleton)).setter(UpdateComponentTypeRequest.setter(Builder::isSingleton)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSingleton").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentTypeId").getter(UpdateComponentTypeRequest.getter(UpdateComponentTypeRequest::componentTypeId)).setter(UpdateComponentTypeRequest.setter(Builder::componentTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("componentTypeId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateComponentTypeRequest.getter(UpdateComponentTypeRequest::description)).setter(UpdateComponentTypeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, PropertyDefinitionRequest>> PROPERTY_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("propertyDefinitions").getter(UpdateComponentTypeRequest.getter(UpdateComponentTypeRequest::propertyDefinitions)).setter(UpdateComponentTypeRequest.setter(Builder::propertyDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyDefinitions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyDefinitionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXTENDS_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("extendsFrom").getter(UpdateComponentTypeRequest.getter(UpdateComponentTypeRequest::extendsFrom)).setter(UpdateComponentTypeRequest.setter(Builder::extendsFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extendsFrom").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, FunctionRequest>> FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("functions").getter(UpdateComponentTypeRequest.getter(UpdateComponentTypeRequest::functions)).setter(UpdateComponentTypeRequest.setter(Builder::functions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FunctionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, PropertyGroupRequest>> PROPERTY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("propertyGroups").getter(UpdateComponentTypeRequest.getter(UpdateComponentTypeRequest::propertyGroups)).setter(UpdateComponentTypeRequest.setter(Builder::propertyGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyGroups").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyGroupRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentTypeName").getter(UpdateComponentTypeRequest.getter(UpdateComponentTypeRequest::componentTypeName)).setter(UpdateComponentTypeRequest.setter(Builder::componentTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeName").build()}).build();
    private static final SdkField<Map<String, CompositeComponentTypeRequest>> COMPOSITE_COMPONENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("compositeComponentTypes").getter(UpdateComponentTypeRequest.getter(UpdateComponentTypeRequest::compositeComponentTypes)).setter(UpdateComponentTypeRequest.setter(Builder::compositeComponentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compositeComponentTypes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompositeComponentTypeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, IS_SINGLETON_FIELD, COMPONENT_TYPE_ID_FIELD, DESCRIPTION_FIELD, PROPERTY_DEFINITIONS_FIELD, EXTENDS_FROM_FIELD, FUNCTIONS_FIELD, PROPERTY_GROUPS_FIELD, COMPONENT_TYPE_NAME_FIELD, COMPOSITE_COMPONENT_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateComponentTypeRequest.memberNameToFieldInitializer();
    private final String workspaceId;
    private final Boolean isSingleton;
    private final String componentTypeId;
    private final String description;
    private final Map<String, PropertyDefinitionRequest> propertyDefinitions;
    private final List<String> extendsFrom;
    private final Map<String, FunctionRequest> functions;
    private final Map<String, PropertyGroupRequest> propertyGroups;
    private final String componentTypeName;
    private final Map<String, CompositeComponentTypeRequest> compositeComponentTypes;

    private UpdateComponentTypeRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.isSingleton = builder.isSingleton;
        this.componentTypeId = builder.componentTypeId;
        this.description = builder.description;
        this.propertyDefinitions = builder.propertyDefinitions;
        this.extendsFrom = builder.extendsFrom;
        this.functions = builder.functions;
        this.propertyGroups = builder.propertyGroups;
        this.componentTypeName = builder.componentTypeName;
        this.compositeComponentTypes = builder.compositeComponentTypes;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final Boolean isSingleton() {
        return this.isSingleton;
    }

    public final String componentTypeId() {
        return this.componentTypeId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasPropertyDefinitions() {
        return this.propertyDefinitions != null && !(this.propertyDefinitions instanceof SdkAutoConstructMap);
    }

    public final Map<String, PropertyDefinitionRequest> propertyDefinitions() {
        return this.propertyDefinitions;
    }

    public final boolean hasExtendsFrom() {
        return this.extendsFrom != null && !(this.extendsFrom instanceof SdkAutoConstructList);
    }

    public final List<String> extendsFrom() {
        return this.extendsFrom;
    }

    public final boolean hasFunctions() {
        return this.functions != null && !(this.functions instanceof SdkAutoConstructMap);
    }

    public final Map<String, FunctionRequest> functions() {
        return this.functions;
    }

    public final boolean hasPropertyGroups() {
        return this.propertyGroups != null && !(this.propertyGroups instanceof SdkAutoConstructMap);
    }

    public final Map<String, PropertyGroupRequest> propertyGroups() {
        return this.propertyGroups;
    }

    public final String componentTypeName() {
        return this.componentTypeName;
    }

    public final boolean hasCompositeComponentTypes() {
        return this.compositeComponentTypes != null && !(this.compositeComponentTypes instanceof SdkAutoConstructMap);
    }

    public final Map<String, CompositeComponentTypeRequest> compositeComponentTypes() {
        return this.compositeComponentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isSingleton());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyDefinitions() ? this.propertyDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExtendsFrom() ? this.extendsFrom() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctions() ? this.functions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyGroups() ? this.propertyGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompositeComponentTypes() ? this.compositeComponentTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComponentTypeRequest)) {
            return false;
        }
        UpdateComponentTypeRequest other = (UpdateComponentTypeRequest)((Object)obj);
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.isSingleton(), other.isSingleton()) && Objects.equals(this.componentTypeId(), other.componentTypeId()) && Objects.equals(this.description(), other.description()) && this.hasPropertyDefinitions() == other.hasPropertyDefinitions() && Objects.equals(this.propertyDefinitions(), other.propertyDefinitions()) && this.hasExtendsFrom() == other.hasExtendsFrom() && Objects.equals(this.extendsFrom(), other.extendsFrom()) && this.hasFunctions() == other.hasFunctions() && Objects.equals(this.functions(), other.functions()) && this.hasPropertyGroups() == other.hasPropertyGroups() && Objects.equals(this.propertyGroups(), other.propertyGroups()) && Objects.equals(this.componentTypeName(), other.componentTypeName()) && this.hasCompositeComponentTypes() == other.hasCompositeComponentTypes() && Objects.equals(this.compositeComponentTypes(), other.compositeComponentTypes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateComponentTypeRequest").add("WorkspaceId", (Object)this.workspaceId()).add("IsSingleton", (Object)this.isSingleton()).add("ComponentTypeId", (Object)this.componentTypeId()).add("Description", (Object)this.description()).add("PropertyDefinitions", this.hasPropertyDefinitions() ? this.propertyDefinitions() : null).add("ExtendsFrom", this.hasExtendsFrom() ? this.extendsFrom() : null).add("Functions", this.hasFunctions() ? this.functions() : null).add("PropertyGroups", this.hasPropertyGroups() ? this.propertyGroups() : null).add("ComponentTypeName", (Object)this.componentTypeName()).add("CompositeComponentTypes", this.hasCompositeComponentTypes() ? this.compositeComponentTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "isSingleton": {
                return Optional.ofNullable(clazz.cast(this.isSingleton()));
            }
            case "componentTypeId": {
                return Optional.ofNullable(clazz.cast(this.componentTypeId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "propertyDefinitions": {
                return Optional.ofNullable(clazz.cast(this.propertyDefinitions()));
            }
            case "extendsFrom": {
                return Optional.ofNullable(clazz.cast(this.extendsFrom()));
            }
            case "functions": {
                return Optional.ofNullable(clazz.cast(this.functions()));
            }
            case "propertyGroups": {
                return Optional.ofNullable(clazz.cast(this.propertyGroups()));
            }
            case "componentTypeName": {
                return Optional.ofNullable(clazz.cast(this.componentTypeName()));
            }
            case "compositeComponentTypes": {
                return Optional.ofNullable(clazz.cast(this.compositeComponentTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("isSingleton", IS_SINGLETON_FIELD);
        map.put("componentTypeId", COMPONENT_TYPE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("propertyDefinitions", PROPERTY_DEFINITIONS_FIELD);
        map.put("extendsFrom", EXTENDS_FROM_FIELD);
        map.put("functions", FUNCTIONS_FIELD);
        map.put("propertyGroups", PROPERTY_GROUPS_FIELD);
        map.put("componentTypeName", COMPONENT_TYPE_NAME_FIELD);
        map.put("compositeComponentTypes", COMPOSITE_COMPONENT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateComponentTypeRequest, T> g) {
        return obj -> g.apply((UpdateComponentTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerRequest.BuilderImpl
    implements Builder {
        private String workspaceId;
        private Boolean isSingleton;
        private String componentTypeId;
        private String description;
        private Map<String, PropertyDefinitionRequest> propertyDefinitions = DefaultSdkAutoConstructMap.getInstance();
        private List<String> extendsFrom = DefaultSdkAutoConstructList.getInstance();
        private Map<String, FunctionRequest> functions = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, PropertyGroupRequest> propertyGroups = DefaultSdkAutoConstructMap.getInstance();
        private String componentTypeName;
        private Map<String, CompositeComponentTypeRequest> compositeComponentTypes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComponentTypeRequest model) {
            super(model);
            this.workspaceId(model.workspaceId);
            this.isSingleton(model.isSingleton);
            this.componentTypeId(model.componentTypeId);
            this.description(model.description);
            this.propertyDefinitions(model.propertyDefinitions);
            this.extendsFrom(model.extendsFrom);
            this.functions(model.functions);
            this.propertyGroups(model.propertyGroups);
            this.componentTypeName(model.componentTypeName);
            this.compositeComponentTypes(model.compositeComponentTypes);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final Boolean getIsSingleton() {
            return this.isSingleton;
        }

        public final void setIsSingleton(Boolean isSingleton) {
            this.isSingleton = isSingleton;
        }

        @Override
        public final Builder isSingleton(Boolean isSingleton) {
            this.isSingleton = isSingleton;
            return this;
        }

        public final String getComponentTypeId() {
            return this.componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, PropertyDefinitionRequest.Builder> getPropertyDefinitions() {
            Map<String, PropertyDefinitionRequest.Builder> result = PropertyDefinitionsRequestCopier.copyToBuilder(this.propertyDefinitions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyDefinitions(Map<String, PropertyDefinitionRequest.BuilderImpl> propertyDefinitions) {
            this.propertyDefinitions = PropertyDefinitionsRequestCopier.copyFromBuilder(propertyDefinitions);
        }

        @Override
        public final Builder propertyDefinitions(Map<String, PropertyDefinitionRequest> propertyDefinitions) {
            this.propertyDefinitions = PropertyDefinitionsRequestCopier.copy(propertyDefinitions);
            return this;
        }

        public final Collection<String> getExtendsFrom() {
            if (this.extendsFrom instanceof SdkAutoConstructList) {
                return null;
            }
            return this.extendsFrom;
        }

        public final void setExtendsFrom(Collection<String> extendsFrom) {
            this.extendsFrom = ExtendsFromCopier.copy(extendsFrom);
        }

        @Override
        public final Builder extendsFrom(Collection<String> extendsFrom) {
            this.extendsFrom = ExtendsFromCopier.copy(extendsFrom);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendsFrom(String ... extendsFrom) {
            this.extendsFrom(Arrays.asList(extendsFrom));
            return this;
        }

        public final Map<String, FunctionRequest.Builder> getFunctions() {
            Map<String, FunctionRequest.Builder> result = FunctionsRequestCopier.copyToBuilder(this.functions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFunctions(Map<String, FunctionRequest.BuilderImpl> functions) {
            this.functions = FunctionsRequestCopier.copyFromBuilder(functions);
        }

        @Override
        public final Builder functions(Map<String, FunctionRequest> functions) {
            this.functions = FunctionsRequestCopier.copy(functions);
            return this;
        }

        public final Map<String, PropertyGroupRequest.Builder> getPropertyGroups() {
            Map<String, PropertyGroupRequest.Builder> result = PropertyGroupsRequestCopier.copyToBuilder(this.propertyGroups);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroups(Map<String, PropertyGroupRequest.BuilderImpl> propertyGroups) {
            this.propertyGroups = PropertyGroupsRequestCopier.copyFromBuilder(propertyGroups);
        }

        @Override
        public final Builder propertyGroups(Map<String, PropertyGroupRequest> propertyGroups) {
            this.propertyGroups = PropertyGroupsRequestCopier.copy(propertyGroups);
            return this;
        }

        public final String getComponentTypeName() {
            return this.componentTypeName;
        }

        public final void setComponentTypeName(String componentTypeName) {
            this.componentTypeName = componentTypeName;
        }

        @Override
        public final Builder componentTypeName(String componentTypeName) {
            this.componentTypeName = componentTypeName;
            return this;
        }

        public final Map<String, CompositeComponentTypeRequest.Builder> getCompositeComponentTypes() {
            Map<String, CompositeComponentTypeRequest.Builder> result = CompositeComponentTypesRequestCopier.copyToBuilder(this.compositeComponentTypes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCompositeComponentTypes(Map<String, CompositeComponentTypeRequest.BuilderImpl> compositeComponentTypes) {
            this.compositeComponentTypes = CompositeComponentTypesRequestCopier.copyFromBuilder(compositeComponentTypes);
        }

        @Override
        public final Builder compositeComponentTypes(Map<String, CompositeComponentTypeRequest> compositeComponentTypes) {
            this.compositeComponentTypes = CompositeComponentTypesRequestCopier.copy(compositeComponentTypes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateComponentTypeRequest build() {
            return new UpdateComponentTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTTwinMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateComponentTypeRequest> {
        public Builder workspaceId(String var1);

        public Builder isSingleton(Boolean var1);

        public Builder componentTypeId(String var1);

        public Builder description(String var1);

        public Builder propertyDefinitions(Map<String, PropertyDefinitionRequest> var1);

        public Builder extendsFrom(Collection<String> var1);

        public Builder extendsFrom(String ... var1);

        public Builder functions(Map<String, FunctionRequest> var1);

        public Builder propertyGroups(Map<String, PropertyGroupRequest> var1);

        public Builder componentTypeName(String var1);

        public Builder compositeComponentTypes(Map<String, CompositeComponentTypeRequest> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

